/*
 * ----------------------------------------------------------------------------
 * character code conversion functions for Korean
 *
 * Author       : Jungho Moon
 * Target MCU   : ATMEL AVR ATmega64/128
 * ----------------------------------------------------------------------------
 */

#define KOR_CODE_GLOBALS

//#include <avr/pgmspace.h>
#include "kor_char_code.h"
#include <stdint.h>
#ifdef KOR_CHAR_CODE

#define MAX_KS_CODE_NUM     2350

uint8_t unicode_table_vowel[] = 
{
    3, 4, 5, 6, 7, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 
    22, 23, 26, 27, 28, 29
};

uint8_t unicode_table_final[] = 
{
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
    17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29
};

uint16_t sg_table[51] = 
{
   0x8841,0x8c41,0x8444,0x9041,0x8446,0x8447,0x9441,0x9841,
   0x9c41,0x844a,0x844b,0x844c,0x844d,0x844e,0x844f,0x8450,
   0xa041,0xa441,0xa841,0x8454,0xac41,0xb041,0xb441,0xb841,
   0xbc41,0xc041,0xc441,0xc841,0xcc41,0xd041,0x8461,0x8481,
   0x84a1,0x84c1,0x84e1,0x8541,0x8561,0x8581,0x85a1,0x85c1,
   0x85e1,0x8641,0x8661,0x8681,0x86a1,0x86c1,0x86e1,0x8741,
   0x8761,0x8781,0x87a1
};

// Korean KSSM code table 
uint8_t kssm_code_table[MAX_KS_CODE_NUM][2]={
//      ������[ KSSM ]        �ϼ��� [ KS ]
        {0x88,0x61},        // ��   0xB0A1  [ 000 ] 1 2 3 1
        {0x88,0x62},        // ��   0xB0A2  [ 001 ] 1 2 3 2
        {0x88,0x65},        // ��   0xB0A3  [ 002 ] 1 2 3 5
        {0x88,0x68},        // ��   0xB0A4  [ 003 ] 1 2 3 8
        {0x88,0x69},        // ��   0xB0A5  [ 004 ] 1 2 3 9
        {0x88,0x6A},        // ��   0xB0A6  [ 005 ] 1 2 3 10
        {0x88,0x6B},        // ��   0xB0A7  [ 006 ] 1 2 3 11
        {0x88,0x71},        // ��   0xB0A8  [ 007 ] 1 2 3 17
        {0x88,0x73},        // ��   0xB0A9  [ 008 ] 1 2 3 19
        {0x88,0x74},        // ��   0xB0AA  [ 009 ] 1 2 3 20
        {0x88,0x75},        // ��   0xB0AB  [ 00a ] 1 2 3 21
        {0x88,0x76},        // ��   0xB0AC  [ 00b ] 1 2 3 22
        {0x88,0x77},        // ��   0xB0AD  [ 00c ] 1 2 3 23
        {0x88,0x78},        // ��   0xB0AE  [ 00d ] 1 2 3 24
        {0x88,0x79},        // ��   0xB0AF  [ 00e ] 1 2 3 25
        {0x88,0x7B},        // ��   0xB0B0  [ 00f ] 1 2 3 27
        {0x88,0x7C},        // ��   0xB0B1  [ 010 ] 1 2 3 28
        {0x88,0x7D},        // ��   0xB0B2  [ 011 ] 1 2 3 29
        {0x88,0x81},        // ��   0xB0B3  [ 012 ] 1 2 4 1
        {0x88,0x82},        // ��   0xB0B4  [ 013 ] 1 2 4 2
        {0x88,0x85},        // ��   0xB0B5  [ 014 ] 1 2 4 5
        {0x88,0x89},        // ��   0xB0B6  [ 015 ] 1 2 4 9
        {0x88,0x91},        // ��   0xB0B7  [ 016 ] 1 2 4 17
        {0x88,0x93},        // ��   0xB0B8  [ 017 ] 1 2 4 19
        {0x88,0x95},        // ��   0xB0B9  [ 018 ] 1 2 4 21
        {0x88,0x96},        // ��   0xB0BA  [ 019 ] 1 2 4 22
        {0x88,0x97},        // ��   0xB0BB  [ 01a ] 1 2 4 23
        {0x88,0xA1},        // ��   0xB0BC  [ 01b ] 1 2 5 1
        {0x88,0xA2},        // ��   0xB0BD  [ 01c ] 1 2 5 2
        {0x88,0xA5},        // ��   0xB0BE  [ 01d ] 1 2 5 5
        {0x88,0xA9},        // ��   0xB0BF  [ 01e ] 1 2 5 9
        {0x88,0xB5},        // ��   0xB0C0  [ 01f ] 1 2 5 21
        {0x88,0xB7},        // ��   0xB0C1  [ 020 ] 1 2 5 23
        {0x88,0xC1},        // ��   0xB0C2  [ 021 ] 1 2 6 1
        {0x88,0xC5},        // ��   0xB0C3  [ 022 ] 1 2 6 5
        {0x88,0xC9},        // ��   0xB0C4  [ 023 ] 1 2 6 9
        {0x88,0xE1},        // ��   0xB0C5  [ 024 ] 1 2 7 1
        {0x88,0xE2},        // ��   0xB0C6  [ 025 ] 1 2 7 2
        {0x88,0xE5},        // ��   0xB0C7  [ 026 ] 1 2 7 5
        {0x88,0xE8},        // ��   0xB0C8  [ 027 ] 1 2 7 8
        {0x88,0xE9},        // ��   0xB0C9  [ 028 ] 1 2 7 9
        {0x88,0xEB},        // ��   0xB0CA  [ 029 ] 1 2 7 11
        {0x88,0xF1},        // ��   0xB0CB  [ 02a ] 1 2 7 17
        {0x88,0xF3},        // ��   0xB0CC  [ 02b ] 1 2 7 19
        {0x88,0xF5},        // ��   0xB0CD  [ 02c ] 1 2 7 21
        {0x88,0xF6},        // ��   0xB0CE  [ 02d ] 1 2 7 22
        {0x88,0xF7},        // ��   0xB0CF  [ 02e ] 1 2 7 23
        {0x88,0xF8},        // ��   0xB0D0  [ 02f ] 1 2 7 24
        {0x88,0xFB},        // ��   0xB0D1  [ 030 ] 1 2 7 27
        {0x88,0xFC},        // ��   0xB0D2  [ 031 ] 1 2 7 28
        {0x88,0xFD},        // ��   0xB0D3  [ 032 ] 1 2 7 29
        {0x89,0x41},        // ��   0xB0D4  [ 033 ] 1 2 10 1
        {0x89,0x45},        // ��   0xB0D5  [ 034 ] 1 2 10 5
        {0x89,0x49},        // ��   0xB0D6  [ 035 ] 1 2 10 9
        {0x89,0x51},        // ��   0xB0D7  [ 036 ] 1 2 10 17
        {0x89,0x53},        // ��   0xB0D8  [ 037 ] 1 2 10 19
        {0x89,0x55},        // ��   0xB0D9  [ 038 ] 1 2 10 21
        {0x89,0x56},        // ��   0xB0DA  [ 039 ] 1 2 10 22
        {0x89,0x57},        // ��   0xB0DB  [ 03a ] 1 2 10 23
        {0x89,0x61},        // ��   0xB0DC  [ 03b ] 1 2 11 1
        {0x89,0x62},        // ��   0xB0DD  [ 03c ] 1 2 11 2
        {0x89,0x63},        // ��   0xB0DE  [ 03d ] 1 2 11 3
        {0x89,0x65},        // ��   0xB0DF  [ 03e ] 1 2 11 5
        {0x89,0x68},        // ��   0xB0E0  [ 03f ] 1 2 11 8
        {0x89,0x69},        // ��   0xB0E1  [ 040 ] 1 2 11 9
        {0x89,0x71},        // ��   0xB0E2  [ 041 ] 1 2 11 17
        {0x89,0x73},        // ��   0xB0E3  [ 042 ] 1 2 11 19
        {0x89,0x75},        // ��   0xB0E4  [ 043 ] 1 2 11 21
        {0x89,0x76},        // ��   0xB0E5  [ 044 ] 1 2 11 22
        {0x89,0x77},        // ��   0xB0E6  [ 045 ] 1 2 11 23
        {0x89,0x7B},        // ��   0xB0E7  [ 046 ] 1 2 11 27
        {0x89,0x81},        // ��   0xB0E8  [ 047 ] 1 2 12 1
        {0x89,0x85},        // ��   0xB0E9  [ 048 ] 1 2 12 5
        {0x89,0x89},        // ��   0xB0EA  [ 049 ] 1 2 12 9
        {0x89,0x93},        // ��   0xB0EB  [ 04a ] 1 2 12 19
        {0x89,0x95},        // ��   0xB0EC  [ 04b ] 1 2 12 21
        {0x89,0xA1},        // ��   0xB0ED  [ 04c ] 1 2 13 1
        {0x89,0xA2},        // ��   0xB0EE  [ 04d ] 1 2 13 2
        {0x89,0xA5},        // ��   0xB0EF  [ 04e ] 1 2 13 5
        {0x89,0xA8},        // ��   0xB0F0  [ 04f ] 1 2 13 8
        {0x89,0xA9},        // ��   0xB0F1  [ 050 ] 1 2 13 9
        {0x89,0xAB},        // ��   0xB0F2  [ 051 ] 1 2 13 11
        {0x89,0xAD},        // ��   0xB0F3  [ 052 ] 1 2 13 13
        {0x89,0xB0},        // ��   0xB0F4  [ 053 ] 1 2 13 16
        {0x89,0xB1},        // ��   0xB0F5  [ 054 ] 1 2 13 17
        {0x89,0xB3},        // ��   0xB0F6  [ 055 ] 1 2 13 19
        {0x89,0xB5},        // ��   0xB0F7  [ 056 ] 1 2 13 21
        {0x89,0xB7},        // ��   0xB0F8  [ 057 ] 1 2 13 23
        {0x89,0xB8},        // ��   0xB0F9  [ 058 ] 1 2 13 24
        {0x89,0xC1},        // ��   0xB0FA  [ 059 ] 1 2 14 1
        {0x89,0xC2},        // ��   0xB0FB  [ 05a ] 1 2 14 2
        {0x89,0xC5},        // ��   0xB0FC  [ 05b ] 1 2 14 5
        {0x89,0xC9},        // ��   0xB0FD  [ 05c ] 1 2 14 9
        {0x89,0xCB},        // ��   0xB0FE  [ 05d ] 1 2 14 11
        {0x89,0xD1},        // ��   0xB1A1  [ 05e ] 1 2 14 17
        {0x89,0xD3},        // ��   0xB1A2  [ 05f ] 1 2 14 19
        {0x89,0xD5},        // ��   0xB1A3  [ 060 ] 1 2 14 21
        {0x89,0xD7},        // ��   0xB1A4  [ 061 ] 1 2 14 23
        {0x89,0xE1},        // ��   0xB1A5  [ 062 ] 1 2 15 1
        {0x89,0xE5},        // ��   0xB1A6  [ 063 ] 1 2 15 5
        {0x89,0xE9},        // ��   0xB1A7  [ 064 ] 1 2 15 9
        {0x89,0xF3},        // ��   0xB1A8  [ 065 ] 1 2 15 19
        {0x89,0xF6},        // ��   0xB1A9  [ 066 ] 1 2 15 22
        {0x89,0xF7},        // ��   0xB1AA  [ 067 ] 1 2 15 23
        {0x8A,0x41},        // ��   0xB1AB  [ 068 ] 1 2 18 1
        {0x8A,0x42},        // ��   0xB1AC  [ 069 ] 1 2 18 2
        {0x8A,0x45},        // ��   0xB1AD  [ 06a ] 1 2 18 5
        {0x8A,0x49},        // ��   0xB1AE  [ 06b ] 1 2 18 9
        {0x8A,0x51},        // ��   0xB1AF  [ 06c ] 1 2 18 17
        {0x8A,0x53},        // ��   0xB1B0  [ 06d ] 1 2 18 19
        {0x8A,0x55},        // ��   0xB1B1  [ 06e ] 1 2 18 21
        {0x8A,0x57},        // ��   0xB1B2  [ 06f ] 1 2 18 23
        {0x8A,0x61},        // ��   0xB1B3  [ 070 ] 1 2 19 1
        {0x8A,0x65},        // ��   0xB1B4  [ 071 ] 1 2 19 5
        {0x8A,0x69},        // ��   0xB1B5  [ 072 ] 1 2 19 9
        {0x8A,0x73},        // ��   0xB1B6  [ 073 ] 1 2 19 19
        {0x8A,0x75},        // ��   0xB1B7  [ 074 ] 1 2 19 21
        {0x8A,0x81},        // ��   0xB1B8  [ 075 ] 1 2 20 1
        {0x8A,0x82},        // ��   0xB1B9  [ 076 ] 1 2 20 2
        {0x8A,0x85},        // ��   0xB1BA  [ 077 ] 1 2 20 5
        {0x8A,0x88},        // ��   0xB1BB  [ 078 ] 1 2 20 8
        {0x8A,0x89},        // ��   0xB1BC  [ 079 ] 1 2 20 9
        {0x8A,0x8A},        // ��   0xB1BD  [ 07a ] 1 2 20 10
        {0x8A,0x8B},        // ��   0xB1BE  [ 07b ] 1 2 20 11
        {0x8A,0x90},        // ��   0xB1BF  [ 07c ] 1 2 20 16
        {0x8A,0x91},        // ��   0xB1C0  [ 07d ] 1 2 20 17
        {0x8A,0x93},        // ��   0xB1C1  [ 07e ] 1 2 20 19
        {0x8A,0x95},        // ��   0xB1C2  [ 07f ] 1 2 20 21
        {0x8A,0x97},        // ��   0xB1C3  [ 080 ] 1 2 20 23
        {0x8A,0x98},        // ��   0xB1C4  [ 081 ] 1 2 20 24
        {0x8A,0xA1},        // ��   0xB1C5  [ 082 ] 1 2 21 1
        {0x8A,0xA2},        // ��   0xB1C6  [ 083 ] 1 2 21 2
        {0x8A,0xA5},        // ��   0xB1C7  [ 084 ] 1 2 21 5
        {0x8A,0xA9},        // ��   0xB1C8  [ 085 ] 1 2 21 9
        {0x8A,0xB6},        // ��   0xB1C9  [ 086 ] 1 2 21 22
        {0x8A,0xB7},        // ��   0xB1CA  [ 087 ] 1 2 21 23
        {0x8A,0xC1},        // ��   0xB1CB  [ 088 ] 1 2 22 1
        {0x8A,0xD5},        // ��   0xB1CC  [ 089 ] 1 2 22 21
        {0x8A,0xE1},        // ��   0xB1CD  [ 08a ] 1 2 23 1
        {0x8A,0xE2},        // ��   0xB1CE  [ 08b ] 1 2 23 2
        {0x8A,0xE5},        // ��   0xB1CF  [ 08c ] 1 2 23 5
        {0x8A,0xE9},        // ��   0xB1D0  [ 08d ] 1 2 23 9
        {0x8A,0xF1},        // ��   0xB1D1  [ 08e ] 1 2 23 17
        {0x8A,0xF3},        // ��   0xB1D2  [ 08f ] 1 2 23 19
        {0x8A,0xF5},        // ��   0xB1D3  [ 090 ] 1 2 23 21
        {0x8B,0x41},        // ��   0xB1D4  [ 091 ] 1 2 26 1
        {0x8B,0x45},        // ��   0xB1D5  [ 092 ] 1 2 26 5
        {0x8B,0x49},        // ��   0xB1D6  [ 093 ] 1 2 26 9
        {0x8B,0x61},        // ��   0xB1D7  [ 094 ] 1 2 27 1
        {0x8B,0x62},        // ��   0xB1D8  [ 095 ] 1 2 27 2
        {0x8B,0x65},        // ��   0xB1D9  [ 096 ] 1 2 27 5
        {0x8B,0x68},        // ��   0xB1DA  [ 097 ] 1 2 27 8
        {0x8B,0x69},        // ��   0xB1DB  [ 098 ] 1 2 27 9
        {0x8B,0x6A},        // ��   0xB1DC  [ 099 ] 1 2 27 10
        {0x8B,0x71},        // ��   0xB1DD  [ 09a ] 1 2 27 17
        {0x8B,0x73},        // ��   0xB1DE  [ 09b ] 1 2 27 19
        {0x8B,0x75},        // ��   0xB1DF  [ 09c ] 1 2 27 21
        {0x8B,0x77},        // ��   0xB1E0  [ 09d ] 1 2 27 23
        {0x8B,0x81},        // ��   0xB1E1  [ 09e ] 1 2 28 1
        {0x8B,0xA1},        // ��   0xB1E2  [ 09f ] 1 2 29 1
        {0x8B,0xA2},        // ��   0xB1E3  [ 0a0 ] 1 2 29 2
        {0x8B,0xA5},        // ��   0xB1E4  [ 0a1 ] 1 2 29 5
        {0x8B,0xA8},        // ��   0xB1E5  [ 0a2 ] 1 2 29 8
        {0x8B,0xA9},        // ��   0xB1E6  [ 0a3 ] 1 2 29 9
        {0x8B,0xAB},        // ��   0xB1E7  [ 0a4 ] 1 2 29 11
        {0x8B,0xB1},        // ��   0xB1E8  [ 0a5 ] 1 2 29 17
        {0x8B,0xB3},        // ��   0xB1E9  [ 0a6 ] 1 2 29 19
        {0x8B,0xB5},        // ��   0xB1EA  [ 0a7 ] 1 2 29 21
        {0x8B,0xB7},        // ��   0xB1EB  [ 0a8 ] 1 2 29 23
        {0x8B,0xB8},        // ��   0xB1EC  [ 0a9 ] 1 2 29 24
        {0x8B,0xBC},        // ��   0xB1ED  [ 0aa ] 1 2 29 28
        {0x8C,0x61},        // ��   0xB1EE  [ 0ab ] 1 3 3 1
        {0x8C,0x62},        // ��   0xB1EF  [ 0ac ] 1 3 3 2
        {0x8C,0x63},        // ��   0xB1F0  [ 0ad ] 1 3 3 3
        {0x8C,0x65},        // ��   0xB1F1  [ 0ae ] 1 3 3 5
        {0x8C,0x69},        // ��   0xB1F2  [ 0af ] 1 3 3 9
        {0x8C,0x6B},        // ��   0xB1F3  [ 0b0 ] 1 3 3 11
        {0x8C,0x71},        // ��   0xB1F4  [ 0b1 ] 1 3 3 17
        {0x8C,0x73},        // ��   0xB1F5  [ 0b2 ] 1 3 3 19
        {0x8C,0x75},        // ��   0xB1F6  [ 0b3 ] 1 3 3 21
        {0x8C,0x76},        // ��   0xB1F7  [ 0b4 ] 1 3 3 22
        {0x8C,0x77},        // ��   0xB1F8  [ 0b5 ] 1 3 3 23
        {0x8C,0x7B},        // ��   0xB1F9  [ 0b6 ] 1 3 3 27
        {0x8C,0x81},        // ��   0xB1FA  [ 0b7 ] 1 3 4 1
        {0x8C,0x82},        // ��   0xB1FB  [ 0b8 ] 1 3 4 2
        {0x8C,0x85},        // ��   0xB1FC  [ 0b9 ] 1 3 4 5
        {0x8C,0x89},        // ��   0xB1FD  [ 0ba ] 1 3 4 9
        {0x8C,0x91},        // ��   0xB1FE  [ 0bb ] 1 3 4 17
        {0x8C,0x93},        // ��   0xB2A1  [ 0bc ] 1 3 4 19
        {0x8C,0x95},        // ��   0xB2A2  [ 0bd ] 1 3 4 21
        {0x8C,0x96},        // ��   0xB2A3  [ 0be ] 1 3 4 22
        {0x8C,0x97},        // ��   0xB2A4  [ 0bf ] 1 3 4 23
        {0x8C,0xA1},        // ��   0xB2A5  [ 0c0 ] 1 3 5 1
        {0x8C,0xA2},        // ��   0xB2A6  [ 0c1 ] 1 3 5 2
        {0x8C,0xA9},        // ��   0xB2A7  [ 0c2 ] 1 3 5 9
        {0x8C,0xE1},        // ��   0xB2A8  [ 0c3 ] 1 3 7 1
        {0x8C,0xE2},        // ��   0xB2A9  [ 0c4 ] 1 3 7 2
        {0x8C,0xE3},        // ��   0xB2AA  [ 0c5 ] 1 3 7 3
        {0x8C,0xE5},        // ��   0xB2AB  [ 0c6 ] 1 3 7 5
        {0x8C,0xE9},        // ��   0xB2AC  [ 0c7 ] 1 3 7 9
        {0x8C,0xF1},        // ��   0xB2AD  [ 0c8 ] 1 3 7 17
        {0x8C,0xF3},        // ��   0xB2AE  [ 0c9 ] 1 3 7 19
        {0x8C,0xF5},        // ��   0xB2AF  [ 0ca ] 1 3 7 21
        {0x8C,0xF6},        // ��   0xB2B0  [ 0cb ] 1 3 7 22
        {0x8C,0xF7},        // ��   0xB2B1  [ 0cc ] 1 3 7 23
        {0x8D,0x41},        // ��   0xB2B2  [ 0cd ] 1 3 10 1
        {0x8D,0x42},        // ��   0xB2B3  [ 0ce ] 1 3 10 2
        {0x8D,0x45},        // ��   0xB2B4  [ 0cf ] 1 3 10 5
        {0x8D,0x51},        // ��   0xB2B5  [ 0d0 ] 1 3 10 17
        {0x8D,0x55},        // ��   0xB2B6  [ 0d1 ] 1 3 10 21
        {0x8D,0x57},        // ��   0xB2B7  [ 0d2 ] 1 3 10 23
        {0x8D,0x61},        // ��   0xB2B8  [ 0d3 ] 1 3 11 1
        {0x8D,0x65},        // ��   0xB2B9  [ 0d4 ] 1 3 11 5
        {0x8D,0x69},        // ��   0xB2BA  [ 0d5 ] 1 3 11 9
        {0x8D,0x75},        // ��   0xB2BB  [ 0d6 ] 1 3 11 21
        {0x8D,0x76},        // ��   0xB2BC  [ 0d7 ] 1 3 11 22
        {0x8D,0x7B},        // ��   0xB2BD  [ 0d8 ] 1 3 11 27
        {0x8D,0x81},        // ��   0xB2BE  [ 0d9 ] 1 3 12 1
        {0x8D,0xA1},        // ��   0xB2BF  [ 0da ] 1 3 13 1
        {0x8D,0xA2},        // ��   0xB2C0  [ 0db ] 1 3 13 2
        {0x8D,0xA5},        // ��   0xB2C1  [ 0dc ] 1 3 13 5
        {0x8D,0xA7},        // ��   0xB2C2  [ 0dd ] 1 3 13 7
        {0x8D,0xA9},        // ��   0xB2C3  [ 0de ] 1 3 13 9
        {0x8D,0xB1},        // ��   0xB2C4  [ 0df ] 1 3 13 17
        {0x8D,0xB3},        // ��   0xB2C5  [ 0e0 ] 1 3 13 19
        {0x8D,0xB5},        // ��   0xB2C6  [ 0e1 ] 1 3 13 21
        {0x8D,0xB7},        // ��   0xB2C7  [ 0e2 ] 1 3 13 23
        {0x8D,0xB8},        // ��   0xB2C8  [ 0e3 ] 1 3 13 24
        {0x8D,0xB9},        // ��   0xB2C9  [ 0e4 ] 1 3 13 25
        {0x8D,0xC1},        // ��   0xB2CA  [ 0e5 ] 1 3 14 1
        {0x8D,0xC2},        // ��   0xB2CB  [ 0e6 ] 1 3 14 2
        {0x8D,0xC9},        // ��   0xB2CC  [ 0e7 ] 1 3 14 9
        {0x8D,0xD6},        // ��   0xB2CD  [ 0e8 ] 1 3 14 22
        {0x8D,0xD7},        // ��   0xB2CE  [ 0e9 ] 1 3 14 23
        {0x8D,0xE1},        // ��   0xB2CF  [ 0ea ] 1 3 15 1
        {0x8D,0xE2},        // ��   0xB2D0  [ 0eb ] 1 3 15 2
        {0x8D,0xF7},        // ��   0xB2D1  [ 0ec ] 1 3 15 23
        {0x8E,0x41},        // ��   0xB2D2  [ 0ed ] 1 3 18 1
        {0x8E,0x45},        // ��   0xB2D3  [ 0ee ] 1 3 18 5
        {0x8E,0x49},        // ��   0xB2D4  [ 0ef ] 1 3 18 9
        {0x8E,0x51},        // ��   0xB2D5  [ 0f0 ] 1 3 18 17
        {0x8E,0x53},        // ��   0xB2D6  [ 0f1 ] 1 3 18 19
        {0x8E,0x57},        // ��   0xB2D7  [ 0f2 ] 1 3 18 23
        {0x8E,0x61},        // ��   0xB2D8  [ 0f3 ] 1 3 19 1
        {0x8E,0x81},        // ��   0xB2D9  [ 0f4 ] 1 3 20 1
        {0x8E,0x82},        // ��   0xB2DA  [ 0f5 ] 1 3 20 2
        {0x8E,0x85},        // ��   0xB2DB  [ 0f6 ] 1 3 20 5
        {0x8E,0x89},        // ��   0xB2DC  [ 0f7 ] 1 3 20 9
        {0x8E,0x90},        // ��   0xB2DD  [ 0f8 ] 1 3 20 16
        {0x8E,0x91},        // ��   0xB2DE  [ 0f9 ] 1 3 20 17
        {0x8E,0x93},        // ��   0xB2DF  [ 0fa ] 1 3 20 19
        {0x8E,0x95},        // ��   0xB2E0  [ 0fb ] 1 3 20 21
        {0x8E,0x97},        // ��   0xB2E1  [ 0fc ] 1 3 20 23
        {0x8E,0x98},        // ��   0xB2E2  [ 0fd ] 1 3 20 24
        {0x8E,0xA1},        // ��   0xB2E3  [ 0fe ] 1 3 21 1
        {0x8E,0xA9},        // ��   0xB2E4  [ 0ff ] 1 3 21 9
        {0x8E,0xB6},        // ��   0xB2E5  [ 100 ] 1 3 21 22
        {0x8E,0xB7},        // ��   0xB2E6  [ 101 ] 1 3 21 23
        {0x8E,0xC1},        // ��   0xB2E7  [ 102 ] 1 3 22 1
        {0x8E,0xC2},        // ��   0xB2E8  [ 103 ] 1 3 22 2
        {0x8E,0xC5},        // ��   0xB2E9  [ 104 ] 1 3 22 5
        {0x8E,0xC9},        // ��   0xB2EA  [ 105 ] 1 3 22 9
        {0x8E,0xD1},        // ��   0xB2EB  [ 106 ] 1 3 22 17
        {0x8E,0xD3},        // ��   0xB2EC  [ 107 ] 1 3 22 19
        {0x8E,0xD6},        // ��   0xB2ED  [ 108 ] 1 3 22 22
        {0x8E,0xE1},        // ��   0xB2EE  [ 109 ] 1 3 23 1
        {0x8E,0xE5},        // ��   0xB2EF  [ 10a ] 1 3 23 5
        {0x8E,0xE9},        // ��   0xB2F0  [ 10b ] 1 3 23 9
        {0x8E,0xF1},        // ��   0xB2F1  [ 10c ] 1 3 23 17
        {0x8E,0xF3},        // ��   0xB2F2  [ 10d ] 1 3 23 19
        {0x8F,0x41},        // ��   0xB2F3  [ 10e ] 1 3 26 1
        {0x8F,0x61},        // ��   0xB2F4  [ 10f ] 1 3 27 1
        {0x8F,0x62},        // ��   0xB2F5  [ 110 ] 1 3 27 2
        {0x8F,0x65},        // ��   0xB2F6  [ 111 ] 1 3 27 5
        {0x8F,0x67},        // ��   0xB2F7  [ 112 ] 1 3 27 7
        {0x8F,0x69},        // ��   0xB2F8  [ 113 ] 1 3 27 9
        {0x8F,0x6B},        // ��   0xB2F9  [ 114 ] 1 3 27 11
        {0x8F,0x70},        // ��   0xB2FA  [ 115 ] 1 3 27 16
        {0x8F,0x71},        // ��   0xB2FB  [ 116 ] 1 3 27 17
        {0x8F,0x73},        // ��   0xB2FC  [ 117 ] 1 3 27 19
        {0x8F,0x75},        // ��   0xB2FD  [ 118 ] 1 3 27 21
        {0x8F,0x77},        // ��   0xB2FE  [ 119 ] 1 3 27 23
        {0x8F,0x7B},        // ��   0xB3A1  [ 11a ] 1 3 27 27
        {0x8F,0xA1},        // ��   0xB3A2  [ 11b ] 1 3 29 1
        {0x8F,0xA2},        // ��   0xB3A3  [ 11c ] 1 3 29 2
        {0x8F,0xA5},        // ��   0xB3A4  [ 11d ] 1 3 29 5
        {0x8F,0xA9},        // ��   0xB3A5  [ 11e ] 1 3 29 9
        {0x8F,0xB1},        // ��   0xB3A6  [ 11f ] 1 3 29 17
        {0x8F,0xB3},        // ��   0xB3A7  [ 120 ] 1 3 29 19
        {0x8F,0xB5},        // ��   0xB3A8  [ 121 ] 1 3 29 21
        {0x8F,0xB7},        // ��   0xB3A9  [ 122 ] 1 3 29 23
        {0x90,0x61},        // ��   0xB3AA  [ 123 ] 1 4 3 1
        {0x90,0x62},        // ��   0xB3AB  [ 124 ] 1 4 3 2
        {0x90,0x63},        // ��   0xB3AC  [ 125 ] 1 4 3 3
        {0x90,0x65},        // ��   0xB3AD  [ 126 ] 1 4 3 5
        {0x90,0x68},        // ��   0xB3AE  [ 127 ] 1 4 3 8
        {0x90,0x69},        // ��   0xB3AF  [ 128 ] 1 4 3 9
        {0x90,0x6A},        // ��   0xB3B0  [ 129 ] 1 4 3 10
        {0x90,0x6B},        // ��   0xB3B1  [ 12a ] 1 4 3 11
        {0x90,0x71},        // ��   0xB3B2  [ 12b ] 1 4 3 17
        {0x90,0x73},        // ��   0xB3B3  [ 12c ] 1 4 3 19
        {0x90,0x75},        // ��   0xB3B4  [ 12d ] 1 4 3 21
        {0x90,0x76},        // ��   0xB3B5  [ 12e ] 1 4 3 22
        {0x90,0x77},        // ��   0xB3B6  [ 12f ] 1 4 3 23
        {0x90,0x78},        // ��   0xB3B7  [ 130 ] 1 4 3 24
        {0x90,0x79},        // ��   0xB3B8  [ 131 ] 1 4 3 25
        {0x90,0x7B},        // ��   0xB3B9  [ 132 ] 1 4 3 27
        {0x90,0x7D},        // ��   0xB3BA  [ 133 ] 1 4 3 29
        {0x90,0x81},        // ��   0xB3BB  [ 134 ] 1 4 4 1
        {0x90,0x82},        // ��   0xB3BC  [ 135 ] 1 4 4 2
        {0x90,0x85},        // ��   0xB3BD  [ 136 ] 1 4 4 5
        {0x90,0x89},        // ��   0xB3BE  [ 137 ] 1 4 4 9
        {0x90,0x91},        // ��   0xB3BF  [ 138 ] 1 4 4 17
        {0x90,0x93},        // ��   0xB3C0  [ 139 ] 1 4 4 19
        {0x90,0x95},        // ��   0xB3C1  [ 13a ] 1 4 4 21
        {0x90,0x96},        // ��   0xB3C2  [ 13b ] 1 4 4 22
        {0x90,0x97},        // ��   0xB3C3  [ 13c ] 1 4 4 23
        {0x90,0xA1},        // ��   0xB3C4  [ 13d ] 1 4 5 1
        {0x90,0xA2},        // ��   0xB3C5  [ 13e ] 1 4 5 2
        {0x90,0xA5},        // ��   0xB3C6  [ 13f ] 1 4 5 5
        {0x90,0xA9},        // ��   0xB3C7  [ 140 ] 1 4 5 9
        {0x90,0xB1},        // ��   0xB3C8  [ 141 ] 1 4 5 17
        {0x90,0xB7},        // ��   0xB3C9  [ 142 ] 1 4 5 23
        {0x90,0xE1},        // ��   0xB3CA  [ 143 ] 1 4 7 1
        {0x90,0xE2},        // ��   0xB3CB  [ 144 ] 1 4 7 2
        {0x90,0xE4},        // ��   0xB3CC  [ 145 ] 1 4 7 4
        {0x90,0xE5},        // ��   0xB3CD  [ 146 ] 1 4 7 5
        {0x90,0xE9},        // ��   0xB3CE  [ 147 ] 1 4 7 9
        {0x90,0xEB},        // ��   0xB3CF  [ 148 ] 1 4 7 11
        {0x90,0xEC},        // ��   0xB3D0  [ 149 ] 1 4 7 12
        {0x90,0xF1},        // ��   0xB3D1  [ 14a ] 1 4 7 17
        {0x90,0xF3},        // ��   0xB3D2  [ 14b ] 1 4 7 19
        {0x90,0xF5},        // ��   0xB3D3  [ 14c ] 1 4 7 21
        {0x90,0xF6},        // ��   0xB3D4  [ 14d ] 1 4 7 22
        {0x90,0xF7},        // ��   0xB3D5  [ 14e ] 1 4 7 23
        {0x90,0xFD},        // ��   0xB3D6  [ 14f ] 1 4 7 29
        {0x91,0x41},        // ��   0xB3D7  [ 150 ] 1 4 10 1
        {0x91,0x42},        // ��   0xB3D8  [ 151 ] 1 4 10 2
        {0x91,0x45},        // ��   0xB3D9  [ 152 ] 1 4 10 5
        {0x91,0x49},        // ��   0xB3DA  [ 153 ] 1 4 10 9
        {0x91,0x51},        // ��   0xB3DB  [ 154 ] 1 4 10 17
        {0x91,0x53},        // ��   0xB3DC  [ 155 ] 1 4 10 19
        {0x91,0x55},        // ��   0xB3DD  [ 156 ] 1 4 10 21
        {0x91,0x56},        // ��   0xB3DE  [ 157 ] 1 4 10 22
        {0x91,0x57},        // ��   0xB3DF  [ 158 ] 1 4 10 23
        {0x91,0x61},        // ��   0xB3E0  [ 159 ] 1 4 11 1
        {0x91,0x62},        // ��   0xB3E1  [ 15a ] 1 4 11 2
        {0x91,0x65},        // ��   0xB3E2  [ 15b ] 1 4 11 5
        {0x91,0x69},        // ��   0xB3E3  [ 15c ] 1 4 11 9
        {0x91,0x71},        // ��   0xB3E4  [ 15d ] 1 4 11 17
        {0x91,0x73},        // ��   0xB3E5  [ 15e ] 1 4 11 19
        {0x91,0x76},        // ��   0xB3E6  [ 15f ] 1 4 11 22
        {0x91,0x77},        // ��   0xB3E7  [ 160 ] 1 4 11 23
        {0x91,0x7A},        // ��   0xB3E8  [ 161 ] 1 4 11 26
        {0x91,0x81},        // ��   0xB3E9  [ 162 ] 1 4 12 1
        {0x91,0x85},        // ��   0xB3EA  [ 163 ] 1 4 12 5
        {0x91,0xA1},        // ��   0xB3EB  [ 164 ] 1 4 13 1
        {0x91,0xA2},        // ��   0xB3EC  [ 165 ] 1 4 13 2
        {0x91,0xA5},        // ��   0xB3ED  [ 166 ] 1 4 13 5
        {0x91,0xA9},        // ��   0xB3EE  [ 167 ] 1 4 13 9
        {0x91,0xAB},        // ��   0xB3EF  [ 168 ] 1 4 13 11
        {0x91,0xB1},        // ��   0xB3F0  [ 169 ] 1 4 13 17
        {0x91,0xB3},        // ��   0xB3F1  [ 16a ] 1 4 13 19
        {0x91,0xB5},        // ��   0xB3F2  [ 16b ] 1 4 13 21
        {0x91,0xB7},        // ��   0xB3F3  [ 16c ] 1 4 13 23
        {0x91,0xBC},        // ��   0xB3F4  [ 16d ] 1 4 13 28
        {0x91,0xBD},        // ��   0xB3F5  [ 16e ] 1 4 13 29
        {0x91,0xC1},        // ��   0xB3F6  [ 16f ] 1 4 14 1
        {0x91,0xC5},        // ��   0xB3F7  [ 170 ] 1 4 14 5
        {0x91,0xC9},        // ��   0xB3F8  [ 171 ] 1 4 14 9
        {0x91,0xD6},        // ��   0xB3F9  [ 172 ] 1 4 14 22
        {0x92,0x41},        // ��   0xB3FA  [ 173 ] 1 4 18 1
        {0x92,0x45},        // ��   0xB3FB  [ 174 ] 1 4 18 5
        {0x92,0x49},        // ��   0xB3FC  [ 175 ] 1 4 18 9
        {0x92,0x51},        // ��   0xB3FD  [ 176 ] 1 4 18 17
        {0x92,0x53},        // ��   0xB3FE  [ 177 ] 1 4 18 19
        {0x92,0x55},        // ��   0xB4A1  [ 178 ] 1 4 18 21
        {0x92,0x61},        // ��   0xB4A2  [ 179 ] 1 4 19 1
        {0x92,0x62},        // ��   0xB4A3  [ 17a ] 1 4 19 2
        {0x92,0x65},        // ��   0xB4A4  [ 17b ] 1 4 19 5
        {0x92,0x69},        // ��   0xB4A5  [ 17c ] 1 4 19 9
        {0x92,0x73},        // ��   0xB4A6  [ 17d ] 1 4 19 19
        {0x92,0x75},        // ��   0xB4A7  [ 17e ] 1 4 19 21
        {0x92,0x77},        // ��   0xB4A8  [ 17f ] 1 4 19 23
        {0x92,0x81},        // ��   0xB4A9  [ 180 ] 1 4 20 1
        {0x92,0x82},        // ��   0xB4AA  [ 181 ] 1 4 20 2
        {0x92,0x85},        // ��   0xB4AB  [ 182 ] 1 4 20 5
        {0x92,0x88},        // ��   0xB4AC  [ 183 ] 1 4 20 8
        {0x92,0x89},        // ��   0xB4AD  [ 184 ] 1 4 20 9
        {0x92,0x91},        // ��   0xB4AE  [ 185 ] 1 4 20 17
        {0x92,0x93},        // ��   0xB4AF  [ 186 ] 1 4 20 19
        {0x92,0x95},        // ��   0xB4B0  [ 187 ] 1 4 20 21
        {0x92,0x97},        // ��   0xB4B1  [ 188 ] 1 4 20 23
        {0x92,0xA1},        // ��   0xB4B2  [ 189 ] 1 4 21 1
        {0x92,0xB6},        // ��   0xB4B3  [ 18a ] 1 4 21 22
        {0x92,0xC1},        // ��   0xB4B4  [ 18b ] 1 4 22 1
        {0x92,0xE1},        // ��   0xB4B5  [ 18c ] 1 4 23 1
        {0x92,0xE5},        // ��   0xB4B6  [ 18d ] 1 4 23 5
        {0x92,0xE9},        // ��   0xB4B7  [ 18e ] 1 4 23 9
        {0x92,0xF1},        // ��   0xB4B8  [ 18f ] 1 4 23 17
        {0x92,0xF3},        // ��   0xB4B9  [ 190 ] 1 4 23 19
        {0x93,0x41},        // ��   0xB4BA  [ 191 ] 1 4 26 1
        {0x93,0x42},        // ��   0xB4BB  [ 192 ] 1 4 26 2
        {0x93,0x49},        // ��   0xB4BC  [ 193 ] 1 4 26 9
        {0x93,0x51},        // ��   0xB4BD  [ 194 ] 1 4 26 17
        {0x93,0x53},        // ��   0xB4BE  [ 195 ] 1 4 26 19
        {0x93,0x57},        // ��   0xB4BF  [ 196 ] 1 4 26 23
        {0x93,0x61},        // ��   0xB4C0  [ 197 ] 1 4 27 1
        {0x93,0x62},        // ��   0xB4C1  [ 198 ] 1 4 27 2
        {0x93,0x65},        // ��   0xB4C2  [ 199 ] 1 4 27 5
        {0x93,0x69},        // ��   0xB4C3  [ 19a ] 1 4 27 9
        {0x93,0x6A},        // ��   0xB4C4  [ 19b ] 1 4 27 10
        {0x93,0x6B},        // ��   0xB4C5  [ 19c ] 1 4 27 11
        {0x93,0x71},        // ��   0xB4C6  [ 19d ] 1 4 27 17
        {0x93,0x73},        // ��   0xB4C7  [ 19e ] 1 4 27 19
        {0x93,0x75},        // ��   0xB4C8  [ 19f ] 1 4 27 21
        {0x93,0x77},        // ��   0xB4C9  [ 1a0 ] 1 4 27 23
        {0x93,0x78},        // ��   0xB4CA  [ 1a1 ] 1 4 27 24
        {0x93,0x7C},        // ��   0xB4CB  [ 1a2 ] 1 4 27 28
        {0x93,0x81},        // ��   0xB4CC  [ 1a3 ] 1 4 28 1
        {0x93,0x85},        // ��   0xB4CD  [ 1a4 ] 1 4 28 5
        {0x93,0x89},        // ��   0xB4CE  [ 1a5 ] 1 4 28 9
        {0x93,0xA1},        // ��   0xB4CF  [ 1a6 ] 1 4 29 1
        {0x93,0xA2},        // ��   0xB4D0  [ 1a7 ] 1 4 29 2
        {0x93,0xA5},        // ��   0xB4D1  [ 1a8 ] 1 4 29 5
        {0x93,0xA9},        // ��   0xB4D2  [ 1a9 ] 1 4 29 9
        {0x93,0xAB},        // ��   0xB4D3  [ 1aa ] 1 4 29 11
        {0x93,0xB1},        // ��   0xB4D4  [ 1ab ] 1 4 29 17
        {0x93,0xB3},        // ��   0xB4D5  [ 1ac ] 1 4 29 19
        {0x93,0xB5},        // ��   0xB4D6  [ 1ad ] 1 4 29 21
        {0x93,0xB7},        // ��   0xB4D7  [ 1ae ] 1 4 29 23
        {0x93,0xBC},        // ��   0xB4D8  [ 1af ] 1 4 29 28
        {0x94,0x61},        // ��   0xB4D9  [ 1b0 ] 1 5 3 1
        {0x94,0x62},        // ��   0xB4DA  [ 1b1 ] 1 5 3 2
        {0x94,0x63},        // ��   0xB4DB  [ 1b2 ] 1 5 3 3
        {0x94,0x65},        // ��   0xB4DC  [ 1b3 ] 1 5 3 5
        {0x94,0x68},        // ��   0xB4DD  [ 1b4 ] 1 5 3 8
        {0x94,0x69},        // ��   0xB4DE  [ 1b5 ] 1 5 3 9
        {0x94,0x6A},        // ��   0xB4DF  [ 1b6 ] 1 5 3 10
        {0x94,0x6B},        // ��   0xB4E0  [ 1b7 ] 1 5 3 11
        {0x94,0x6C},        // ��   0xB4E1  [ 1b8 ] 1 5 3 12
        {0x94,0x70},        // ��   0xB4E2  [ 1b9 ] 1 5 3 16
        {0x94,0x71},        // ��   0xB4E3  [ 1ba ] 1 5 3 17
        {0x94,0x73},        // ��   0xB4E4  [ 1bb ] 1 5 3 19
        {0x94,0x75},        // ��   0xB4E5  [ 1bc ] 1 5 3 21
        {0x94,0x76},        // ��   0xB4E6  [ 1bd ] 1 5 3 22
        {0x94,0x77},        // ��   0xB4E7  [ 1be ] 1 5 3 23
        {0x94,0x78},        // ��   0xB4E8  [ 1bf ] 1 5 3 24
        {0x94,0x79},        // ��   0xB4E9  [ 1c0 ] 1 5 3 25
        {0x94,0x7D},        // ��   0xB4EA  [ 1c1 ] 1 5 3 29
        {0x94,0x81},        // ��   0xB4EB  [ 1c2 ] 1 5 4 1
        {0x94,0x82},        // ��   0xB4EC  [ 1c3 ] 1 5 4 2
        {0x94,0x85},        // ��   0xB4ED  [ 1c4 ] 1 5 4 5
        {0x94,0x89},        // ��   0xB4EE  [ 1c5 ] 1 5 4 9
        {0x94,0x91},        // ��   0xB4EF  [ 1c6 ] 1 5 4 17
        {0x94,0x93},        // ��   0xB4F0  [ 1c7 ] 1 5 4 19
        {0x94,0x95},        // ��   0xB4F1  [ 1c8 ] 1 5 4 21
        {0x94,0x96},        // ��   0xB4F2  [ 1c9 ] 1 5 4 22
        {0x94,0x97},        // ��   0xB4F3  [ 1ca ] 1 5 4 23
        {0x94,0xA1},        // ��   0xB4F4  [ 1cb ] 1 5 5 1
        {0x94,0xE1},        // ��   0xB4F5  [ 1cc ] 1 5 7 1
        {0x94,0xE2},        // ��   0xB4F6  [ 1cd ] 1 5 7 2
        {0x94,0xE3},        // ��   0xB4F7  [ 1ce ] 1 5 7 3
        {0x94,0xE5},        // ��   0xB4F8  [ 1cf ] 1 5 7 5
        {0x94,0xE8},        // ��   0xB4F9  [ 1d0 ] 1 5 7 8
        {0x94,0xE9},        // ��   0xB4FA  [ 1d1 ] 1 5 7 9
        {0x94,0xEB},        // ��   0xB4FB  [ 1d2 ] 1 5 7 11
        {0x94,0xEC},        // ��   0xB4FC  [ 1d3 ] 1 5 7 12
        {0x94,0xF1},        // ��   0xB4FD  [ 1d4 ] 1 5 7 17
        {0x94,0xF3},        // ��   0xB4FE  [ 1d5 ] 1 5 7 19
        {0x94,0xF5},        // ��   0xB5A1  [ 1d6 ] 1 5 7 21
        {0x94,0xF7},        // ��   0xB5A2  [ 1d7 ] 1 5 7 23
        {0x94,0xF9},        // ��   0xB5A3  [ 1d8 ] 1 5 7 25
        {0x94,0xFC},        // ��   0xB5A4  [ 1d9 ] 1 5 7 28
        {0x95,0x41},        // ��   0xB5A5  [ 1da ] 1 5 10 1
        {0x95,0x42},        // ��   0xB5A6  [ 1db ] 1 5 10 2
        {0x95,0x45},        // ��   0xB5A7  [ 1dc ] 1 5 10 5
        {0x95,0x49},        // ��   0xB5A8  [ 1dd ] 1 5 10 9
        {0x95,0x51},        // ��   0xB5A9  [ 1de ] 1 5 10 17
        {0x95,0x53},        // ��   0xB5AA  [ 1df ] 1 5 10 19
        {0x95,0x55},        // ��   0xB5AB  [ 1e0 ] 1 5 10 21
        {0x95,0x56},        // ��   0xB5AC  [ 1e1 ] 1 5 10 22
        {0x95,0x57},        // ��   0xB5AD  [ 1e2 ] 1 5 10 23
        {0x95,0x61},        // ��   0xB5AE  [ 1e3 ] 1 5 11 1
        {0x95,0x65},        // ��   0xB5AF  [ 1e4 ] 1 5 11 5
        {0x95,0x69},        // ��   0xB5B0  [ 1e5 ] 1 5 11 9
        {0x95,0x76},        // ��   0xB5B1  [ 1e6 ] 1 5 11 22
        {0x95,0x77},        // ��   0xB5B2  [ 1e7 ] 1 5 11 23
        {0x95,0x81},        // ��   0xB5B3  [ 1e8 ] 1 5 12 1
        {0x95,0x85},        // ��   0xB5B4  [ 1e9 ] 1 5 12 5
        {0x95,0xA1},        // ��   0xB5B5  [ 1ea ] 1 5 13 1
        {0x95,0xA2},        // ��   0xB5B6  [ 1eb ] 1 5 13 2
        {0x95,0xA5},        // ��   0xB5B7  [ 1ec ] 1 5 13 5
        {0x95,0xA8},        // ��   0xB5B8  [ 1ed ] 1 5 13 8
        {0x95,0xA9},        // ��   0xB5B9  [ 1ee ] 1 5 13 9
        {0x95,0xAB},        // ��   0xB5BA  [ 1ef ] 1 5 13 11
        {0x95,0xAD},        // ��   0xB5BB  [ 1f0 ] 1 5 13 13
        {0x95,0xB1},        // ��   0xB5BC  [ 1f1 ] 1 5 13 17
        {0x95,0xB3},        // ��   0xB5BD  [ 1f2 ] 1 5 13 19
        {0x95,0xB5},        // ��   0xB5BE  [ 1f3 ] 1 5 13 21
        {0x95,0xB7},        // ��   0xB5BF  [ 1f4 ] 1 5 13 23
        {0x95,0xB9},        // ��   0xB5C0  [ 1f5 ] 1 5 13 25
        {0x95,0xBB},        // ��   0xB5C1  [ 1f6 ] 1 5 13 27
        {0x95,0xC1},        // ��   0xB5C2  [ 1f7 ] 1 5 14 1
        {0x95,0xC5},        // ��   0xB5C3  [ 1f8 ] 1 5 14 5
        {0x95,0xC9},        // ��   0xB5C4  [ 1f9 ] 1 5 14 9
        {0x95,0xE1},        // ��   0xB5C5  [ 1fa ] 1 5 15 1
        {0x95,0xF6},        // ��   0xB5C6  [ 1fb ] 1 5 15 22
        {0x96,0x41},        // ��   0xB5C7  [ 1fc ] 1 5 18 1
        {0x96,0x45},        // ��   0xB5C8  [ 1fd ] 1 5 18 5
        {0x96,0x49},        // ��   0xB5C9  [ 1fe ] 1 5 18 9
        {0x96,0x51},        // ��   0xB5CA  [ 1ff ] 1 5 18 17
        {0x96,0x53},        // ��   0xB5CB  [ 200 ] 1 5 18 19
        {0x96,0x55},        // ��   0xB5CC  [ 201 ] 1 5 18 21
        {0x96,0x61},        // ��   0xB5CD  [ 202 ] 1 5 19 1
        {0x96,0x81},        // ��   0xB5CE  [ 203 ] 1 5 20 1
        {0x96,0x82},        // ��   0xB5CF  [ 204 ] 1 5 20 2
        {0x96,0x85},        // ��   0xB5D0  [ 205 ] 1 5 20 5
        {0x96,0x89},        // ��   0xB5D1  [ 206 ] 1 5 20 9
        {0x96,0x91},        // ��   0xB5D2  [ 207 ] 1 5 20 17
        {0x96,0x93},        // ��   0xB5D3  [ 208 ] 1 5 20 19
        {0x96,0x95},        // ��   0xB5D4  [ 209 ] 1 5 20 21
        {0x96,0x97},        // ��   0xB5D5  [ 20a ] 1 5 20 23
        {0x96,0xA1},        // ��   0xB5D6  [ 20b ] 1 5 21 1
        {0x96,0xB6},        // ��   0xB5D7  [ 20c ] 1 5 21 22
        {0x96,0xC1},        // ��   0xB5D8  [ 20d ] 1 5 22 1
        {0x96,0xD7},        // ��   0xB5D9  [ 20e ] 1 5 22 23
        {0x96,0xE1},        // ��   0xB5DA  [ 20f ] 1 5 23 1
        {0x96,0xE5},        // ��   0xB5DB  [ 210 ] 1 5 23 5
        {0x96,0xE9},        // ��   0xB5DC  [ 211 ] 1 5 23 9
        {0x96,0xF3},        // ��   0xB5DD  [ 212 ] 1 5 23 19
        {0x96,0xF5},        // ��   0xB5DE  [ 213 ] 1 5 23 21
        {0x96,0xF7},        // ��   0xB5DF  [ 214 ] 1 5 23 23
        {0x97,0x41},        // ��   0xB5E0  [ 215 ] 1 5 26 1
        {0x97,0x45},        // ��   0xB5E1  [ 216 ] 1 5 26 5
        {0x97,0x49},        // ��   0xB5E2  [ 217 ] 1 5 26 9
        {0x97,0x51},        // ��   0xB5E3  [ 218 ] 1 5 26 17
        {0x97,0x57},        // ��   0xB5E4  [ 219 ] 1 5 26 23
        {0x97,0x61},        // ��   0xB5E5  [ 21a ] 1 5 27 1
        {0x97,0x62},        // ��   0xB5E6  [ 21b ] 1 5 27 2
        {0x97,0x65},        // ��   0xB5E7  [ 21c ] 1 5 27 5
        {0x97,0x68},        // ��   0xB5E8  [ 21d ] 1 5 27 8
        {0x97,0x69},        // ��   0xB5E9  [ 21e ] 1 5 27 9
        {0x97,0x6B},        // ��   0xB5EA  [ 21f ] 1 5 27 11
        {0x97,0x71},        // ��   0xB5EB  [ 220 ] 1 5 27 17
        {0x97,0x73},        // ��   0xB5EC  [ 221 ] 1 5 27 19
        {0x97,0x75},        // ��   0xB5ED  [ 222 ] 1 5 27 21
        {0x97,0x77},        // ��   0xB5EE  [ 223 ] 1 5 27 23
        {0x97,0x81},        // ��   0xB5EF  [ 224 ] 1 5 28 1
        {0x97,0xA1},        // ��   0xB5F0  [ 225 ] 1 5 29 1
        {0x97,0xA2},        // ��   0xB5F1  [ 226 ] 1 5 29 2
        {0x97,0xA5},        // ��   0xB5F2  [ 227 ] 1 5 29 5
        {0x97,0xA8},        // ��   0xB5F3  [ 228 ] 1 5 29 8
        {0x97,0xA9},        // ��   0xB5F4  [ 229 ] 1 5 29 9
        {0x97,0xB1},        // ��   0xB5F5  [ 22a ] 1 5 29 17
        {0x97,0xB3},        // ��   0xB5F6  [ 22b ] 1 5 29 19
        {0x97,0xB5},        // ��   0xB5F7  [ 22c ] 1 5 29 21
        {0x97,0xB6},        // ��   0xB5F8  [ 22d ] 1 5 29 22
        {0x97,0xB7},        // ��   0xB5F9  [ 22e ] 1 5 29 23
        {0x97,0xB8},        // ��   0xB5FA  [ 22f ] 1 5 29 24
        {0x98,0x61},        // ��   0xB5FB  [ 230 ] 1 6 3 1
        {0x98,0x62},        // ��   0xB5FC  [ 231 ] 1 6 3 2
        {0x98,0x65},        // ��   0xB5FD  [ 232 ] 1 6 3 5
        {0x98,0x69},        // ��   0xB5FE  [ 233 ] 1 6 3 9
        {0x98,0x71},        // ��   0xB6A1  [ 234 ] 1 6 3 17
        {0x98,0x73},        // ��   0xB6A2  [ 235 ] 1 6 3 19
        {0x98,0x75},        // ��   0xB6A3  [ 236 ] 1 6 3 21
        {0x98,0x76},        // ��   0xB6A4  [ 237 ] 1 6 3 22
        {0x98,0x77},        // ��   0xB6A5  [ 238 ] 1 6 3 23
        {0x98,0x7D},        // ��   0xB6A6  [ 239 ] 1 6 3 29
        {0x98,0x81},        // ��   0xB6A7  [ 23a ] 1 6 4 1
        {0x98,0x82},        // ��   0xB6A8  [ 23b ] 1 6 4 2
        {0x98,0x85},        // ��   0xB6A9  [ 23c ] 1 6 4 5
        {0x98,0x89},        // ��   0xB6AA  [ 23d ] 1 6 4 9
        {0x98,0x91},        // ��   0xB6AB  [ 23e ] 1 6 4 17
        {0x98,0x93},        // ��   0xB6AC  [ 23f ] 1 6 4 19
        {0x98,0x95},        // ��   0xB6AD  [ 240 ] 1 6 4 21
        {0x98,0x96},        // ��   0xB6AE  [ 241 ] 1 6 4 22
        {0x98,0x97},        // ��   0xB6AF  [ 242 ] 1 6 4 23
        {0x98,0xE1},        // ��   0xB6B0  [ 243 ] 1 6 7 1
        {0x98,0xE2},        // ��   0xB6B1  [ 244 ] 1 6 7 2
        {0x98,0xE5},        // ��   0xB6B2  [ 245 ] 1 6 7 5
        {0x98,0xE9},        // ��   0xB6B3  [ 246 ] 1 6 7 9
        {0x98,0xEB},        // ��   0xB6B4  [ 247 ] 1 6 7 11
        {0x98,0xEC},        // ��   0xB6B5  [ 248 ] 1 6 7 12
        {0x98,0xF1},        // ��   0xB6B6  [ 249 ] 1 6 7 17
        {0x98,0xF3},        // ��   0xB6B7  [ 24a ] 1 6 7 19
        {0x98,0xF5},        // ��   0xB6B8  [ 24b ] 1 6 7 21
        {0x98,0xF6},        // ��   0xB6B9  [ 24c ] 1 6 7 22
        {0x98,0xF7},        // ��   0xB6BA  [ 24d ] 1 6 7 23
        {0x98,0xFD},        // ��   0xB6BB  [ 24e ] 1 6 7 29
        {0x99,0x41},        // ��   0xB6BC  [ 24f ] 1 6 10 1
        {0x99,0x42},        // ��   0xB6BD  [ 250 ] 1 6 10 2
        {0x99,0x45},        // ��   0xB6BE  [ 251 ] 1 6 10 5
        {0x99,0x49},        // ��   0xB6BF  [ 252 ] 1 6 10 9
        {0x99,0x51},        // ��   0xB6C0  [ 253 ] 1 6 10 17
        {0x99,0x53},        // ��   0xB6C1  [ 254 ] 1 6 10 19
        {0x99,0x55},        // ��   0xB6C2  [ 255 ] 1 6 10 21
        {0x99,0x56},        // ��   0xB6C3  [ 256 ] 1 6 10 22
        {0x99,0x57},        // ��   0xB6C4  [ 257 ] 1 6 10 23
        {0x99,0x61},        // ��   0xB6C5  [ 258 ] 1 6 11 1
        {0x99,0x76},        // ��   0xB6C6  [ 259 ] 1 6 11 22
        {0x99,0xA1},        // ��   0xB6C7  [ 25a ] 1 6 13 1
        {0x99,0xA2},        // ��   0xB6C8  [ 25b ] 1 6 13 2
        {0x99,0xA5},        // ��   0xB6C9  [ 25c ] 1 6 13 5
        {0x99,0xA9},        // ��   0xB6CA  [ 25d ] 1 6 13 9
        {0x99,0xB7},        // ��   0xB6CB  [ 25e ] 1 6 13 23
        {0x99,0xC1},        // ��   0xB6CC  [ 25f ] 1 6 14 1
        {0x99,0xC9},        // ��   0xB6CD  [ 260 ] 1 6 14 9
        {0x99,0xE1},        // ��   0xB6CE  [ 261 ] 1 6 15 1
        {0x9A,0x41},        // ��   0xB6CF  [ 262 ] 1 6 18 1
        {0x9A,0x45},        // ��   0xB6D0  [ 263 ] 1 6 18 5
        {0x9A,0x81},        // ��   0xB6D1  [ 264 ] 1 6 20 1
        {0x9A,0x82},        // ��   0xB6D2  [ 265 ] 1 6 20 2
        {0x9A,0x85},        // ��   0xB6D3  [ 266 ] 1 6 20 5
        {0x9A,0x89},        // ��   0xB6D4  [ 267 ] 1 6 20 9
        {0x9A,0x90},        // ��   0xB6D5  [ 268 ] 1 6 20 16
        {0x9A,0x91},        // ��   0xB6D6  [ 269 ] 1 6 20 17
        {0x9A,0x97},        // ��   0xB6D7  [ 26a ] 1 6 20 23
        {0x9A,0xC1},        // ��   0xB6D8  [ 26b ] 1 6 22 1
        {0x9A,0xE1},        // ��   0xB6D9  [ 26c ] 1 6 23 1
        {0x9A,0xE5},        // ��   0xB6DA  [ 26d ] 1 6 23 5
        {0x9A,0xE9},        // ��   0xB6DB  [ 26e ] 1 6 23 9
        {0x9A,0xF1},        // ��   0xB6DC  [ 26f ] 1 6 23 17
        {0x9A,0xF3},        // ��   0xB6DD  [ 270 ] 1 6 23 19
        {0x9A,0xF7},        // ��   0xB6DE  [ 271 ] 1 6 23 23
        {0x9B,0x61},        // ��   0xB6DF  [ 272 ] 1 6 27 1
        {0x9B,0x62},        // ��   0xB6E0  [ 273 ] 1 6 27 2
        {0x9B,0x65},        // ��   0xB6E1  [ 274 ] 1 6 27 5
        {0x9B,0x68},        // ��   0xB6E2  [ 275 ] 1 6 27 8
        {0x9B,0x69},        // ��   0xB6E3  [ 276 ] 1 6 27 9
        {0x9B,0x71},        // ��   0xB6E4  [ 277 ] 1 6 27 17
        {0x9B,0x73},        // ��   0xB6E5  [ 278 ] 1 6 27 19
        {0x9B,0x75},        // ��   0xB6E6  [ 279 ] 1 6 27 21
        {0x9B,0x81},        // ��   0xB6E7  [ 27a ] 1 6 28 1
        {0x9B,0x85},        // ��   0xB6E8  [ 27b ] 1 6 28 5
        {0x9B,0x89},        // ��   0xB6E9  [ 27c ] 1 6 28 9
        {0x9B,0x91},        // ��   0xB6EA  [ 27d ] 1 6 28 17
        {0x9B,0x93},        // ��   0xB6EB  [ 27e ] 1 6 28 19
        {0x9B,0xA1},        // ��   0xB6EC  [ 27f ] 1 6 29 1
        {0x9B,0xA5},        // ��   0xB6ED  [ 280 ] 1 6 29 5
        {0x9B,0xA9},        // ��   0xB6EE  [ 281 ] 1 6 29 9
        {0x9B,0xB1},        // ��   0xB6EF  [ 282 ] 1 6 29 17
        {0x9B,0xB3},        // ��   0xB6F0  [ 283 ] 1 6 29 19
        {0x9B,0xB5},        // ��   0xB6F1  [ 284 ] 1 6 29 21
        {0x9B,0xB7},        // ��   0xB6F2  [ 285 ] 1 6 29 23
        {0x9C,0x61},        // ��   0xB6F3  [ 286 ] 1 7 3 1
        {0x9C,0x62},        // ��   0xB6F4  [ 287 ] 1 7 3 2
        {0x9C,0x65},        // ��   0xB6F5  [ 288 ] 1 7 3 5
        {0x9C,0x69},        // ��   0xB6F6  [ 289 ] 1 7 3 9
        {0x9C,0x71},        // ��   0xB6F7  [ 28a ] 1 7 3 17
        {0x9C,0x73},        // ��   0xB6F8  [ 28b ] 1 7 3 19
        {0x9C,0x75},        // ��   0xB6F9  [ 28c ] 1 7 3 21
        {0x9C,0x76},        // ��   0xB6FA  [ 28d ] 1 7 3 22
        {0x9C,0x77},        // ��   0xB6FB  [ 28e ] 1 7 3 23
        {0x9C,0x78},        // ��   0xB6FC  [ 28f ] 1 7 3 24
        {0x9C,0x7C},        // ��   0xB6FD  [ 290 ] 1 7 3 28
        {0x9C,0x7D},        // ��   0xB6FE  [ 291 ] 1 7 3 29
        {0x9C,0x81},        // ��   0xB7A1  [ 292 ] 1 7 4 1
        {0x9C,0x82},        // ��   0xB7A2  [ 293 ] 1 7 4 2
        {0x9C,0x85},        // ��   0xB7A3  [ 294 ] 1 7 4 5
        {0x9C,0x89},        // ��   0xB7A4  [ 295 ] 1 7 4 9
        {0x9C,0x91},        // ��   0xB7A5  [ 296 ] 1 7 4 17
        {0x9C,0x93},        // ��   0xB7A6  [ 297 ] 1 7 4 19
        {0x9C,0x95},        // ��   0xB7A7  [ 298 ] 1 7 4 21
        {0x9C,0x96},        // ��   0xB7A8  [ 299 ] 1 7 4 22
        {0x9C,0x97},        // ��   0xB7A9  [ 29a ] 1 7 4 23
        {0x9C,0xA1},        // ��   0xB7AA  [ 29b ] 1 7 5 1
        {0x9C,0xA2},        // ��   0xB7AB  [ 29c ] 1 7 5 2
        {0x9C,0xA5},        // ��   0xB7AC  [ 29d ] 1 7 5 5
        {0x9C,0xB5},        // ��   0xB7AD  [ 29e ] 1 7 5 21
        {0x9C,0xB7},        // ��   0xB7AE  [ 29f ] 1 7 5 23
        {0x9C,0xE1},        // ��   0xB7AF  [ 2a0 ] 1 7 7 1
        {0x9C,0xE2},        // ��   0xB7B0  [ 2a1 ] 1 7 7 2
        {0x9C,0xE5},        // ��   0xB7B1  [ 2a2 ] 1 7 7 5
        {0x9C,0xE9},        // ��   0xB7B2  [ 2a3 ] 1 7 7 9
        {0x9C,0xF1},        // ��   0xB7B3  [ 2a4 ] 1 7 7 17
        {0x9C,0xF3},        // ��   0xB7B4  [ 2a5 ] 1 7 7 19
        {0x9C,0xF5},        // ��   0xB7B5  [ 2a6 ] 1 7 7 21
        {0x9C,0xF6},        // ��   0xB7B6  [ 2a7 ] 1 7 7 22
        {0x9C,0xF7},        // ��   0xB7B7  [ 2a8 ] 1 7 7 23
        {0x9C,0xFD},        // ��   0xB7B8  [ 2a9 ] 1 7 7 29
        {0x9D,0x41},        // ��   0xB7B9  [ 2aa ] 1 7 10 1
        {0x9D,0x42},        // ��   0xB7BA  [ 2ab ] 1 7 10 2
        {0x9D,0x45},        // ��   0xB7BB  [ 2ac ] 1 7 10 5
        {0x9D,0x49},        // ��   0xB7BC  [ 2ad ] 1 7 10 9
        {0x9D,0x51},        // ��   0xB7BD  [ 2ae ] 1 7 10 17
        {0x9D,0x53},        // ��   0xB7BE  [ 2af ] 1 7 10 19
        {0x9D,0x55},        // ��   0xB7BF  [ 2b0 ] 1 7 10 21
        {0x9D,0x57},        // ��   0xB7C0  [ 2b1 ] 1 7 10 23
        {0x9D,0x61},        // ��   0xB7C1  [ 2b2 ] 1 7 11 1
        {0x9D,0x62},        // ��   0xB7C2  [ 2b3 ] 1 7 11 2
        {0x9D,0x65},        // ��   0xB7C3  [ 2b4 ] 1 7 11 5
        {0x9D,0x69},        // ��   0xB7C4  [ 2b5 ] 1 7 11 9
        {0x9D,0x71},        // ��   0xB7C5  [ 2b6 ] 1 7 11 17
        {0x9D,0x73},        // ��   0xB7C6  [ 2b7 ] 1 7 11 19
        {0x9D,0x75},        // ��   0xB7C7  [ 2b8 ] 1 7 11 21
        {0x9D,0x76},        // ��   0xB7C8  [ 2b9 ] 1 7 11 22
        {0x9D,0x77},        // ��   0xB7C9  [ 2ba ] 1 7 11 23
        {0x9D,0x81},        // ��   0xB7CA  [ 2bb ] 1 7 12 1
        {0x9D,0x85},        // ��   0xB7CB  [ 2bc ] 1 7 12 5
        {0x9D,0x93},        // ��   0xB7CC  [ 2bd ] 1 7 12 19
        {0x9D,0x95},        // ��   0xB7CD  [ 2be ] 1 7 12 21
        {0x9D,0xA1},        // ��   0xB7CE  [ 2bf ] 1 7 13 1
        {0x9D,0xA2},        // ��   0xB7CF  [ 2c0 ] 1 7 13 2
        {0x9D,0xA5},        // ��   0xB7D0  [ 2c1 ] 1 7 13 5
        {0x9D,0xA9},        // ��   0xB7D1  [ 2c2 ] 1 7 13 9
        {0x9D,0xB1},        // ��   0xB7D2  [ 2c3 ] 1 7 13 17
        {0x9D,0xB3},        // ��   0xB7D3  [ 2c4 ] 1 7 13 19
        {0x9D,0xB5},        // ��   0xB7D4  [ 2c5 ] 1 7 13 21
        {0x9D,0xB7},        // ��   0xB7D5  [ 2c6 ] 1 7 13 23
        {0x9D,0xC1},        // ��   0xB7D6  [ 2c7 ] 1 7 14 1
        {0x9D,0xC5},        // ��   0xB7D7  [ 2c8 ] 1 7 14 5
        {0x9D,0xD7},        // ��   0xB7D8  [ 2c9 ] 1 7 14 23
        {0x9D,0xF6},        // ��   0xB7D9  [ 2ca ] 1 7 15 22
        {0x9E,0x41},        // ��   0xB7DA  [ 2cb ] 1 7 18 1
        {0x9E,0x45},        // ��   0xB7DB  [ 2cc ] 1 7 18 5
        {0x9E,0x49},        // ��   0xB7DC  [ 2cd ] 1 7 18 9
        {0x9E,0x51},        // ��   0xB7DD  [ 2ce ] 1 7 18 17
        {0x9E,0x53},        // ��   0xB7DE  [ 2cf ] 1 7 18 19
        {0x9E,0x55},        // ��   0xB7DF  [ 2d0 ] 1 7 18 21
        {0x9E,0x57},        // ��   0xB7E0  [ 2d1 ] 1 7 18 23
        {0x9E,0x61},        // ��   0xB7E1  [ 2d2 ] 1 7 19 1
        {0x9E,0x65},        // ��   0xB7E2  [ 2d3 ] 1 7 19 5
        {0x9E,0x69},        // ��   0xB7E3  [ 2d4 ] 1 7 19 9
        {0x9E,0x73},        // ��   0xB7E4  [ 2d5 ] 1 7 19 19
        {0x9E,0x75},        // ��   0xB7E5  [ 2d6 ] 1 7 19 21
        {0x9E,0x77},        // ��   0xB7E6  [ 2d7 ] 1 7 19 23
        {0x9E,0x81},        // ��   0xB7E7  [ 2d8 ] 1 7 20 1
        {0x9E,0x82},        // ��   0xB7E8  [ 2d9 ] 1 7 20 2
        {0x9E,0x85},        // ��   0xB7E9  [ 2da ] 1 7 20 5
        {0x9E,0x89},        // ��   0xB7EA  [ 2db ] 1 7 20 9
        {0x9E,0x91},        // ��   0xB7EB  [ 2dc ] 1 7 20 17
        {0x9E,0x93},        // ��   0xB7EC  [ 2dd ] 1 7 20 19
        {0x9E,0x95},        // ��   0xB7ED  [ 2de ] 1 7 20 21
        {0x9E,0x97},        // ��   0xB7EE  [ 2df ] 1 7 20 23
        {0x9E,0xA1},        // ��   0xB7EF  [ 2e0 ] 1 7 21 1
        {0x9E,0xB6},        // ��   0xB7F0  [ 2e1 ] 1 7 21 22
        {0x9E,0xC1},        // ��   0xB7F1  [ 2e2 ] 1 7 22 1
        {0x9E,0xE1},        // ��   0xB7F2  [ 2e3 ] 1 7 23 1
        {0x9E,0xE2},        // ��   0xB7F3  [ 2e4 ] 1 7 23 2
        {0x9E,0xE5},        // ��   0xB7F4  [ 2e5 ] 1 7 23 5
        {0x9E,0xE9},        // ��   0xB7F5  [ 2e6 ] 1 7 23 9
        {0x9E,0xF1},        // ��   0xB7F6  [ 2e7 ] 1 7 23 17
        {0x9E,0xF5},        // ��   0xB7F7  [ 2e8 ] 1 7 23 21
        {0x9E,0xF7},        // ��   0xB7F8  [ 2e9 ] 1 7 23 23
        {0x9F,0x41},        // ��   0xB7F9  [ 2ea ] 1 7 26 1
        {0x9F,0x42},        // ��   0xB7FA  [ 2eb ] 1 7 26 2
        {0x9F,0x45},        // ��   0xB7FB  [ 2ec ] 1 7 26 5
        {0x9F,0x49},        // ��   0xB7FC  [ 2ed ] 1 7 26 9
        {0x9F,0x51},        // ��   0xB7FD  [ 2ee ] 1 7 26 17
        {0x9F,0x53},        // ��   0xB7FE  [ 2ef ] 1 7 26 19
        {0x9F,0x55},        // ��   0xB8A1  [ 2f0 ] 1 7 26 21
        {0x9F,0x57},        // ��   0xB8A2  [ 2f1 ] 1 7 26 23
        {0x9F,0x61},        // ��   0xB8A3  [ 2f2 ] 1 7 27 1
        {0x9F,0x62},        // ��   0xB8A4  [ 2f3 ] 1 7 27 2
        {0x9F,0x65},        // ��   0xB8A5  [ 2f4 ] 1 7 27 5
        {0x9F,0x69},        // ��   0xB8A6  [ 2f5 ] 1 7 27 9
        {0x9F,0x71},        // ��   0xB8A7  [ 2f6 ] 1 7 27 17
        {0x9F,0x73},        // ��   0xB8A8  [ 2f7 ] 1 7 27 19
        {0x9F,0x75},        // ��   0xB8A9  [ 2f8 ] 1 7 27 21
        {0x9F,0x77},        // ��   0xB8AA  [ 2f9 ] 1 7 27 23
        {0x9F,0x78},        // ��   0xB8AB  [ 2fa ] 1 7 27 24
        {0x9F,0x7B},        // ��   0xB8AC  [ 2fb ] 1 7 27 27
        {0x9F,0x7C},        // ��   0xB8AD  [ 2fc ] 1 7 27 28
        {0x9F,0xA1},        // ��   0xB8AE  [ 2fd ] 1 7 29 1
        {0x9F,0xA2},        // ��   0xB8AF  [ 2fe ] 1 7 29 2
        {0x9F,0xA5},        // ��   0xB8B0  [ 2ff ] 1 7 29 5
        {0x9F,0xA9},        // ��   0xB8B1  [ 300 ] 1 7 29 9
        {0x9F,0xB1},        // ��   0xB8B2  [ 301 ] 1 7 29 17
        {0x9F,0xB3},        // ��   0xB8B3  [ 302 ] 1 7 29 19
        {0x9F,0xB5},        // ��   0xB8B4  [ 303 ] 1 7 29 21
        {0x9F,0xB7},        // ��   0xB8B5  [ 304 ] 1 7 29 23
        {0xA0,0x61},        // ��   0xB8B6  [ 305 ] 1 8 3 1
        {0xA0,0x62},        // ��   0xB8B7  [ 306 ] 1 8 3 2
        {0xA0,0x65},        // ��   0xB8B8  [ 307 ] 1 8 3 5
        {0xA0,0x67},        // ��   0xB8B9  [ 308 ] 1 8 3 7
        {0xA0,0x68},        // ��   0xB8BA  [ 309 ] 1 8 3 8
        {0xA0,0x69},        // ��   0xB8BB  [ 30a ] 1 8 3 9
        {0xA0,0x6A},        // ��   0xB8BC  [ 30b ] 1 8 3 10
        {0xA0,0x6B},        // ��   0xB8BD  [ 30c ] 1 8 3 11
        {0xA0,0x71},        // ��   0xB8BE  [ 30d ] 1 8 3 17
        {0xA0,0x73},        // ��   0xB8BF  [ 30e ] 1 8 3 19
        {0xA0,0x75},        // ��   0xB8C0  [ 30f ] 1 8 3 21
        {0xA0,0x77},        // ��   0xB8C1  [ 310 ] 1 8 3 23
        {0xA0,0x78},        // ��   0xB8C2  [ 311 ] 1 8 3 24
        {0xA0,0x7B},        // ��   0xB8C3  [ 312 ] 1 8 3 27
        {0xA0,0x7D},        // ��   0xB8C4  [ 313 ] 1 8 3 29
        {0xA0,0x81},        // ��   0xB8C5  [ 314 ] 1 8 4 1
        {0xA0,0x82},        // ��   0xB8C6  [ 315 ] 1 8 4 2
        {0xA0,0x85},        // ��   0xB8C7  [ 316 ] 1 8 4 5
        {0xA0,0x89},        // ��   0xB8C8  [ 317 ] 1 8 4 9
        {0xA0,0x91},        // ��   0xB8C9  [ 318 ] 1 8 4 17
        {0xA0,0x93},        // ��   0xB8CA  [ 319 ] 1 8 4 19
        {0xA0,0x95},        // ��   0xB8CB  [ 31a ] 1 8 4 21
        {0xA0,0x96},        // ��   0xB8CC  [ 31b ] 1 8 4 22
        {0xA0,0x97},        // ��   0xB8CD  [ 31c ] 1 8 4 23
        {0xA0,0x98},        // ��   0xB8CE  [ 31d ] 1 8 4 24
        {0xA0,0xA1},        // ��   0xB8CF  [ 31e ] 1 8 5 1
        {0xA0,0xA2},        // ��   0xB8D0  [ 31f ] 1 8 5 2
        {0xA0,0xA9},        // ��   0xB8D1  [ 320 ] 1 8 5 9
        {0xA0,0xB7},        // ��   0xB8D2  [ 321 ] 1 8 5 23
        {0xA0,0xE1},        // ��   0xB8D3  [ 322 ] 1 8 7 1
        {0xA0,0xE2},        // ��   0xB8D4  [ 323 ] 1 8 7 2
        {0xA0,0xE5},        // ��   0xB8D5  [ 324 ] 1 8 7 5
        {0xA0,0xE9},        // ��   0xB8D6  [ 325 ] 1 8 7 9
        {0xA0,0xEB},        // ��   0xB8D7  [ 326 ] 1 8 7 11
        {0xA0,0xF1},        // ��   0xB8D8  [ 327 ] 1 8 7 17
        {0xA0,0xF3},        // ��   0xB8D9  [ 328 ] 1 8 7 19
        {0xA0,0xF5},        // ��   0xB8DA  [ 329 ] 1 8 7 21
        {0xA0,0xF7},        // ��   0xB8DB  [ 32a ] 1 8 7 23
        {0xA0,0xF8},        // ��   0xB8DC  [ 32b ] 1 8 7 24
        {0xA0,0xFD},        // ��   0xB8DD  [ 32c ] 1 8 7 29
        {0xA1,0x41},        // ��   0xB8DE  [ 32d ] 1 8 10 1
        {0xA1,0x42},        // ��   0xB8DF  [ 32e ] 1 8 10 2
        {0xA1,0x45},        // ��   0xB8E0  [ 32f ] 1 8 10 5
        {0xA1,0x49},        // ��   0xB8E1  [ 330 ] 1 8 10 9
        {0xA1,0x51},        // ��   0xB8E2  [ 331 ] 1 8 10 17
        {0xA1,0x53},        // ��   0xB8E3  [ 332 ] 1 8 10 19
        {0xA1,0x55},        // ��   0xB8E4  [ 333 ] 1 8 10 21
        {0xA1,0x56},        // ��   0xB8E5  [ 334 ] 1 8 10 22
        {0xA1,0x57},        // ��   0xB8E6  [ 335 ] 1 8 10 23
        {0xA1,0x61},        // ��   0xB8E7  [ 336 ] 1 8 11 1
        {0xA1,0x62},        // ��   0xB8E8  [ 337 ] 1 8 11 2
        {0xA1,0x65},        // ��   0xB8E9  [ 338 ] 1 8 11 5
        {0xA1,0x69},        // ��   0xB8EA  [ 339 ] 1 8 11 9
        {0xA1,0x75},        // ��   0xB8EB  [ 33a ] 1 8 11 21
        {0xA1,0x76},        // ��   0xB8EC  [ 33b ] 1 8 11 22
        {0xA1,0x77},        // ��   0xB8ED  [ 33c ] 1 8 11 23
        {0xA1,0x79},        // ��   0xB8EE  [ 33d ] 1 8 11 25
        {0xA1,0x81},        // ��   0xB8EF  [ 33e ] 1 8 12 1
        {0xA1,0xA1},        // ��   0xB8F0  [ 33f ] 1 8 13 1
        {0xA1,0xA2},        // ��   0xB8F1  [ 340 ] 1 8 13 2
        {0xA1,0xA4},        // ��   0xB8F2  [ 341 ] 1 8 13 4
        {0xA1,0xA5},        // ��   0xB8F3  [ 342 ] 1 8 13 5
        {0xA1,0xA9},        // ��   0xB8F4  [ 343 ] 1 8 13 9
        {0xA1,0xAB},        // ��   0xB8F5  [ 344 ] 1 8 13 11
        {0xA1,0xB1},        // ��   0xB8F6  [ 345 ] 1 8 13 17
        {0xA1,0xB3},        // ��   0xB8F7  [ 346 ] 1 8 13 19
        {0xA1,0xB5},        // ��   0xB8F8  [ 347 ] 1 8 13 21
        {0xA1,0xB7},        // ��   0xB8F9  [ 348 ] 1 8 13 23
        {0xA1,0xC1},        // ��   0xB8FA  [ 349 ] 1 8 14 1
        {0xA1,0xC5},        // ��   0xB8FB  [ 34a ] 1 8 14 5
        {0xA1,0xD6},        // ��   0xB8FC  [ 34b ] 1 8 14 22
        {0xA1,0xD7},        // ��   0xB8FD  [ 34c ] 1 8 14 23
        {0xA2,0x41},        // ��   0xB8FE  [ 34d ] 1 8 18 1
        {0xA2,0x45},        // ��   0xB9A1  [ 34e ] 1 8 18 5
        {0xA2,0x49},        // ��   0xB9A2  [ 34f ] 1 8 18 9
        {0xA2,0x53},        // ��   0xB9A3  [ 350 ] 1 8 18 19
        {0xA2,0x55},        // ��   0xB9A4  [ 351 ] 1 8 18 21
        {0xA2,0x57},        // ��   0xB9A5  [ 352 ] 1 8 18 23
        {0xA2,0x61},        // ��   0xB9A6  [ 353 ] 1 8 19 1
        {0xA2,0x65},        // ��   0xB9A7  [ 354 ] 1 8 19 5
        {0xA2,0x69},        // ��   0xB9A8  [ 355 ] 1 8 19 9
        {0xA2,0x73},        // ��   0xB9A9  [ 356 ] 1 8 19 19
        {0xA2,0x75},        // ��   0xB9AA  [ 357 ] 1 8 19 21
        {0xA2,0x81},        // ��   0xB9AB  [ 358 ] 1 8 20 1
        {0xA2,0x82},        // ��   0xB9AC  [ 359 ] 1 8 20 2
        {0xA2,0x83},        // ��   0xB9AD  [ 35a ] 1 8 20 3
        {0xA2,0x85},        // ��   0xB9AE  [ 35b ] 1 8 20 5
        {0xA2,0x88},        // ��   0xB9AF  [ 35c ] 1 8 20 8
        {0xA2,0x89},        // ��   0xB9B0  [ 35d ] 1 8 20 9
        {0xA2,0x8A},        // ��   0xB9B1  [ 35e ] 1 8 20 10
        {0xA2,0x8B},        // ��   0xB9B2  [ 35f ] 1 8 20 11
        {0xA2,0x91},        // ��   0xB9B3  [ 360 ] 1 8 20 17
        {0xA2,0x93},        // ��   0xB9B4  [ 361 ] 1 8 20 19
        {0xA2,0x95},        // ��   0xB9B5  [ 362 ] 1 8 20 21
        {0xA2,0x97},        // ��   0xB9B6  [ 363 ] 1 8 20 23
        {0xA2,0x9B},        // ��   0xB9B7  [ 364 ] 1 8 20 27
        {0xA2,0x9D},        // ��   0xB9B8  [ 365 ] 1 8 20 29
        {0xA2,0xA1},        // ��   0xB9B9  [ 366 ] 1 8 21 1
        {0xA2,0xA5},        // ��   0xB9BA  [ 367 ] 1 8 21 5
        {0xA2,0xA9},        // ��   0xB9BB  [ 368 ] 1 8 21 9
        {0xA2,0xB3},        // ��   0xB9BC  [ 369 ] 1 8 21 19
        {0xA2,0xB5},        // ��   0xB9BD  [ 36a ] 1 8 21 21
        {0xA2,0xC1},        // ��   0xB9BE  [ 36b ] 1 8 22 1
        {0xA2,0xE1},        // ��   0xB9BF  [ 36c ] 1 8 23 1
        {0xA2,0xE5},        // ��   0xB9C0  [ 36d ] 1 8 23 5
        {0xA2,0xE9},        // ��   0xB9C1  [ 36e ] 1 8 23 9
        {0xA3,0x41},        // ��   0xB9C2  [ 36f ] 1 8 26 1
        {0xA3,0x45},        // ��   0xB9C3  [ 370 ] 1 8 26 5
        {0xA3,0x49},        // ��   0xB9C4  [ 371 ] 1 8 26 9
        {0xA3,0x51},        // ��   0xB9C5  [ 372 ] 1 8 26 17
        {0xA3,0x55},        // ��   0xB9C6  [ 373 ] 1 8 26 21
        {0xA3,0x61},        // ��   0xB9C7  [ 374 ] 1 8 27 1
        {0xA3,0x65},        // ��   0xB9C8  [ 375 ] 1 8 27 5
        {0xA3,0x69},        // ��   0xB9C9  [ 376 ] 1 8 27 9
        {0xA3,0x71},        // ��   0xB9CA  [ 377 ] 1 8 27 17
        {0xA3,0x75},        // ��   0xB9CB  [ 378 ] 1 8 27 21
        {0xA3,0xA1},        // ��   0xB9CC  [ 379 ] 1 8 29 1
        {0xA3,0xA2},        // ��   0xB9CD  [ 37a ] 1 8 29 2
        {0xA3,0xA5},        // ��   0xB9CE  [ 37b ] 1 8 29 5
        {0xA3,0xA8},        // ��   0xB9CF  [ 37c ] 1 8 29 8
        {0xA3,0xA9},        // ��   0xB9D0  [ 37d ] 1 8 29 9
        {0xA3,0xAB},        // ��   0xB9D1  [ 37e ] 1 8 29 11
        {0xA3,0xB1},        // ��   0xB9D2  [ 37f ] 1 8 29 17
        {0xA3,0xB3},        // ��   0xB9D3  [ 380 ] 1 8 29 19
        {0xA3,0xB5},        // ��   0xB9D4  [ 381 ] 1 8 29 21
        {0xA3,0xB6},        // ��   0xB9D5  [ 382 ] 1 8 29 22
        {0xA3,0xB7},        // ��   0xB9D6  [ 383 ] 1 8 29 23
        {0xA3,0xB9},        // ��   0xB9D7  [ 384 ] 1 8 29 25
        {0xA3,0xBB},        // ��   0xB9D8  [ 385 ] 1 8 29 27
        {0xA4,0x61},        // ��   0xB9D9  [ 386 ] 1 9 3 1
        {0xA4,0x62},        // ��   0xB9DA  [ 387 ] 1 9 3 2
        {0xA4,0x63},        // ��   0xB9DB  [ 388 ] 1 9 3 3
        {0xA4,0x64},        // ��   0xB9DC  [ 389 ] 1 9 3 4
        {0xA4,0x65},        // ��   0xB9DD  [ 38a ] 1 9 3 5
        {0xA4,0x68},        // ��   0xB9DE  [ 38b ] 1 9 3 8
        {0xA4,0x69},        // ��   0xB9DF  [ 38c ] 1 9 3 9
        {0xA4,0x6A},        // ��   0xB9E0  [ 38d ] 1 9 3 10
        {0xA4,0x6B},        // ��   0xB9E1  [ 38e ] 1 9 3 11
        {0xA4,0x6C},        // ��   0xB9E2  [ 38f ] 1 9 3 12
        {0xA4,0x71},        // ��   0xB9E3  [ 390 ] 1 9 3 17
        {0xA4,0x73},        // ��   0xB9E4  [ 391 ] 1 9 3 19
        {0xA4,0x75},        // ��   0xB9E5  [ 392 ] 1 9 3 21
        {0xA4,0x77},        // ��   0xB9E6  [ 393 ] 1 9 3 23
        {0xA4,0x7B},        // ��   0xB9E7  [ 394 ] 1 9 3 27
        {0xA4,0x81},        // ��   0xB9E8  [ 395 ] 1 9 4 1
        {0xA4,0x82},        // ��   0xB9E9  [ 396 ] 1 9 4 2
        {0xA4,0x85},        // ��   0xB9EA  [ 397 ] 1 9 4 5
        {0xA4,0x89},        // ��   0xB9EB  [ 398 ] 1 9 4 9
        {0xA4,0x91},        // ��   0xB9EC  [ 399 ] 1 9 4 17
        {0xA4,0x93},        // ��   0xB9ED  [ 39a ] 1 9 4 19
        {0xA4,0x95},        // ��   0xB9EE  [ 39b ] 1 9 4 21
        {0xA4,0x96},        // ��   0xB9EF  [ 39c ] 1 9 4 22
        {0xA4,0x97},        // ��   0xB9F0  [ 39d ] 1 9 4 23
        {0xA4,0x9B},        // ��   0xB9F1  [ 39e ] 1 9 4 27
        {0xA4,0xA1},        // ��   0xB9F2  [ 39f ] 1 9 5 1
        {0xA4,0xA2},        // ��   0xB9F3  [ 3a0 ] 1 9 5 2
        {0xA4,0xA5},        // ��   0xB9F4  [ 3a1 ] 1 9 5 5
        {0xA4,0xB3},        // ��   0xB9F5  [ 3a2 ] 1 9 5 19
        {0xA4,0xE1},        // ��   0xB9F6  [ 3a3 ] 1 9 7 1
        {0xA4,0xE2},        // ��   0xB9F7  [ 3a4 ] 1 9 7 2
        {0xA4,0xE5},        // ��   0xB9F8  [ 3a5 ] 1 9 7 5
        {0xA4,0xE8},        // ��   0xB9F9  [ 3a6 ] 1 9 7 8
        {0xA4,0xE9},        // ��   0xB9FA  [ 3a7 ] 1 9 7 9
        {0xA4,0xEB},        // ��   0xB9FB  [ 3a8 ] 1 9 7 11
        {0xA4,0xF1},        // ��   0xB9FC  [ 3a9 ] 1 9 7 17
        {0xA4,0xF3},        // ��   0xB9FD  [ 3aa ] 1 9 7 19
        {0xA4,0xF5},        // ��   0xB9FE  [ 3ab ] 1 9 7 21
        {0xA4,0xF7},        // ��   0xBAA1  [ 3ac ] 1 9 7 23
        {0xA4,0xF8},        // ��   0xBAA2  [ 3ad ] 1 9 7 24
        {0xA5,0x41},        // ��   0xBAA3  [ 3ae ] 1 9 10 1
        {0xA5,0x42},        // ��   0xBAA4  [ 3af ] 1 9 10 2
        {0xA5,0x45},        // ��   0xBAA5  [ 3b0 ] 1 9 10 5
        {0xA5,0x48},        // ��   0xBAA6  [ 3b1 ] 1 9 10 8
        {0xA5,0x49},        // ��   0xBAA7  [ 3b2 ] 1 9 10 9
        {0xA5,0x51},        // ��   0xBAA8  [ 3b3 ] 1 9 10 17
        {0xA5,0x53},        // ��   0xBAA9  [ 3b4 ] 1 9 10 19
        {0xA5,0x55},        // ��   0xBAAA  [ 3b5 ] 1 9 10 21
        {0xA5,0x56},        // ��   0xBAAB  [ 3b6 ] 1 9 10 22
        {0xA5,0x57},        // ��   0xBAAC  [ 3b7 ] 1 9 10 23
        {0xA5,0x61},        // ��   0xBAAD  [ 3b8 ] 1 9 11 1
        {0xA5,0x62},        // ��   0xBAAE  [ 3b9 ] 1 9 11 2
        {0xA5,0x65},        // ��   0xBAAF  [ 3ba ] 1 9 11 5
        {0xA5,0x69},        // ��   0xBAB0  [ 3bb ] 1 9 11 9
        {0xA5,0x73},        // ��   0xBAB1  [ 3bc ] 1 9 11 19
        {0xA5,0x75},        // ��   0xBAB2  [ 3bd ] 1 9 11 21
        {0xA5,0x76},        // ��   0xBAB3  [ 3be ] 1 9 11 22
        {0xA5,0x77},        // ��   0xBAB4  [ 3bf ] 1 9 11 23
        {0xA5,0x7B},        // ��   0xBAB5  [ 3c0 ] 1 9 11 27
        {0xA5,0x81},        // ��   0xBAB6  [ 3c1 ] 1 9 12 1
        {0xA5,0x85},        // ��   0xBAB7  [ 3c2 ] 1 9 12 5
        {0xA5,0xA1},        // ��   0xBAB8  [ 3c3 ] 1 9 13 1
        {0xA5,0xA2},        // ��   0xBAB9  [ 3c4 ] 1 9 13 2
        {0xA5,0xA3},        // ��   0xBABA  [ 3c5 ] 1 9 13 3
        {0xA5,0xA5},        // ��   0xBABB  [ 3c6 ] 1 9 13 5
        {0xA5,0xA9},        // ��   0xBABC  [ 3c7 ] 1 9 13 9
        {0xA5,0xB1},        // ��   0xBABD  [ 3c8 ] 1 9 13 17
        {0xA5,0xB3},        // ��   0xBABE  [ 3c9 ] 1 9 13 19
        {0xA5,0xB5},        // ��   0xBABF  [ 3ca ] 1 9 13 21
        {0xA5,0xB7},        // ��   0xBAC0  [ 3cb ] 1 9 13 23
        {0xA5,0xC1},        // ��   0xBAC1  [ 3cc ] 1 9 14 1
        {0xA5,0xC5},        // ��   0xBAC2  [ 3cd ] 1 9 14 5
        {0xA5,0xD6},        // ��   0xBAC3  [ 3ce ] 1 9 14 22
        {0xA5,0xE1},        // ��   0xBAC4  [ 3cf ] 1 9 15 1
        {0xA5,0xF6},        // ��   0xBAC5  [ 3d0 ] 1 9 15 22
        {0xA6,0x41},        // ��   0xBAC6  [ 3d1 ] 1 9 18 1
        {0xA6,0x42},        // ��   0xBAC7  [ 3d2 ] 1 9 18 2
        {0xA6,0x45},        // ��   0xBAC8  [ 3d3 ] 1 9 18 5
        {0xA6,0x49},        // ��   0xBAC9  [ 3d4 ] 1 9 18 9
        {0xA6,0x51},        // ��   0xBACA  [ 3d5 ] 1 9 18 17
        {0xA6,0x53},        // ��   0xBACB  [ 3d6 ] 1 9 18 19
        {0xA6,0x61},        // ��   0xBACC  [ 3d7 ] 1 9 19 1
        {0xA6,0x65},        // ��   0xBACD  [ 3d8 ] 1 9 19 5
        {0xA6,0x81},        // ��   0xBACE  [ 3d9 ] 1 9 20 1
        {0xA6,0x82},        // ��   0xBACF  [ 3da ] 1 9 20 2
        {0xA6,0x85},        // ��   0xBAD0  [ 3db ] 1 9 20 5
        {0xA6,0x88},        // ��   0xBAD1  [ 3dc ] 1 9 20 8
        {0xA6,0x89},        // ��   0xBAD2  [ 3dd ] 1 9 20 9
        {0xA6,0x8A},        // ��   0xBAD3  [ 3de ] 1 9 20 10
        {0xA6,0x8B},        // ��   0xBAD4  [ 3df ] 1 9 20 11
        {0xA6,0x91},        // ��   0xBAD5  [ 3e0 ] 1 9 20 17
        {0xA6,0x93},        // ��   0xBAD6  [ 3e1 ] 1 9 20 19
        {0xA6,0x95},        // ��   0xBAD7  [ 3e2 ] 1 9 20 21
        {0xA6,0x97},        // ��   0xBAD8  [ 3e3 ] 1 9 20 23
        {0xA6,0x9B},        // ��   0xBAD9  [ 3e4 ] 1 9 20 27
        {0xA6,0x9C},        // ��   0xBADA  [ 3e5 ] 1 9 20 28
        {0xA6,0xA1},        // ��   0xBADB  [ 3e6 ] 1 9 21 1
        {0xA6,0xA9},        // ��   0xBADC  [ 3e7 ] 1 9 21 9
        {0xA6,0xB6},        // ��   0xBADD  [ 3e8 ] 1 9 21 22
        {0xA6,0xC1},        // ��   0xBADE  [ 3e9 ] 1 9 22 1
        {0xA6,0xE1},        // ��   0xBADF  [ 3ea ] 1 9 23 1
        {0xA6,0xE2},        // ��   0xBAE0  [ 3eb ] 1 9 23 2
        {0xA6,0xE5},        // ��   0xBAE1  [ 3ec ] 1 9 23 5
        {0xA6,0xE9},        // ��   0xBAE2  [ 3ed ] 1 9 23 9
        {0xA6,0xF7},        // ��   0xBAE3  [ 3ee ] 1 9 23 23
        {0xA7,0x41},        // ��   0xBAE4  [ 3ef ] 1 9 26 1
        {0xA7,0x45},        // ��   0xBAE5  [ 3f0 ] 1 9 26 5
        {0xA7,0x49},        // ��   0xBAE6  [ 3f1 ] 1 9 26 9
        {0xA7,0x51},        // ��   0xBAE7  [ 3f2 ] 1 9 26 17
        {0xA7,0x55},        // ��   0xBAE8  [ 3f3 ] 1 9 26 21
        {0xA7,0x57},        // ��   0xBAE9  [ 3f4 ] 1 9 26 23
        {0xA7,0x61},        // ��   0xBAEA  [ 3f5 ] 1 9 27 1
        {0xA7,0x62},        // ��   0xBAEB  [ 3f6 ] 1 9 27 2
        {0xA7,0x65},        // ��   0xBAEC  [ 3f7 ] 1 9 27 5
        {0xA7,0x69},        // ��   0xBAED  [ 3f8 ] 1 9 27 9
        {0xA7,0x71},        // ��   0xBAEE  [ 3f9 ] 1 9 27 17
        {0xA7,0x73},        // ��   0xBAEF  [ 3fa ] 1 9 27 19
        {0xA7,0x75},        // ��   0xBAF0  [ 3fb ] 1 9 27 21
        {0xA7,0xA1},        // ��   0xBAF1  [ 3fc ] 1 9 29 1
        {0xA7,0xA2},        // ��   0xBAF2  [ 3fd ] 1 9 29 2
        {0xA7,0xA5},        // ��   0xBAF3  [ 3fe ] 1 9 29 5
        {0xA7,0xA9},        // ��   0xBAF4  [ 3ff ] 1 9 29 9
        {0xA7,0xAB},        // ��   0xBAF5  [ 400 ] 1 9 29 11
        {0xA7,0xB1},        // ��   0xBAF6  [ 401 ] 1 9 29 17
        {0xA7,0xB3},        // ��   0xBAF7  [ 402 ] 1 9 29 19
        {0xA7,0xB5},        // ��   0xBAF8  [ 403 ] 1 9 29 21
        {0xA7,0xB7},        // ��   0xBAF9  [ 404 ] 1 9 29 23
        {0xA7,0xB8},        // ��   0xBAFA  [ 405 ] 1 9 29 24
        {0xA7,0xB9},        // ��   0xBAFB  [ 406 ] 1 9 29 25
        {0xA8,0x61},        // ��   0xBAFC  [ 407 ] 1 10 3 1
        {0xA8,0x62},        // ��   0xBAFD  [ 408 ] 1 10 3 2
        {0xA8,0x65},        // ��   0xBAFE  [ 409 ] 1 10 3 5
        {0xA8,0x69},        // ��   0xBBA1  [ 40a ] 1 10 3 9
        {0xA8,0x6B},        // ��   0xBBA2  [ 40b ] 1 10 3 11
        {0xA8,0x71},        // ��   0xBBA3  [ 40c ] 1 10 3 17
        {0xA8,0x73},        // ��   0xBBA4  [ 40d ] 1 10 3 19
        {0xA8,0x75},        // ��   0xBBA5  [ 40e ] 1 10 3 21
        {0xA8,0x76},        // ��   0xBBA6  [ 40f ] 1 10 3 22
        {0xA8,0x77},        // ��   0xBBA7  [ 410 ] 1 10 3 23
        {0xA8,0x7D},        // ��   0xBBA8  [ 411 ] 1 10 3 29
        {0xA8,0x81},        // ��   0xBBA9  [ 412 ] 1 10 4 1
        {0xA8,0x82},        // ��   0xBBAA  [ 413 ] 1 10 4 2
        {0xA8,0x85},        // ��   0xBBAB  [ 414 ] 1 10 4 5
        {0xA8,0x89},        // ��   0xBBAC  [ 415 ] 1 10 4 9
        {0xA8,0x91},        // ��   0xBBAD  [ 416 ] 1 10 4 17
        {0xA8,0x93},        // ��   0xBBAE  [ 417 ] 1 10 4 19
        {0xA8,0x95},        // ��   0xBBAF  [ 418 ] 1 10 4 21
        {0xA8,0x96},        // ��   0xBBB0  [ 419 ] 1 10 4 22
        {0xA8,0x97},        // ��   0xBBB1  [ 41a ] 1 10 4 23
        {0xA8,0xA1},        // ��   0xBBB2  [ 41b ] 1 10 5 1
        {0xA8,0xA2},        // ��   0xBBB3  [ 41c ] 1 10 5 2
        {0xA8,0xB1},        // ��   0xBBB4  [ 41d ] 1 10 5 17
        {0xA8,0xE1},        // ��   0xBBB5  [ 41e ] 1 10 7 1
        {0xA8,0xE2},        // ��   0xBBB6  [ 41f ] 1 10 7 2
        {0xA8,0xE5},        // ��   0xBBB7  [ 420 ] 1 10 7 5
        {0xA8,0xE8},        // ��   0xBBB8  [ 421 ] 1 10 7 8
        {0xA8,0xE9},        // ��   0xBBB9  [ 422 ] 1 10 7 9
        {0xA8,0xF1},        // ��   0xBBBA  [ 423 ] 1 10 7 17
        {0xA8,0xF5},        // ��   0xBBBB  [ 424 ] 1 10 7 21
        {0xA8,0xF6},        // ��   0xBBBC  [ 425 ] 1 10 7 22
        {0xA8,0xF7},        // ��   0xBBBD  [ 426 ] 1 10 7 23
        {0xA9,0x41},        // ��   0xBBBE  [ 427 ] 1 10 10 1
        {0xA9,0x57},        // ��   0xBBBF  [ 428 ] 1 10 10 23
        {0xA9,0x61},        // ��   0xBBC0  [ 429 ] 1 10 11 1
        {0xA9,0x62},        // ��   0xBBC1  [ 42a ] 1 10 11 2
        {0xA9,0x71},        // ��   0xBBC2  [ 42b ] 1 10 11 17
        {0xA9,0x73},        // ��   0xBBC3  [ 42c ] 1 10 11 19
        {0xA9,0x75},        // ��   0xBBC4  [ 42d ] 1 10 11 21
        {0xA9,0x76},        // ��   0xBBC5  [ 42e ] 1 10 11 22
        {0xA9,0x77},        // ��   0xBBC6  [ 42f ] 1 10 11 23
        {0xA9,0xA1},        // ��   0xBBC7  [ 430 ] 1 10 13 1
        {0xA9,0xA2},        // ��   0xBBC8  [ 431 ] 1 10 13 2
        {0xA9,0xA5},        // ��   0xBBC9  [ 432 ] 1 10 13 5
        {0xA9,0xA9},        // ��   0xBBCA  [ 433 ] 1 10 13 9
        {0xA9,0xB1},        // ��   0xBBCB  [ 434 ] 1 10 13 17
        {0xA9,0xB3},        // ��   0xBBCC  [ 435 ] 1 10 13 19
        {0xA9,0xB7},        // ��   0xBBCD  [ 436 ] 1 10 13 23
        {0xAA,0x41},        // ��   0xBBCE  [ 437 ] 1 10 18 1
        {0xAA,0x61},        // ��   0xBBCF  [ 438 ] 1 10 19 1
        {0xAA,0x77},        // ��   0xBBD0  [ 439 ] 1 10 19 23
        {0xAA,0x81},        // ��   0xBBD1  [ 43a ] 1 10 20 1
        {0xAA,0x82},        // ��   0xBBD2  [ 43b ] 1 10 20 2
        {0xAA,0x85},        // ��   0xBBD3  [ 43c ] 1 10 20 5
        {0xAA,0x89},        // ��   0xBBD4  [ 43d ] 1 10 20 9
        {0xAA,0x91},        // ��   0xBBD5  [ 43e ] 1 10 20 17
        {0xAA,0x95},        // ��   0xBBD6  [ 43f ] 1 10 20 21
        {0xAA,0x97},        // ��   0xBBD7  [ 440 ] 1 10 20 23
        {0xAB,0x41},        // ��   0xBBD8  [ 441 ] 1 10 26 1
        {0xAB,0x57},        // ��   0xBBD9  [ 442 ] 1 10 26 23
        {0xAB,0x61},        // ��   0xBBDA  [ 443 ] 1 10 27 1
        {0xAB,0x65},        // ��   0xBBDB  [ 444 ] 1 10 27 5
        {0xAB,0x69},        // ��   0xBBDC  [ 445 ] 1 10 27 9
        {0xAB,0x71},        // ��   0xBBDD  [ 446 ] 1 10 27 17
        {0xAB,0x73},        // ��   0xBBDE  [ 447 ] 1 10 27 19
        {0xAB,0xA1},        // ��   0xBBDF  [ 448 ] 1 10 29 1
        {0xAB,0xA2},        // ��   0xBBE0  [ 449 ] 1 10 29 2
        {0xAB,0xA5},        // ��   0xBBE1  [ 44a ] 1 10 29 5
        {0xAB,0xA9},        // ��   0xBBE2  [ 44b ] 1 10 29 9
        {0xAB,0xB1},        // ��   0xBBE3  [ 44c ] 1 10 29 17
        {0xAB,0xB3},        // ��   0xBBE4  [ 44d ] 1 10 29 19
        {0xAB,0xB5},        // ��   0xBBE5  [ 44e ] 1 10 29 21
        {0xAB,0xB7},        // ��   0xBBE6  [ 44f ] 1 10 29 23
        {0xAC,0x61},        // ��   0xBBE7  [ 450 ] 1 11 3 1
        {0xAC,0x62},        // ��   0xBBE8  [ 451 ] 1 11 3 2
        {0xAC,0x64},        // ��   0xBBE9  [ 452 ] 1 11 3 4
        {0xAC,0x65},        // ��   0xBBEA  [ 453 ] 1 11 3 5
        {0xAC,0x68},        // ��   0xBBEB  [ 454 ] 1 11 3 8
        {0xAC,0x69},        // ��   0xBBEC  [ 455 ] 1 11 3 9
        {0xAC,0x6A},        // ��   0xBBED  [ 456 ] 1 11 3 10
        {0xAC,0x6B},        // ��   0xBBEE  [ 457 ] 1 11 3 11
        {0xAC,0x71},        // ��   0xBBEF  [ 458 ] 1 11 3 17
        {0xAC,0x73},        // ��   0xBBF0  [ 459 ] 1 11 3 19
        {0xAC,0x75},        // ��   0xBBF1  [ 45a ] 1 11 3 21
        {0xAC,0x76},        // ��   0xBBF2  [ 45b ] 1 11 3 22
        {0xAC,0x77},        // ��   0xBBF3  [ 45c ] 1 11 3 23
        {0xAC,0x7B},        // ��   0xBBF4  [ 45d ] 1 11 3 27
        {0xAC,0x81},        // ��   0xBBF5  [ 45e ] 1 11 4 1
        {0xAC,0x82},        // ��   0xBBF6  [ 45f ] 1 11 4 2
        {0xAC,0x85},        // ��   0xBBF7  [ 460 ] 1 11 4 5
        {0xAC,0x89},        // ��   0xBBF8  [ 461 ] 1 11 4 9
        {0xAC,0x91},        // ��   0xBBF9  [ 462 ] 1 11 4 17
        {0xAC,0x93},        // ��   0xBBFA  [ 463 ] 1 11 4 19
        {0xAC,0x95},        // ��   0xBBFB  [ 464 ] 1 11 4 21
        {0xAC,0x96},        // ��   0xBBFC  [ 465 ] 1 11 4 22
        {0xAC,0x97},        // ��   0xBBFD  [ 466 ] 1 11 4 23
        {0xAC,0xA1},        // ��   0xBBFE  [ 467 ] 1 11 5 1
        {0xAC,0xA2},        // ��   0xBCA1  [ 468 ] 1 11 5 2
        {0xAC,0xA5},        // ��   0xBCA2  [ 469 ] 1 11 5 5
        {0xAC,0xA9},        // ��   0xBCA3  [ 46a ] 1 11 5 9
        {0xAC,0xB1},        // ��   0xBCA4  [ 46b ] 1 11 5 17
        {0xAC,0xB3},        // ��   0xBCA5  [ 46c ] 1 11 5 19
        {0xAC,0xB5},        // ��   0xBCA6  [ 46d ] 1 11 5 21
        {0xAC,0xB7},        // ��   0xBCA7  [ 46e ] 1 11 5 23
        {0xAC,0xC1},        // ��   0xBCA8  [ 46f ] 1 11 6 1
        {0xAC,0xC5},        // ��   0xBCA9  [ 470 ] 1 11 6 5
        {0xAC,0xC9},        // ��   0xBCAA  [ 471 ] 1 11 6 9
        {0xAC,0xD1},        // ��   0xBCAB  [ 472 ] 1 11 6 17
        {0xAC,0xD7},        // ��   0xBCAC  [ 473 ] 1 11 6 23
        {0xAC,0xE1},        // ��   0xBCAD  [ 474 ] 1 11 7 1
        {0xAC,0xE2},        // ��   0xBCAE  [ 475 ] 1 11 7 2
        {0xAC,0xE3},        // ��   0xBCAF  [ 476 ] 1 11 7 3
        {0xAC,0xE4},        // ��   0xBCB0  [ 477 ] 1 11 7 4
        {0xAC,0xE5},        // ��   0xBCB1  [ 478 ] 1 11 7 5
        {0xAC,0xE8},        // ��   0xBCB2  [ 479 ] 1 11 7 8
        {0xAC,0xE9},        // ��   0xBCB3  [ 47a ] 1 11 7 9
        {0xAC,0xEB},        // ��   0xBCB4  [ 47b ] 1 11 7 11
        {0xAC,0xEC},        // ��   0xBCB5  [ 47c ] 1 11 7 12
        {0xAC,0xF1},        // ��   0xBCB6  [ 47d ] 1 11 7 17
        {0xAC,0xF3},        // ��   0xBCB7  [ 47e ] 1 11 7 19
        {0xAC,0xF5},        // ��   0xBCB8  [ 47f ] 1 11 7 21
        {0xAC,0xF6},        // ��   0xBCB9  [ 480 ] 1 11 7 22
        {0xAC,0xF7},        // ��   0xBCBA  [ 481 ] 1 11 7 23
        {0xAC,0xFC},        // ��   0xBCBB  [ 482 ] 1 11 7 28
        {0xAD,0x41},        // ��   0xBCBC  [ 483 ] 1 11 10 1
        {0xAD,0x42},        // ��   0xBCBD  [ 484 ] 1 11 10 2
        {0xAD,0x45},        // ��   0xBCBE  [ 485 ] 1 11 10 5
        {0xAD,0x49},        // ��   0xBCBF  [ 486 ] 1 11 10 9
        {0xAD,0x51},        // ��   0xBCC0  [ 487 ] 1 11 10 17
        {0xAD,0x53},        // ��   0xBCC1  [ 488 ] 1 11 10 19
        {0xAD,0x55},        // ��   0xBCC2  [ 489 ] 1 11 10 21
        {0xAD,0x56},        // ��   0xBCC3  [ 48a ] 1 11 10 22
        {0xAD,0x57},        // ��   0xBCC4  [ 48b ] 1 11 10 23
        {0xAD,0x61},        // ��   0xBCC5  [ 48c ] 1 11 11 1
        {0xAD,0x62},        // ��   0xBCC6  [ 48d ] 1 11 11 2
        {0xAD,0x65},        // ��   0xBCC7  [ 48e ] 1 11 11 5
        {0xAD,0x69},        // ��   0xBCC8  [ 48f ] 1 11 11 9
        {0xAD,0x71},        // ��   0xBCC9  [ 490 ] 1 11 11 17
        {0xAD,0x73},        // ��   0xBCCA  [ 491 ] 1 11 11 19
        {0xAD,0x75},        // ��   0xBCCB  [ 492 ] 1 11 11 21
        {0xAD,0x76},        // ��   0xBCCC  [ 493 ] 1 11 11 22
        {0xAD,0x77},        // ��   0xBCCD  [ 494 ] 1 11 11 23
        {0xAD,0x81},        // ��   0xBCCE  [ 495 ] 1 11 12 1
        {0xAD,0x85},        // ��   0xBCCF  [ 496 ] 1 11 12 5
        {0xAD,0x89},        // ��   0xBCD0  [ 497 ] 1 11 12 9
        {0xAD,0x97},        // ��   0xBCD1  [ 498 ] 1 11 12 23
        {0xAD,0xA1},        // ��   0xBCD2  [ 499 ] 1 11 13 1
        {0xAD,0xA2},        // ��   0xBCD3  [ 49a ] 1 11 13 2
        {0xAD,0xA3},        // ��   0xBCD4  [ 49b ] 1 11 13 3
        {0xAD,0xA5},        // ��   0xBCD5  [ 49c ] 1 11 13 5
        {0xAD,0xA9},        // ��   0xBCD6  [ 49d ] 1 11 13 9
        {0xAD,0xAB},        // ��   0xBCD7  [ 49e ] 1 11 13 11
        {0xAD,0xB1},        // ��   0xBCD8  [ 49f ] 1 11 13 17
        {0xAD,0xB3},        // ��   0xBCD9  [ 4a0 ] 1 11 13 19
        {0xAD,0xB5},        // ��   0xBCDA  [ 4a1 ] 1 11 13 21
        {0xAD,0xB7},        // ��   0xBCDB  [ 4a2 ] 1 11 13 23
        {0xAD,0xBB},        // ��   0xBCDC  [ 4a3 ] 1 11 13 27
        {0xAD,0xC1},        // ��   0xBCDD  [ 4a4 ] 1 11 14 1
        {0xAD,0xC2},        // ��   0xBCDE  [ 4a5 ] 1 11 14 2
        {0xAD,0xC5},        // ��   0xBCDF  [ 4a6 ] 1 11 14 5
        {0xAD,0xC9},        // ��   0xBCE0  [ 4a7 ] 1 11 14 9
        {0xAD,0xD7},        // ��   0xBCE1  [ 4a8 ] 1 11 14 23
        {0xAD,0xE1},        // ��   0xBCE2  [ 4a9 ] 1 11 15 1
        {0xAD,0xE5},        // ��   0xBCE3  [ 4aa ] 1 11 15 5
        {0xAD,0xE9},        // ��   0xBCE4  [ 4ab ] 1 11 15 9
        {0xAD,0xF1},        // ��   0xBCE5  [ 4ac ] 1 11 15 17
        {0xAD,0xF5},        // ��   0xBCE6  [ 4ad ] 1 11 15 21
        {0xAD,0xF6},        // ��   0xBCE7  [ 4ae ] 1 11 15 22
        {0xAE,0x41},        // ��   0xBCE8  [ 4af ] 1 11 18 1
        {0xAE,0x45},        // ��   0xBCE9  [ 4b0 ] 1 11 18 5
        {0xAE,0x49},        // ��   0xBCEA  [ 4b1 ] 1 11 18 9
        {0xAE,0x51},        // ��   0xBCEB  [ 4b2 ] 1 11 18 17
        {0xAE,0x53},        // ��   0xBCEC  [ 4b3 ] 1 11 18 19
        {0xAE,0x55},        // ��   0xBCED  [ 4b4 ] 1 11 18 21
        {0xAE,0x61},        // ��   0xBCEE  [ 4b5 ] 1 11 19 1
        {0xAE,0x62},        // ��   0xBCEF  [ 4b6 ] 1 11 19 2
        {0xAE,0x65},        // ��   0xBCF0  [ 4b7 ] 1 11 19 5
        {0xAE,0x69},        // ��   0xBCF1  [ 4b8 ] 1 11 19 9
        {0xAE,0x71},        // ��   0xBCF2  [ 4b9 ] 1 11 19 17
        {0xAE,0x73},        // ��   0xBCF3  [ 4ba ] 1 11 19 19
        {0xAE,0x75},        // ��   0xBCF4  [ 4bb ] 1 11 19 21
        {0xAE,0x77},        // ��   0xBCF5  [ 4bc ] 1 11 19 23
        {0xAE,0x81},        // ��   0xBCF6  [ 4bd ] 1 11 20 1
        {0xAE,0x82},        // ��   0xBCF7  [ 4be ] 1 11 20 2
        {0xAE,0x85},        // ��   0xBCF8  [ 4bf ] 1 11 20 5
        {0xAE,0x88},        // ��   0xBCF9  [ 4c0 ] 1 11 20 8
        {0xAE,0x89},        // ��   0xBCFA  [ 4c1 ] 1 11 20 9
        {0xAE,0x91},        // ��   0xBCFB  [ 4c2 ] 1 11 20 17
        {0xAE,0x93},        // ��   0xBCFC  [ 4c3 ] 1 11 20 19
        {0xAE,0x95},        // ��   0xBCFD  [ 4c4 ] 1 11 20 21
        {0xAE,0x97},        // ��   0xBCFE  [ 4c5 ] 1 11 20 23
        {0xAE,0x99},        // ��   0xBDA1  [ 4c6 ] 1 11 20 25
        {0xAE,0x9B},        // ��   0xBDA2  [ 4c7 ] 1 11 20 27
        {0xAE,0x9C},        // ��   0xBDA3  [ 4c8 ] 1 11 20 28
        {0xAE,0xA1},        // ��   0xBDA4  [ 4c9 ] 1 11 21 1
        {0xAE,0xB6},        // ��   0xBDA5  [ 4ca ] 1 11 21 22
        {0xAE,0xC1},        // ��   0xBDA6  [ 4cb ] 1 11 22 1
        {0xAE,0xC2},        // ��   0xBDA7  [ 4cc ] 1 11 22 2
        {0xAE,0xC5},        // ��   0xBDA8  [ 4cd ] 1 11 22 5
        {0xAE,0xC9},        // ��   0xBDA9  [ 4ce ] 1 11 22 9
        {0xAE,0xD1},        // ��   0xBDAA  [ 4cf ] 1 11 22 17
        {0xAE,0xD7},        // ��   0xBDAB  [ 4d0 ] 1 11 22 23
        {0xAE,0xE1},        // ��   0xBDAC  [ 4d1 ] 1 11 23 1
        {0xAE,0xE2},        // ��   0xBDAD  [ 4d2 ] 1 11 23 2
        {0xAE,0xE5},        // ��   0xBDAE  [ 4d3 ] 1 11 23 5
        {0xAE,0xE9},        // ��   0xBDAF  [ 4d4 ] 1 11 23 9
        {0xAE,0xF1},        // ��   0xBDB0  [ 4d5 ] 1 11 23 17
        {0xAE,0xF3},        // ��   0xBDB1  [ 4d6 ] 1 11 23 19
        {0xAE,0xF5},        // ��   0xBDB2  [ 4d7 ] 1 11 23 21
        {0xAE,0xF7},        // ��   0xBDB3  [ 4d8 ] 1 11 23 23
        {0xAF,0x41},        // ��   0xBDB4  [ 4d9 ] 1 11 26 1
        {0xAF,0x42},        // ��   0xBDB5  [ 4da ] 1 11 26 2
        {0xAF,0x49},        // ��   0xBDB6  [ 4db ] 1 11 26 9
        {0xAF,0x51},        // ��   0xBDB7  [ 4dc ] 1 11 26 17
        {0xAF,0x55},        // ��   0xBDB8  [ 4dd ] 1 11 26 21
        {0xAF,0x57},        // ��   0xBDB9  [ 4de ] 1 11 26 23
        {0xAF,0x61},        // ��   0xBDBA  [ 4df ] 1 11 27 1
        {0xAF,0x62},        // ��   0xBDBB  [ 4e0 ] 1 11 27 2
        {0xAF,0x65},        // ��   0xBDBC  [ 4e1 ] 1 11 27 5
        {0xAF,0x69},        // ��   0xBDBD  [ 4e2 ] 1 11 27 9
        {0xAF,0x6A},        // ��   0xBDBE  [ 4e3 ] 1 11 27 10
        {0xAF,0x71},        // ��   0xBDBF  [ 4e4 ] 1 11 27 17
        {0xAF,0x73},        // ��   0xBDC0  [ 4e5 ] 1 11 27 19
        {0xAF,0x75},        // ��   0xBDC1  [ 4e6 ] 1 11 27 21
        {0xAF,0x77},        // ��   0xBDC2  [ 4e7 ] 1 11 27 23
        {0xAF,0xA1},        // ��   0xBDC3  [ 4e8 ] 1 11 29 1
        {0xAF,0xA2},        // ��   0xBDC4  [ 4e9 ] 1 11 29 2
        {0xAF,0xA5},        // ��   0xBDC5  [ 4ea ] 1 11 29 5
        {0xAF,0xA8},        // ��   0xBDC6  [ 4eb ] 1 11 29 8
        {0xAF,0xA9},        // ��   0xBDC7  [ 4ec ] 1 11 29 9
        {0xAF,0xB0},        // ��   0xBDC8  [ 4ed ] 1 11 29 16
        {0xAF,0xB1},        // ��   0xBDC9  [ 4ee ] 1 11 29 17
        {0xAF,0xB3},        // ��   0xBDCA  [ 4ef ] 1 11 29 19
        {0xAF,0xB5},        // ��   0xBDCB  [ 4f0 ] 1 11 29 21
        {0xAF,0xB7},        // ��   0xBDCC  [ 4f1 ] 1 11 29 23
        {0xAF,0xBC},        // ��   0xBDCD  [ 4f2 ] 1 11 29 28
        {0xB0,0x61},        // ��   0xBDCE  [ 4f3 ] 1 12 3 1
        {0xB0,0x62},        // ��   0xBDCF  [ 4f4 ] 1 12 3 2
        {0xB0,0x64},        // ��   0xBDD0  [ 4f5 ] 1 12 3 4
        {0xB0,0x65},        // ��   0xBDD1  [ 4f6 ] 1 12 3 5
        {0xB0,0x69},        // ��   0xBDD2  [ 4f7 ] 1 12 3 9
        {0xB0,0x71},        // ��   0xBDD3  [ 4f8 ] 1 12 3 17
        {0xB0,0x73},        // ��   0xBDD4  [ 4f9 ] 1 12 3 19
        {0xB0,0x76},        // ��   0xBDD5  [ 4fa ] 1 12 3 22
        {0xB0,0x77},        // ��   0xBDD6  [ 4fb ] 1 12 3 23
        {0xB0,0x7D},        // ��   0xBDD7  [ 4fc ] 1 12 3 29
        {0xB0,0x81},        // ��   0xBDD8  [ 4fd ] 1 12 4 1
        {0xB0,0x82},        // ��   0xBDD9  [ 4fe ] 1 12 4 2
        {0xB0,0x85},        // ��   0xBDDA  [ 4ff ] 1 12 4 5
        {0xB0,0x89},        // ��   0xBDDB  [ 500 ] 1 12 4 9
        {0xB0,0x91},        // ��   0xBDDC  [ 501 ] 1 12 4 17
        {0xB0,0x93},        // ��   0xBDDD  [ 502 ] 1 12 4 19
        {0xB0,0x96},        // ��   0xBDDE  [ 503 ] 1 12 4 22
        {0xB0,0x97},        // ��   0xBDDF  [ 504 ] 1 12 4 23
        {0xB0,0xB7},        // ��   0xBDE0  [ 505 ] 1 12 5 23
        {0xB0,0xE1},        // ��   0xBDE1  [ 506 ] 1 12 7 1
        {0xB0,0xE2},        // ��   0xBDE2  [ 507 ] 1 12 7 2
        {0xB0,0xE5},        // ��   0xBDE3  [ 508 ] 1 12 7 5
        {0xB0,0xE9},        // ��   0xBDE4  [ 509 ] 1 12 7 9
        {0xB0,0xEB},        // ��   0xBDE5  [ 50a ] 1 12 7 11
        {0xB0,0xF1},        // ��   0xBDE6  [ 50b ] 1 12 7 17
        {0xB0,0xF3},        // ��   0xBDE7  [ 50c ] 1 12 7 19
        {0xB0,0xF6},        // ��   0xBDE8  [ 50d ] 1 12 7 22
        {0xB0,0xF7},        // ��   0xBDE9  [ 50e ] 1 12 7 23
        {0xB1,0x41},        // ��   0xBDEA  [ 50f ] 1 12 10 1
        {0xB1,0x45},        // ��   0xBDEB  [ 510 ] 1 12 10 5
        {0xB1,0x49},        // ��   0xBDEC  [ 511 ] 1 12 10 9
        {0xB1,0x57},        // ��   0x9BC0  [ 512 ] 1 12 10 23
        {0xB1,0xA1},        // ��   0xBDEE  [ 513 ] 1 12 13 1
        {0xB1,0xA2},        // ��   0xBDEF  [ 514 ] 1 12 13 2
        {0xB1,0xA5},        // ��   0xBDF0  [ 515 ] 1 12 13 5
        {0xB1,0xA8},        // ��   0xBDF1  [ 516 ] 1 12 13 8
        {0xB1,0xA9},        // ��   0xBDF2  [ 517 ] 1 12 13 9
        {0xB1,0xAB},        // ��   0xBDF3  [ 518 ] 1 12 13 11
        {0xB1,0xB1},        // ��   0xBDF4  [ 519 ] 1 12 13 17
        {0xB1,0xB3},        // ��   0xBDF5  [ 51a ] 1 12 13 19
        {0xB1,0xB7},        // ��   0xBDF6  [ 51b ] 1 12 13 23
        {0xB1,0xC1},        // ��   0xBDF7  [ 51c ] 1 12 14 1
        {0xB1,0xC2},        // ��   0xBDF8  [ 51d ] 1 12 14 2
        {0xB1,0xC5},        // ��   0xBDF9  [ 51e ] 1 12 14 5
        {0xB1,0xD6},        // ��   0xBDFA  [ 51f ] 1 12 14 22
        {0xB1,0xE1},        // ��   0xBDFB  [ 520 ] 1 12 15 1
        {0xB1,0xF6},        // ��   0xBDFC  [ 521 ] 1 12 15 22
        {0xB2,0x41},        // ��   0xBDFD  [ 522 ] 1 12 18 1
        {0xB2,0x45},        // ��   0xBDFE  [ 523 ] 1 12 18 5
        {0xB2,0x49},        // ��   0xBEA1  [ 524 ] 1 12 18 9
        {0xB2,0x51},        // ��   0xBEA2  [ 525 ] 1 12 18 17
        {0xB2,0x53},        // ��   0xBEA3  [ 526 ] 1 12 18 19
        {0xB2,0x61},        // ��   0xBEA4  [ 527 ] 1 12 19 1
        {0xB2,0x81},        // ��   0xBEA5  [ 528 ] 1 12 20 1
        {0xB2,0x82},        // ��   0xBEA6  [ 529 ] 1 12 20 2
        {0xB2,0x85},        // ��   0xBEA7  [ 52a ] 1 12 20 5
        {0xB2,0x89},        // ��   0xBEA8  [ 52b ] 1 12 20 9
        {0xB2,0x91},        // ��   0xBEA9  [ 52c ] 1 12 20 17
        {0xB2,0x93},        // ��   0xBEAA  [ 52d ] 1 12 20 19
        {0xB2,0x97},        // ��   0xBEAB  [ 52e ] 1 12 20 23
        {0xB2,0xA1},        // ��   0xBEAC  [ 52f ] 1 12 21 1
        {0xB2,0xB6},        // ��   0xBEAD  [ 530 ] 1 12 21 22
        {0xB2,0xC1},        // ��   0xBEAE  [ 531 ] 1 12 22 1
        {0xB2,0xE1},        // ��   0xBEAF  [ 532 ] 1 12 23 1
        {0xB2,0xE5},        // ��   0xBEB0  [ 533 ] 1 12 23 5
        {0xB3,0x57},        // ��   0xBEB1  [ 534 ] 1 12 26 23
        {0xB3,0x61},        // ��   0xBEB2  [ 535 ] 1 12 27 1
        {0xB3,0x62},        // ��   0xBEB3  [ 536 ] 1 12 27 2
        {0xB3,0x65},        // ��   0xBEB4  [ 537 ] 1 12 27 5
        {0xB3,0x69},        // ��   0xBEB5  [ 538 ] 1 12 27 9
        {0xB3,0x6B},        // ��   0xBEB6  [ 539 ] 1 12 27 11
        {0xB3,0x70},        // ��   0xBEB7  [ 53a ] 1 12 27 16
        {0xB3,0x71},        // ��   0xBEB8  [ 53b ] 1 12 27 17
        {0xB3,0x73},        // ��   0xBEB9  [ 53c ] 1 12 27 19
        {0xB3,0x81},        // ��   0xBEBA  [ 53d ] 1 12 28 1
        {0xB3,0x85},        // ��   0xBEBB  [ 53e ] 1 12 28 5
        {0xB3,0x89},        // ��   0xBEBC  [ 53f ] 1 12 28 9
        {0xB3,0x91},        // ��   0xBEBD  [ 540 ] 1 12 28 17
        {0xB3,0xA1},        // ��   0xBEBE  [ 541 ] 1 12 29 1
        {0xB3,0xA2},        // ��   0xBEBF  [ 542 ] 1 12 29 2
        {0xB3,0xA5},        // ��   0xBEC0  [ 543 ] 1 12 29 5
        {0xB3,0xA9},        // ��   0xBEC1  [ 544 ] 1 12 29 9
        {0xB3,0xB1},        // ��   0xBEC2  [ 545 ] 1 12 29 17
        {0xB3,0xB3},        // ��   0xBEC3  [ 546 ] 1 12 29 19
        {0xB3,0xB5},        // ��   0xBEC4  [ 547 ] 1 12 29 21
        {0xB3,0xB7},        // ��   0xBEC5  [ 548 ] 1 12 29 23
        {0xB4,0x61},        // ��   0xBEC6  [ 549 ] 1 13 3 1
        {0xB4,0x62},        // ��   0xBEC7  [ 54a ] 1 13 3 2
        {0xB4,0x65},        // ��   0xBEC8  [ 54b ] 1 13 3 5
        {0xB4,0x66},        // ��   0xBEC9  [ 54c ] 1 13 3 6
        {0xB4,0x67},        // ��   0xBECA  [ 54d ] 1 13 3 7
        {0xB4,0x69},        // ��   0xBECB  [ 54e ] 1 13 3 9
        {0xB4,0x6A},        // ��   0xBECC  [ 54f ] 1 13 3 10
        {0xB4,0x6B},        // ��   0xBECD  [ 550 ] 1 13 3 11
        {0xB4,0x70},        // ��   0xBECE  [ 551 ] 1 13 3 16
        {0xB4,0x71},        // ��   0xBECF  [ 552 ] 1 13 3 17
        {0xB4,0x73},        // ��   0xBED0  [ 553 ] 1 13 3 19
        {0xB4,0x75},        // ��   0xBED1  [ 554 ] 1 13 3 21
        {0xB4,0x76},        // ��   0xBED2  [ 555 ] 1 13 3 22
        {0xB4,0x77},        // ��   0xBED3  [ 556 ] 1 13 3 23
        {0xB4,0x7B},        // ��   0xBED4  [ 557 ] 1 13 3 27
        {0xB4,0x7C},        // ��   0xBED5  [ 558 ] 1 13 3 28
        {0xB4,0x81},        // ��   0xBED6  [ 559 ] 1 13 4 1
        {0xB4,0x82},        // ��   0xBED7  [ 55a ] 1 13 4 2
        {0xB4,0x85},        // ��   0xBED8  [ 55b ] 1 13 4 5
        {0xB4,0x89},        // ��   0xBED9  [ 55c ] 1 13 4 9
        {0xB4,0x91},        // ��   0xBEDA  [ 55d ] 1 13 4 17
        {0xB4,0x93},        // ��   0xBEDB  [ 55e ] 1 13 4 19
        {0xB4,0x95},        // ��   0xBEDC  [ 55f ] 1 13 4 21
        {0xB4,0x96},        // ��   0xBEDD  [ 560 ] 1 13 4 22
        {0xB4,0x97},        // ��   0xBEDE  [ 561 ] 1 13 4 23
        {0xB4,0xA1},        // ��   0xBEDF  [ 562 ] 1 13 5 1
        {0xB4,0xA2},        // ��   0xBEE0  [ 563 ] 1 13 5 2
        {0xB4,0xA5},        // ��   0xBEE1  [ 564 ] 1 13 5 5
        {0xB4,0xA9},        // ��   0xBEE2  [ 565 ] 1 13 5 9
        {0xB4,0xAC},        // ��   0xBEE3  [ 566 ] 1 13 5 12
        {0xB4,0xB1},        // ��   0xBEE4  [ 567 ] 1 13 5 17
        {0xB4,0xB3},        // ��   0xBEE5  [ 568 ] 1 13 5 19
        {0xB4,0xB5},        // ��   0xBEE6  [ 569 ] 1 13 5 21
        {0xB4,0xB7},        // ��   0xBEE7  [ 56a ] 1 13 5 23
        {0xB4,0xBB},        // ��   0xBEE8  [ 56b ] 1 13 5 27
        {0xB4,0xBD},        // ��   0xBEE9  [ 56c ] 1 13 5 29
        {0xB4,0xC1},        // ��   0xBEEA  [ 56d ] 1 13 6 1
        {0xB4,0xC5},        // ��   0xBEEB  [ 56e ] 1 13 6 5
        {0xB4,0xC9},        // ��   0xBEEC  [ 56f ] 1 13 6 9
        {0xB4,0xD3},        // ��   0xBEED  [ 570 ] 1 13 6 19
        {0xB4,0xE1},        // ��   0xBEEE  [ 571 ] 1 13 7 1
        {0xB4,0xE2},        // ��   0xBEEF  [ 572 ] 1 13 7 2
        {0xB4,0xE5},        // ��   0xBEF0  [ 573 ] 1 13 7 5
        {0xB4,0xE6},        // ��   0xBEF1  [ 574 ] 1 13 7 6
        {0xB4,0xE8},        // ��   0xBEF2  [ 575 ] 1 13 7 8
        {0xB4,0xE9},        // ��   0xBEF3  [ 576 ] 1 13 7 9
        {0xB4,0xEA},        // ��   0xBEF4  [ 577 ] 1 13 7 10
        {0xB4,0xEB},        // ��   0xBEF5  [ 578 ] 1 13 7 11
        {0xB4,0xF1},        // ��   0xBEF6  [ 579 ] 1 13 7 17
        {0xB4,0xF3},        // ��   0xBEF7  [ 57a ] 1 13 7 19
        {0xB4,0xF4},        // ��   0xBEF8  [ 57b ] 1 13 7 20
        {0xB4,0xF5},        // ��   0xBEF9  [ 57c ] 1 13 7 21
        {0xB4,0xF6},        // ��   0xBEFA  [ 57d ] 1 13 7 22
        {0xB4,0xF7},        // ��   0xBEFB  [ 57e ] 1 13 7 23
        {0xB4,0xF8},        // ��   0xBEFC  [ 57f ] 1 13 7 24
        {0xB4,0xFA},        // ��   0xBEFD  [ 580 ] 1 13 7 26
        {0xB4,0xFC},        // ��   0xBEFE  [ 581 ] 1 13 7 28
        {0xB5,0x41},        // ��   0xBFA1  [ 582 ] 1 13 10 1
        {0xB5,0x42},        // ��   0xBFA2  [ 583 ] 1 13 10 2
        {0xB5,0x45},        // ��   0xBFA3  [ 584 ] 1 13 10 5
        {0xB5,0x49},        // ��   0xBFA4  [ 585 ] 1 13 10 9
        {0xB5,0x51},        // ��   0xBFA5  [ 586 ] 1 13 10 17
        {0xB5,0x53},        // ��   0xBFA6  [ 587 ] 1 13 10 19
        {0xB5,0x55},        // ��   0xBFA7  [ 588 ] 1 13 10 21
        {0xB5,0x57},        // ��   0xBFA8  [ 589 ] 1 13 10 23
        {0xB5,0x61},        // ��   0xBFA9  [ 58a ] 1 13 11 1
        {0xB5,0x62},        // ��   0xBFAA  [ 58b ] 1 13 11 2
        {0xB5,0x63},        // ��   0xBFAB  [ 58c ] 1 13 11 3
        {0xB5,0x65},        // ��   0xBFAC  [ 58d ] 1 13 11 5
        {0xB5,0x69},        // ��   0xBFAD  [ 58e ] 1 13 11 9
        {0xB5,0x6B},        // ��   0xBFAE  [ 58f ] 1 13 11 11
        {0xB5,0x6C},        // ��   0xBFAF  [ 590 ] 1 13 11 12
        {0xB5,0x71},        // ��   0xBFB0  [ 591 ] 1 13 11 17
        {0xB5,0x73},        // ��   0xBFB1  [ 592 ] 1 13 11 19
        {0xB5,0x74},        // ��   0xBFB2  [ 593 ] 1 13 11 20
        {0xB5,0x75},        // ��   0xBFB3  [ 594 ] 1 13 11 21
        {0xB5,0x76},        // ��   0xBFB4  [ 595 ] 1 13 11 22
        {0xB5,0x77},        // ��   0xBFB5  [ 596 ] 1 13 11 23
        {0xB5,0x7B},        // ��   0xBFB6  [ 597 ] 1 13 11 27
        {0xB5,0x7C},        // ��   0xBFB7  [ 598 ] 1 13 11 28
        {0xB5,0x7D},        // ��   0xBFB8  [ 599 ] 1 13 11 29
        {0xB5,0x81},        // ��   0xBFB9  [ 59a ] 1 13 12 1
        {0xB5,0x85},        // ��   0xBFBA  [ 59b ] 1 13 12 5
        {0xB5,0x89},        // ��   0xBFBB  [ 59c ] 1 13 12 9
        {0xB5,0x91},        // ��   0xBFBC  [ 59d ] 1 13 12 17
        {0xB5,0x93},        // ��   0xBFBD  [ 59e ] 1 13 12 19
        {0xB5,0x95},        // ��   0xBFBE  [ 59f ] 1 13 12 21
        {0xB5,0x96},        // ��   0xBFBF  [ 5a0 ] 1 13 12 22
        {0xB5,0xA1},        // ��   0xBFC0  [ 5a1 ] 1 13 13 1
        {0xB5,0xA2},        // ��   0xBFC1  [ 5a2 ] 1 13 13 2
        {0xB5,0xA5},        // ��   0xBFC2  [ 5a3 ] 1 13 13 5
        {0xB5,0xA9},        // ��   0xBFC3  [ 5a4 ] 1 13 13 9
        {0xB5,0xAA},        // ��   0xBFC4  [ 5a5 ] 1 13 13 10
        {0xB5,0xAB},        // ��   0xBFC5  [ 5a6 ] 1 13 13 11
        {0xB5,0xAD},        // ��   0xBFC6  [ 5a7 ] 1 13 13 13
        {0xB5,0xB0},        // ��   0xBFC7  [ 5a8 ] 1 13 13 16
        {0xB5,0xB1},        // ��   0xBFC8  [ 5a9 ] 1 13 13 17
        {0xB5,0xB3},        // ��   0xBFC9  [ 5aa ] 1 13 13 19
        {0xB5,0xB5},        // ��   0xBFCA  [ 5ab ] 1 13 13 21
        {0xB5,0xB7},        // ��   0xBFCB  [ 5ac ] 1 13 13 23
        {0xB5,0xB9},        // ��   0xBFCC  [ 5ad ] 1 13 13 25
        {0xB5,0xC1},        // ��   0xBFCD  [ 5ae ] 1 13 14 1
        {0xB5,0xC2},        // ��   0xBFCE  [ 5af ] 1 13 14 2
        {0xB5,0xC5},        // ��   0xBFCF  [ 5b0 ] 1 13 14 5
        {0xB5,0xC9},        // ��   0xBFD0  [ 5b1 ] 1 13 14 9
        {0xB5,0xD1},        // ��   0xBFD1  [ 5b2 ] 1 13 14 17
        {0xB5,0xD3},        // ��   0xBFD2  [ 5b3 ] 1 13 14 19
        {0xB5,0xD5},        // ��   0xBFD3  [ 5b4 ] 1 13 14 21
        {0xB5,0xD6},        // ��   0xBFD4  [ 5b5 ] 1 13 14 22
        {0xB5,0xD7},        // ��   0xBFD5  [ 5b6 ] 1 13 14 23
        {0xB5,0xE1},        // ��   0xBFD6  [ 5b7 ] 1 13 15 1
        {0xB5,0xE2},        // ��   0xBFD7  [ 5b8 ] 1 13 15 2
        {0xB5,0xE5},        // ��   0xBFD8  [ 5b9 ] 1 13 15 5
        {0xB5,0xF1},        // ��   0xBFD9  [ 5ba ] 1 13 15 17
        {0xB5,0xF5},        // ��   0xBFDA  [ 5bb ] 1 13 15 21
        {0xB5,0xF7},        // ��   0xBFDB  [ 5bc ] 1 13 15 23
        {0xB6,0x41},        // ��   0xBFDC  [ 5bd ] 1 13 18 1
        {0xB6,0x42},        // ��   0xBFDD  [ 5be ] 1 13 18 2
        {0xB6,0x45},        // ��   0xBFDE  [ 5bf ] 1 13 18 5
        {0xB6,0x49},        // ��   0xBFDF  [ 5c0 ] 1 13 18 9
        {0xB6,0x51},        // ��   0xBFE0  [ 5c1 ] 1 13 18 17
        {0xB6,0x53},        // ��   0xBFE1  [ 5c2 ] 1 13 18 19
        {0xB6,0x55},        // ��   0xBFE2  [ 5c3 ] 1 13 18 21
        {0xB6,0x57},        // ��   0xBFE3  [ 5c4 ] 1 13 18 23
        {0xB6,0x61},        // ��   0xBFE4  [ 5c5 ] 1 13 19 1
        {0xB6,0x62},        // ��   0xBFE5  [ 5c6 ] 1 13 19 2
        {0xB6,0x65},        // ��   0xBFE6  [ 5c7 ] 1 13 19 5
        {0xB6,0x69},        // ��   0xBFE7  [ 5c8 ] 1 13 19 9
        {0xB6,0x71},        // ��   0xBFE8  [ 5c9 ] 1 13 19 17
        {0xB6,0x73},        // ��   0xBFE9  [ 5ca ] 1 13 19 19
        {0xB6,0x75},        // ��   0xBFEA  [ 5cb ] 1 13 19 21
        {0xB6,0x77},        // ��   0xBFEB  [ 5cc ] 1 13 19 23
        {0xB6,0x81},        // ��   0xBFEC  [ 5cd ] 1 13 20 1
        {0xB6,0x82},        // ��   0xBFED  [ 5ce ] 1 13 20 2
        {0xB6,0x85},        // ��   0xBFEE  [ 5cf ] 1 13 20 5
        {0xB6,0x89},        // ��   0xBFEF  [ 5d0 ] 1 13 20 9
        {0xB6,0x8A},        // ��   0xBFF0  [ 5d1 ] 1 13 20 10
        {0xB6,0x8B},        // ��   0xBFF1  [ 5d2 ] 1 13 20 11
        {0xB6,0x91},        // ��   0xBFF2  [ 5d3 ] 1 13 20 17
        {0xB6,0x93},        // ��   0xBFF3  [ 5d4 ] 1 13 20 19
        {0xB6,0x95},        // ��   0xBFF4  [ 5d5 ] 1 13 20 21
        {0xB6,0x97},        // ��   0xBFF5  [ 5d6 ] 1 13 20 23
        {0xB6,0xA1},        // ��   0xBFF6  [ 5d7 ] 1 13 21 1
        {0xB6,0xA2},        // ��   0xBFF7  [ 5d8 ] 1 13 21 2
        {0xB6,0xA5},        // ��   0xBFF8  [ 5d9 ] 1 13 21 5
        {0xB6,0xA9},        // ��   0xBFF9  [ 5da ] 1 13 21 9
        {0xB6,0xB1},        // ��   0xBFFA  [ 5db ] 1 13 21 17
        {0xB6,0xB3},        // ��   0xBFFB  [ 5dc ] 1 13 21 19
        {0xB6,0xB6},        // ��   0xBFFC  [ 5dd ] 1 13 21 22
        {0xB6,0xB7},        // ��   0xBFFD  [ 5de ] 1 13 21 23
        {0xB6,0xC1},        // ��   0xBFFE  [ 5df ] 1 13 22 1
        {0xB6,0xC2},        // ��   0xC0A1  [ 5e0 ] 1 13 22 2
        {0xB6,0xC5},        // ��   0xC0A2  [ 5e1 ] 1 13 22 5
        {0xB6,0xC9},        // ��   0xC0A3  [ 5e2 ] 1 13 22 9
        {0xB6,0xD1},        // ��   0xC0A4  [ 5e3 ] 1 13 22 17
        {0xB6,0xD3},        // ��   0xC0A5  [ 5e4 ] 1 13 22 19
        {0xB6,0xD7},        // ��   0xC0A6  [ 5e5 ] 1 13 22 23
        {0xB6,0xE1},        // ��   0xC0A7  [ 5e6 ] 1 13 23 1
        {0xB6,0xE2},        // ��   0xC0A8  [ 5e7 ] 1 13 23 2
        {0xB6,0xE5},        // ��   0xC0A9  [ 5e8 ] 1 13 23 5
        {0xB6,0xE9},        // ��   0xC0AA  [ 5e9 ] 1 13 23 9
        {0xB6,0xF1},        // ��   0xC0AB  [ 5ea ] 1 13 23 17
        {0xB6,0xF3},        // ��   0xC0AC  [ 5eb ] 1 13 23 19
        {0xB6,0xF5},        // ��   0xC0AD  [ 5ec ] 1 13 23 21
        {0xB6,0xF7},        // ��   0xC0AE  [ 5ed ] 1 13 23 23
        {0xB7,0x41},        // ��   0xC0AF  [ 5ee ] 1 13 26 1
        {0xB7,0x42},        // ��   0xC0B0  [ 5ef ] 1 13 26 2
        {0xB7,0x45},        // ��   0xC0B1  [ 5f0 ] 1 13 26 5
        {0xB7,0x49},        // ��   0xC0B2  [ 5f1 ] 1 13 26 9
        {0xB7,0x51},        // ��   0xC0B3  [ 5f2 ] 1 13 26 17
        {0xB7,0x53},        // ��   0xC0B4  [ 5f3 ] 1 13 26 19
        {0xB7,0x55},        // ��   0xC0B5  [ 5f4 ] 1 13 26 21
        {0xB7,0x57},        // ��   0xC0B6  [ 5f5 ] 1 13 26 23
        {0xB7,0x59},        // ��   0xC0B7  [ 5f6 ] 1 13 26 25
        {0xB7,0x61},        // ��   0xC0B8  [ 5f7 ] 1 13 27 1
        {0xB7,0x62},        // ��   0xC0B9  [ 5f8 ] 1 13 27 2
        {0xB7,0x65},        // ��   0xC0BA  [ 5f9 ] 1 13 27 5
        {0xB7,0x69},        // ��   0xC0BB  [ 5fa ] 1 13 27 9
        {0xB7,0x6F},        // ��   0xC0BC  [ 5fb ] 1 13 27 15
        {0xB7,0x71},        // ��   0xC0BD  [ 5fc ] 1 13 27 17
        {0xB7,0x73},        // ��   0xC0BE  [ 5fd ] 1 13 27 19
        {0xB7,0x75},        // ��   0xC0BF  [ 5fe ] 1 13 27 21
        {0xB7,0x77},        // ��   0xC0C0  [ 5ff ] 1 13 27 23
        {0xB7,0x78},        // ��   0xC0C1  [ 600 ] 1 13 27 24
        {0xB7,0x79},        // ��   0xC0C2  [ 601 ] 1 13 27 25
        {0xB7,0x7A},        // ��   0xC0C3  [ 602 ] 1 13 27 26
        {0xB7,0x7B},        // ��   0xC0C4  [ 603 ] 1 13 27 27
        {0xB7,0x7C},        // ��   0xC0C5  [ 604 ] 1 13 27 28
        {0xB7,0x7D},        // ��   0xC0C6  [ 605 ] 1 13 27 29
        {0xB7,0x81},        // ��   0xC0C7  [ 606 ] 1 13 28 1
        {0xB7,0x85},        // ��   0xC0C8  [ 607 ] 1 13 28 5
        {0xB7,0x89},        // ��   0xC0C9  [ 608 ] 1 13 28 9
        {0xB7,0x91},        // ��   0xC0CA  [ 609 ] 1 13 28 17
        {0xB7,0x95},        // ��   0xC0CB  [ 60a ] 1 13 28 21
        {0xB7,0xA1},        // ��   0xC0CC  [ 60b ] 1 13 29 1
        {0xB7,0xA2},        // ��   0xC0CD  [ 60c ] 1 13 29 2
        {0xB7,0xA5},        // ��   0xC0CE  [ 60d ] 1 13 29 5
        {0xB7,0xA9},        // ��   0xC0CF  [ 60e ] 1 13 29 9
        {0xB7,0xAA},        // ��   0xC0D0  [ 60f ] 1 13 29 10
        {0xB7,0xAB},        // ��   0xC0D1  [ 610 ] 1 13 29 11
        {0xB7,0xB0},        // ��   0xC0D2  [ 611 ] 1 13 29 16
        {0xB7,0xB1},        // ��   0xC0D3  [ 612 ] 1 13 29 17
        {0xB7,0xB3},        // ��   0xC0D4  [ 613 ] 1 13 29 19
        {0xB7,0xB5},        // ��   0xC0D5  [ 614 ] 1 13 29 21
        {0xB7,0xB6},        // ��   0xC0D6  [ 615 ] 1 13 29 22
        {0xB7,0xB7},        // ��   0xC0D7  [ 616 ] 1 13 29 23
        {0xB7,0xB8},        // ��   0xC0D8  [ 617 ] 1 13 29 24
        {0xB7,0xBC},        // ��   0xC0D9  [ 618 ] 1 13 29 28
        {0xB8,0x61},        // ��   0xC0DA  [ 619 ] 1 14 3 1
        {0xB8,0x62},        // ��   0xC0DB  [ 61a ] 1 14 3 2
        {0xB8,0x65},        // ��   0xC0DC  [ 61b ] 1 14 3 5
        {0xB8,0x67},        // ��   0xC0DD  [ 61c ] 1 14 3 7
        {0xB8,0x68},        // ��   0xC0DE  [ 61d ] 1 14 3 8
        {0xB8,0x69},        // ��   0xC0DF  [ 61e ] 1 14 3 9
        {0xB8,0x6B},        // ��   0xC0E0  [ 61f ] 1 14 3 11
        {0xB8,0x71},        // ��   0xC0E1  [ 620 ] 1 14 3 17
        {0xB8,0x73},        // ��   0xC0E2  [ 621 ] 1 14 3 19
        {0xB8,0x75},        // ��   0xC0E3  [ 622 ] 1 14 3 21
        {0xB8,0x76},        // ��   0xC0E4  [ 623 ] 1 14 3 22
        {0xB8,0x77},        // ��   0xC0E5  [ 624 ] 1 14 3 23
        {0xB8,0x78},        // ��   0xC0E6  [ 625 ] 1 14 3 24
        {0xB8,0x81},        // ��   0xC0E7  [ 626 ] 1 14 4 1
        {0xB8,0x82},        // ��   0xC0E8  [ 627 ] 1 14 4 2
        {0xB8,0x85},        // ��   0xC0E9  [ 628 ] 1 14 4 5
        {0xB8,0x89},        // ��   0xC0EA  [ 629 ] 1 14 4 9
        {0xB8,0x91},        // ��   0xC0EB  [ 62a ] 1 14 4 17
        {0xB8,0x93},        // ��   0xC0EC  [ 62b ] 1 14 4 19
        {0xB8,0x95},        // ��   0xC0ED  [ 62c ] 1 14 4 21
        {0xB8,0x96},        // ��   0xC0EE  [ 62d ] 1 14 4 22
        {0xB8,0x97},        // ��   0xC0EF  [ 62e ] 1 14 4 23
        {0xB8,0xA1},        // ��   0xC0F0  [ 62f ] 1 14 5 1
        {0xB8,0xA2},        // ��   0xC0F1  [ 630 ] 1 14 5 2
        {0xB8,0xA5},        // ��   0xC0F2  [ 631 ] 1 14 5 5
        {0xB8,0xA7},        // ��   0xC0F3  [ 632 ] 1 14 5 7
        {0xB8,0xA9},        // ��   0xC0F4  [ 633 ] 1 14 5 9
        {0xB8,0xB1},        // ��   0xC0F5  [ 634 ] 1 14 5 17
        {0xB8,0xB7},        // ��   0xC0F6  [ 635 ] 1 14 5 23
        {0xB8,0xC1},        // ��   0xC0F7  [ 636 ] 1 14 6 1
        {0xB8,0xC5},        // ��   0xC0F8  [ 637 ] 1 14 6 5
        {0xB8,0xC9},        // ��   0xC0F9  [ 638 ] 1 14 6 9
        {0xB8,0xE1},        // ��   0xC0FA  [ 639 ] 1 14 7 1
        {0xB8,0xE2},        // ��   0xC0FB  [ 63a ] 1 14 7 2
        {0xB8,0xE5},        // ��   0xC0FC  [ 63b ] 1 14 7 5
        {0xB8,0xE9},        // ��   0xC0FD  [ 63c ] 1 14 7 9
        {0xB8,0xEB},        // ��   0xC0FE  [ 63d ] 1 14 7 11
        {0xB8,0xF1},        // ��   0xC1A1  [ 63e ] 1 14 7 17
        {0xB8,0xF3},        // ��   0xC1A2  [ 63f ] 1 14 7 19
        {0xB8,0xF5},        // ��   0xC1A3  [ 640 ] 1 14 7 21
        {0xB8,0xF7},        // ��   0xC1A4  [ 641 ] 1 14 7 23
        {0xB8,0xF8},        // ��   0xC1A5  [ 642 ] 1 14 7 24
        {0xB9,0x41},        // ��   0xC1A6  [ 643 ] 1 14 10 1
        {0xB9,0x42},        // ��   0xC1A7  [ 644 ] 1 14 10 2
        {0xB9,0x45},        // ��   0xC1A8  [ 645 ] 1 14 10 5
        {0xB9,0x49},        // ��   0xC1A9  [ 646 ] 1 14 10 9
        {0xB9,0x51},        // ��   0xC1AA  [ 647 ] 1 14 10 17
        {0xB9,0x53},        // ��   0xC1AB  [ 648 ] 1 14 10 19
        {0xB9,0x55},        // ��   0xC1AC  [ 649 ] 1 14 10 21
        {0xB9,0x57},        // ��   0xC1AD  [ 64a ] 1 14 10 23
        {0xB9,0x61},        // ��   0xC1AE  [ 64b ] 1 14 11 1
        {0xB9,0x65},        // ��   0xC1AF  [ 64c ] 1 14 11 5
        {0xB9,0x69},        // ��   0xC1B0  [ 64d ] 1 14 11 9
        {0xB9,0x71},        // ��   0xC1B1  [ 64e ] 1 14 11 17
        {0xB9,0x73},        // ��   0xC1B2  [ 64f ] 1 14 11 19
        {0xB9,0x76},        // ��   0xC1B3  [ 650 ] 1 14 11 22
        {0xB9,0x77},        // ��   0xC1B4  [ 651 ] 1 14 11 23
        {0xB9,0x81},        // ��   0xC1B5  [ 652 ] 1 14 12 1
        {0xB9,0xA1},        // ��   0xC1B6  [ 653 ] 1 14 13 1
        {0xB9,0xA2},        // ��   0xC1B7  [ 654 ] 1 14 13 2
        {0xB9,0xA5},        // ��   0xC1B8  [ 655 ] 1 14 13 5
        {0xB9,0xA9},        // ��   0xC1B9  [ 656 ] 1 14 13 9
        {0xB9,0xAB},        // ��   0xC1BA  [ 657 ] 1 14 13 11
        {0xB9,0xB1},        // ��   0xC1BB  [ 658 ] 1 14 13 17
        {0xB9,0xB3},        // ��   0xC1BC  [ 659 ] 1 14 13 19
        {0xB9,0xB5},        // ��   0xC1BD  [ 65a ] 1 14 13 21
        {0xB9,0xB7},        // ��   0xC1BE  [ 65b ] 1 14 13 23
        {0xB9,0xB8},        // ��   0xC1BF  [ 65c ] 1 14 13 24
        {0xB9,0xB9},        // ��   0xC1C0  [ 65d ] 1 14 13 25
        {0xB9,0xBD},        // ��   0xC1C1  [ 65e ] 1 14 13 29
        {0xB9,0xC1},        // ��   0xC1C2  [ 65f ] 1 14 14 1
        {0xB9,0xC2},        // ��   0xC1C3  [ 660 ] 1 14 14 2
        {0xB9,0xC9},        // ��   0xC1C4  [ 661 ] 1 14 14 9
        {0xB9,0xD3},        // ��   0xC1C5  [ 662 ] 1 14 14 19
        {0xB9,0xD5},        // ��   0xC1C6  [ 663 ] 1 14 14 21
        {0xB9,0xD7},        // ��   0xC1C7  [ 664 ] 1 14 14 23
        {0xB9,0xE1},        // ��   0xC1C8  [ 665 ] 1 14 15 1
        {0xB9,0xF6},        // ��   0xC1C9  [ 666 ] 1 14 15 22
        {0xB9,0xF7},        // ��   0xC1CA  [ 667 ] 1 14 15 23
        {0xBA,0x41},        // ��   0xC1CB  [ 668 ] 1 14 18 1
        {0xBA,0x45},        // ��   0xC1CC  [ 669 ] 1 14 18 5
        {0xBA,0x49},        // ��   0xC1CD  [ 66a ] 1 14 18 9
        {0xBA,0x51},        // ��   0xC1CE  [ 66b ] 1 14 18 17
        {0xBA,0x53},        // ��   0xC1CF  [ 66c ] 1 14 18 19
        {0xBA,0x55},        // ��   0xC1D0  [ 66d ] 1 14 18 21
        {0xBA,0x57},        // ��   0xC1D1  [ 66e ] 1 14 18 23
        {0xBA,0x61},        // ��   0xC1D2  [ 66f ] 1 14 19 1
        {0xBA,0x62},        // ��   0xC1D3  [ 670 ] 1 14 19 2
        {0xBA,0x65},        // ��   0xC1D4  [ 671 ] 1 14 19 5
        {0xBA,0x77},        // ��   0xC1D5  [ 672 ] 1 14 19 23
        {0xBA,0x81},        // ��   0xC1D6  [ 673 ] 1 14 20 1
        {0xBA,0x82},        // ��   0xC1D7  [ 674 ] 1 14 20 2
        {0xBA,0x85},        // ��   0xC1D8  [ 675 ] 1 14 20 5
        {0xBA,0x89},        // ��   0xC1D9  [ 676 ] 1 14 20 9
        {0xBA,0x8A},        // ��   0xC1DA  [ 677 ] 1 14 20 10
        {0xBA,0x8B},        // ��   0xC1DB  [ 678 ] 1 14 20 11
        {0xBA,0x91},        // ��   0xC1DC  [ 679 ] 1 14 20 17
        {0xBA,0x93},        // ��   0xC1DD  [ 67a ] 1 14 20 19
        {0xBA,0x95},        // ��   0xC1DE  [ 67b ] 1 14 20 21
        {0xBA,0x97},        // ��   0xC1DF  [ 67c ] 1 14 20 23
        {0xBA,0xA1},        // ��   0xC1E0  [ 67d ] 1 14 21 1
        {0xBA,0xB6},        // ��   0xC1E1  [ 67e ] 1 14 21 22
        {0xBA,0xC1},        // ��   0xC1E2  [ 67f ] 1 14 22 1
        {0xBA,0xE1},        // ��   0xC1E3  [ 680 ] 1 14 23 1
        {0xBA,0xE2},        // ��   0xC1E4  [ 681 ] 1 14 23 2
        {0xBA,0xE5},        // ��   0xC1E5  [ 682 ] 1 14 23 5
        {0xBA,0xE9},        // ��   0xC1E6  [ 683 ] 1 14 23 9
        {0xBA,0xF1},        // ��   0xC1E7  [ 684 ] 1 14 23 17
        {0xBA,0xF3},        // ��   0xC1E8  [ 685 ] 1 14 23 19
        {0xBA,0xF5},        // ��   0xC1E9  [ 686 ] 1 14 23 21
        {0xBB,0x41},        // ��   0xC1EA  [ 687 ] 1 14 26 1
        {0xBB,0x45},        // ��   0xC1EB  [ 688 ] 1 14 26 5
        {0xBB,0x49},        // ��   0xC1EC  [ 689 ] 1 14 26 9
        {0xBB,0x51},        // ��   0xC1ED  [ 68a ] 1 14 26 17
        {0xBB,0x61},        // ��   0xC1EE  [ 68b ] 1 14 27 1
        {0xBB,0x62},        // ��   0xC1EF  [ 68c ] 1 14 27 2
        {0xBB,0x65},        // ��   0xC1F0  [ 68d ] 1 14 27 5
        {0xBB,0x69},        // ��   0xC1F1  [ 68e ] 1 14 27 9
        {0xBB,0x71},        // ��   0xC1F2  [ 68f ] 1 14 27 17
        {0xBB,0x73},        // ��   0xC1F3  [ 690 ] 1 14 27 19
        {0xBB,0x75},        // ��   0xC1F4  [ 691 ] 1 14 27 21
        {0xBB,0x77},        // ��   0xC1F5  [ 692 ] 1 14 27 23
        {0xBB,0xA1},        // ��   0xC1F6  [ 693 ] 1 14 29 1
        {0xBB,0xA2},        // ��   0xC1F7  [ 694 ] 1 14 29 2
        {0xBB,0xA5},        // ��   0xC1F8  [ 695 ] 1 14 29 5
        {0xBB,0xA8},        // ��   0xC1F9  [ 696 ] 1 14 29 8
        {0xBB,0xA9},        // ��   0xC1FA  [ 697 ] 1 14 29 9
        {0xBB,0xAB},        // ��   0xC1FB  [ 698 ] 1 14 29 11
        {0xBB,0xB1},        // ��   0xC1FC  [ 699 ] 1 14 29 17
        {0xBB,0xB3},        // ��   0xC1FD  [ 69a ] 1 14 29 19
        {0xBB,0xB5},        // ��   0xC1FE  [ 69b ] 1 14 29 21
        {0xBB,0xB7},        // ¡   0xC2A1  [ 69c ] 1 14 29 23
        {0xBB,0xB8},        // ¢   0xC2A2  [ 69d ] 1 14 29 24
        {0xBB,0xBB},        // £   0xC2A3  [ 69e ] 1 14 29 27
        {0xBB,0xBC},        // ¤   0xC2A4  [ 69f ] 1 14 29 28
        {0xBC,0x61},        // ¥   0xC2A5  [ 6a0 ] 1 15 3 1
        {0xBC,0x62},        // ¦   0xC2A6  [ 6a1 ] 1 15 3 2
        {0xBC,0x65},        // §   0xC2A7  [ 6a2 ] 1 15 3 5
        {0xBC,0x67},        // ¨   0xC2A8  [ 6a3 ] 1 15 3 7
        {0xBC,0x69},        // ©   0xC2A9  [ 6a4 ] 1 15 3 9
        {0xBC,0x6C},        // ª   0xC2AA  [ 6a5 ] 1 15 3 12
        {0xBC,0x71},        // «   0xC2AB  [ 6a6 ] 1 15 3 17
        {0xBC,0x73},        // ¬   0xC2AC  [ 6a7 ] 1 15 3 19
        {0xBC,0x75},        // ­   0xC2AD  [ 6a8 ] 1 15 3 21
        {0xBC,0x76},        // ®   0xC2AE  [ 6a9 ] 1 15 3 22
        {0xBC,0x77},        // ¯   0xC2AF  [ 6aa ] 1 15 3 23
        {0xBC,0x81},        // °   0xC2B0  [ 6ab ] 1 15 4 1
        {0xBC,0x82},        // ±   0xC2B1  [ 6ac ] 1 15 4 2
        {0xBC,0x85},        // ²   0xC2B2  [ 6ad ] 1 15 4 5
        {0xBC,0x89},        // ³   0xC2B3  [ 6ae ] 1 15 4 9
        {0xBC,0x91},        // ´   0xC2B4  [ 6af ] 1 15 4 17
        {0xBC,0x93},        // µ   0xC2B5  [ 6b0 ] 1 15 4 19
        {0xBC,0x95},        // ¶   0xC2B6  [ 6b1 ] 1 15 4 21
        {0xBC,0x96},        // ·   0xC2B7  [ 6b2 ] 1 15 4 22
        {0xBC,0x97},        // ¸   0xC2B8  [ 6b3 ] 1 15 4 23
        {0xBC,0xA1},        // ¹   0xC2B9  [ 6b4 ] 1 15 5 1
        {0xBC,0xA5},        // º   0xC2BA  [ 6b5 ] 1 15 5 5
        {0xBC,0xB7},        // »   0xC2BB  [ 6b6 ] 1 15 5 23
        {0xBC,0xE1},        // ¼   0xC2BC  [ 6b7 ] 1 15 7 1
        {0xBC,0xE2},        // ½   0xC2BD  [ 6b8 ] 1 15 7 2
        {0xBC,0xE5},        // ¾   0xC2BE  [ 6b9 ] 1 15 7 5
        {0xBC,0xE9},        // ¿   0xC2BF  [ 6ba ] 1 15 7 9
        {0xBC,0xF1},        // ��   0xC2C0  [ 6bb ] 1 15 7 17
        {0xBC,0xF3},        // ��   0xC2C1  [ 6bc ] 1 15 7 19
        {0xBC,0xF5},        // ��   0xC2C2  [ 6bd ] 1 15 7 21
        {0xBC,0xF6},        // ��   0xC2C3  [ 6be ] 1 15 7 22
        {0xBC,0xF7},        // ��   0xC2C4  [ 6bf ] 1 15 7 23
        {0xBD,0x41},        // ��   0xC2C5  [ 6c0 ] 1 15 10 1
        {0xBD,0x57},        // ��   0xC2C6  [ 6c1 ] 1 15 10 23
        {0xBD,0x61},        // ��   0xC2C7  [ 6c2 ] 1 15 11 1
        {0xBD,0x76},        // ��   0xC2C8  [ 6c3 ] 1 15 11 22
        {0xBD,0xA1},        // ��   0xC2C9  [ 6c4 ] 1 15 13 1
        {0xBD,0xA2},        // ��   0xC2CA  [ 6c5 ] 1 15 13 2
        {0xBD,0xA5},        // ��   0xC2CB  [ 6c6 ] 1 15 13 5
        {0xBD,0xA9},        // ��   0xC2CC  [ 6c7 ] 1 15 13 9
        {0xBD,0xB1},        // ��   0xC2CD  [ 6c8 ] 1 15 13 17
        {0xBD,0xB3},        // ��   0xC2CE  [ 6c9 ] 1 15 13 19
        {0xBD,0xB5},        // ��   0xC2CF  [ 6ca ] 1 15 13 21
        {0xBD,0xB7},        // ��   0xC2D0  [ 6cb ] 1 15 13 23
        {0xBD,0xB9},        // ��   0xC2D1  [ 6cc ] 1 15 13 25
        {0xBD,0xC1},        // ��   0xC2D2  [ 6cd ] 1 15 14 1
        {0xBD,0xC2},        // ��   0xC2D3  [ 6ce ] 1 15 14 2
        {0xBD,0xC9},        // ��   0xC2D4  [ 6cf ] 1 15 14 9
        {0xBD,0xD6},        // ��   0xC2D5  [ 6d0 ] 1 15 14 22
        {0xBD,0xE1},        // ��   0xC2D6  [ 6d1 ] 1 15 15 1
        {0xBD,0xF6},        // ��   0xC2D7  [ 6d2 ] 1 15 15 22
        {0xBE,0x41},        // ��   0xC2D8  [ 6d3 ] 1 15 18 1
        {0xBE,0x45},        // ��   0xC2D9  [ 6d4 ] 1 15 18 5
        {0xBE,0x49},        // ��   0xC2DA  [ 6d5 ] 1 15 18 9
        {0xBE,0x51},        // ��   0xC2DB  [ 6d6 ] 1 15 18 17
        {0xBE,0x53},        // ��   0xC2DC  [ 6d7 ] 1 15 18 19
        {0xBE,0x77},        // ��   0xC2DD  [ 6d8 ] 1 15 19 23
        {0xBE,0x81},        // ��   0xC2DE  [ 6d9 ] 1 15 20 1
        {0xBE,0x82},        // ��   0xC2DF  [ 6da ] 1 15 20 2
        {0xBE,0x85},        // ��   0xC2E0  [ 6db ] 1 15 20 5
        {0xBE,0x89},        // ��   0xC2E1  [ 6dc ] 1 15 20 9
        {0xBE,0x91},        // ��   0xC2E2  [ 6dd ] 1 15 20 17
        {0xBE,0x93},        // ��   0xC2E3  [ 6de ] 1 15 20 19
        {0xBE,0x97},        // ��   0xC2E4  [ 6df ] 1 15 20 23
        {0xBE,0xA1},        // ��   0xC2E5  [ 6e0 ] 1 15 21 1
        {0xBE,0xB6},        // ��   0xC2E6  [ 6e1 ] 1 15 21 22
        {0xBE,0xB7},        // ��   0xC2E7  [ 6e2 ] 1 15 21 23
        {0xBE,0xE1},        // ��   0xC2E8  [ 6e3 ] 1 15 23 1
        {0xBF,0x41},        // ��   0xC2E9  [ 6e4 ] 1 15 26 1
        {0xBF,0x61},        // ��   0xC2EA  [ 6e5 ] 1 15 27 1
        {0xBF,0x71},        // ��   0xC2EB  [ 6e6 ] 1 15 27 17
        {0xBF,0x75},        // ��   0xC2EC  [ 6e7 ] 1 15 27 21
        {0xBF,0x77},        // ��   0xC2ED  [ 6e8 ] 1 15 27 23
        {0xBF,0xA1},        // ��   0xC2EE  [ 6e9 ] 1 15 29 1
        {0xBF,0xA2},        // ��   0xC2EF  [ 6ea ] 1 15 29 2
        {0xBF,0xA5},        // ��   0xC2F0  [ 6eb ] 1 15 29 5
        {0xBF,0xA9},        // ��   0xC2F1  [ 6ec ] 1 15 29 9
        {0xBF,0xB1},        // ��   0xC2F2  [ 6ed ] 1 15 29 17
        {0xBF,0xB3},        // ��   0xC2F3  [ 6ee ] 1 15 29 19
        {0xBF,0xB7},        // ��   0xC2F4  [ 6ef ] 1 15 29 23
        {0xBF,0xB8},        // ��   0xC2F5  [ 6f0 ] 1 15 29 24
        {0xBF,0xBD},        // ��   0xC2F6  [ 6f1 ] 1 15 29 29
        {0xC0,0x61},        // ��   0xC2F7  [ 6f2 ] 1 16 3 1
        {0xC0,0x62},        // ��   0xC2F8  [ 6f3 ] 1 16 3 2
        {0xC0,0x65},        // ��   0xC2F9  [ 6f4 ] 1 16 3 5
        {0xC0,0x67},        // ��   0xC2FA  [ 6f5 ] 1 16 3 7
        {0xC0,0x69},        // ��   0xC2FB  [ 6f6 ] 1 16 3 9
        {0xC0,0x71},        // ��   0xC2FC  [ 6f7 ] 1 16 3 17
        {0xC0,0x73},        // ��   0xC2FD  [ 6f8 ] 1 16 3 19
        {0xC0,0x75},        // ��   0xC2FE  [ 6f9 ] 1 16 3 21
        {0xC0,0x76},        // á   0xC3A1  [ 6fa ] 1 16 3 22
        {0xC0,0x77},        // â   0xC3A2  [ 6fb ] 1 16 3 23
        {0xC0,0x78},        // ã   0xC3A3  [ 6fc ] 1 16 3 24
        {0xC0,0x81},        // ä   0xC3A4  [ 6fd ] 1 16 4 1
        {0xC0,0x82},        // å   0xC3A5  [ 6fe ] 1 16 4 2
        {0xC0,0x85},        // æ   0xC3A6  [ 6ff ] 1 16 4 5
        {0xC0,0x89},        // ç   0xC3A7  [ 700 ] 1 16 4 9
        {0xC0,0x91},        // è   0xC3A8  [ 701 ] 1 16 4 17
        {0xC0,0x93},        // é   0xC3A9  [ 702 ] 1 16 4 19
        {0xC0,0x95},        // ê   0xC3AA  [ 703 ] 1 16 4 21
        {0xC0,0x96},        // ë   0xC3AB  [ 704 ] 1 16 4 22
        {0xC0,0x97},        // ì   0xC3AC  [ 705 ] 1 16 4 23
        {0xC0,0xA1},        // í   0xC3AD  [ 706 ] 1 16 5 1
        {0xC0,0xA5},        // î   0xC3AE  [ 707 ] 1 16 5 5
        {0xC0,0xA7},        // ï   0xC3AF  [ 708 ] 1 16 5 7
        {0xC0,0xA9},        // ð   0xC3B0  [ 709 ] 1 16 5 9
        {0xC0,0xB1},        // ñ   0xC3B1  [ 70a ] 1 16 5 17
        {0xC0,0xB7},        // ò   0xC3B2  [ 70b ] 1 16 5 23
        {0xC0,0xE1},        // ó   0xC3B3  [ 70c ] 1 16 7 1
        {0xC0,0xE2},        // ô   0xC3B4  [ 70d ] 1 16 7 2
        {0xC0,0xE5},        // õ   0xC3B5  [ 70e ] 1 16 7 5
        {0xC0,0xE9},        // ö   0xC3B6  [ 70f ] 1 16 7 9
        {0xC0,0xF1},        // ÷   0xC3B7  [ 710 ] 1 16 7 17
        {0xC0,0xF3},        // ø   0xC3B8  [ 711 ] 1 16 7 19
        {0xC0,0xF5},        // ù   0xC3B9  [ 712 ] 1 16 7 21
        {0xC0,0xF6},        // ú   0xC3BA  [ 713 ] 1 16 7 22
        {0xC0,0xF7},        // û   0xC3BB  [ 714 ] 1 16 7 23
        {0xC1,0x41},        // ü   0xC3BC  [ 715 ] 1 16 10 1
        {0xC1,0x42},        // ý   0xC3BD  [ 716 ] 1 16 10 2
        {0xC1,0x45},        // þ   0xC3BE  [ 717 ] 1 16 10 5
        {0xC1,0x49},        // ÿ   0xC3BF  [ 718 ] 1 16 10 9
        {0xC1,0x51},        // ��   0xC3C0  [ 719 ] 1 16 10 17
        {0xC1,0x53},        // ��   0xC3C1  [ 71a ] 1 16 10 19
        {0xC1,0x55},        // ��   0xC3C2  [ 71b ] 1 16 10 21
        {0xC1,0x57},        // ��   0xC3C3  [ 71c ] 1 16 10 23
        {0xC1,0x61},        // ��   0xC3C4  [ 71d ] 1 16 11 1
        {0xC1,0x65},        // ��   0xC3C5  [ 71e ] 1 16 11 5
        {0xC1,0x76},        // ��   0xC3C6  [ 71f ] 1 16 11 22
        {0xC1,0x81},        // ��   0xC3C7  [ 720 ] 1 16 12 1
        {0xC1,0x85},        // ��   0xC3C8  [ 721 ] 1 16 12 5
        {0xC1,0x97},        // ��   0xC3C9  [ 722 ] 1 16 12 23
        {0xC1,0xA1},        // ��   0xC3CA  [ 723 ] 1 16 13 1
        {0xC1,0xA2},        // ��   0xC3CB  [ 724 ] 1 16 13 2
        {0xC1,0xA5},        // ��   0xC3CC  [ 725 ] 1 16 13 5
        {0xC1,0xA9},        // ��   0xC3CD  [ 726 ] 1 16 13 9
        {0xC1,0xB1},        // ��   0xC3CE  [ 727 ] 1 16 13 17
        {0xC1,0xB3},        // ��   0xC3CF  [ 728 ] 1 16 13 19
        {0xC1,0xB5},        // ��   0xC3D0  [ 729 ] 1 16 13 21
        {0xC1,0xB7},        // ��   0xC3D1  [ 72a ] 1 16 13 23
        {0xC1,0xC1},        // ��   0xC3D2  [ 72b ] 1 16 14 1
        {0xC1,0xC5},        // ��   0xC3D3  [ 72c ] 1 16 14 5
        {0xC1,0xC9},        // ��   0xC3D4  [ 72d ] 1 16 14 9
        {0xC1,0xD7},        // ��   0xC3D5  [ 72e ] 1 16 14 23
        {0xC2,0x41},        // ��   0xC3D6  [ 72f ] 1 16 18 1
        {0xC2,0x45},        // ��   0xC3D7  [ 730 ] 1 16 18 5
        {0xC2,0x49},        // ��   0xC3D8  [ 731 ] 1 16 18 9
        {0xC2,0x51},        // ��   0xC3D9  [ 732 ] 1 16 18 17
        {0xC2,0x53},        // ��   0xC3DA  [ 733 ] 1 16 18 19
        {0xC2,0x55},        // ��   0xC3DB  [ 734 ] 1 16 18 21
        {0xC2,0x57},        // ��   0xC3DC  [ 735 ] 1 16 18 23
        {0xC2,0x61},        // ��   0xC3DD  [ 736 ] 1 16 19 1
        {0xC2,0x71},        // ��   0xC3DE  [ 737 ] 1 16 19 17
        {0xC2,0x81},        // ��   0xC3DF  [ 738 ] 1 16 20 1
        {0xC2,0x82},        // ��   0xC3E0  [ 739 ] 1 16 20 2
        {0xC2,0x85},        // ��   0xC3E1  [ 73a ] 1 16 20 5
        {0xC2,0x89},        // ��   0xC3E2  [ 73b ] 1 16 20 9
        {0xC2,0x91},        // ��   0xC3E3  [ 73c ] 1 16 20 17
        {0xC2,0x93},        // ��   0xC3E4  [ 73d ] 1 16 20 19
        {0xC2,0x95},        // ��   0xC3E5  [ 73e ] 1 16 20 21
        {0xC2,0x97},        // ��   0xC3E6  [ 73f ] 1 16 20 23
        {0xC2,0xA1},        // ��   0xC3E7  [ 740 ] 1 16 21 1
        {0xC2,0xB6},        // ��   0xC3E8  [ 741 ] 1 16 21 22
        {0xC2,0xC1},        // ��   0xC3E9  [ 742 ] 1 16 22 1
        {0xC2,0xC5},        // ��   0xC3EA  [ 743 ] 1 16 22 5
        {0xC2,0xE1},        // ��   0xC3EB  [ 744 ] 1 16 23 1
        {0xC2,0xE5},        // ��   0xC3EC  [ 745 ] 1 16 23 5
        {0xC2,0xE9},        // ��   0xC3ED  [ 746 ] 1 16 23 9
        {0xC2,0xF1},        // ��   0xC3EE  [ 747 ] 1 16 23 17
        {0xC2,0xF3},        // ��   0xC3EF  [ 748 ] 1 16 23 19
        {0xC2,0xF5},        // ��   0xC3F0  [ 749 ] 1 16 23 21
        {0xC2,0xF7},        // ��   0xC3F1  [ 74a ] 1 16 23 23
        {0xC3,0x41},        // ��   0xC3F2  [ 74b ] 1 16 26 1
        {0xC3,0x45},        // ��   0xC3F3  [ 74c ] 1 16 26 5
        {0xC3,0x49},        // ��   0xC3F4  [ 74d ] 1 16 26 9
        {0xC3,0x51},        // ��   0xC3F5  [ 74e ] 1 16 26 17
        {0xC3,0x57},        // ��   0xC3F6  [ 74f ] 1 16 26 23
        {0xC3,0x61},        // ��   0xC3F7  [ 750 ] 1 16 27 1
        {0xC3,0x62},        // ��   0xC3F8  [ 751 ] 1 16 27 2
        {0xC3,0x65},        // ��   0xC3F9  [ 752 ] 1 16 27 5
        {0xC3,0x69},        // ��   0xC3FA  [ 753 ] 1 16 27 9
        {0xC3,0x71},        // ��   0xC3FB  [ 754 ] 1 16 27 17
        {0xC3,0x73},        // ��   0xC3FC  [ 755 ] 1 16 27 19
        {0xC3,0x75},        // ��   0xC3FD  [ 756 ] 1 16 27 21
        {0xC3,0x77},        // ��   0xC3FE  [ 757 ] 1 16 27 23
        {0xC3,0xA1},        // ġ   0xC4A1  [ 758 ] 1 16 29 1
        {0xC3,0xA2},        // Ģ   0xC4A2  [ 759 ] 1 16 29 2
        {0xC3,0xA5},        // ģ   0xC4A3  [ 75a ] 1 16 29 5
        {0xC3,0xA8},        // Ĥ   0xC4A4  [ 75b ] 1 16 29 8
        {0xC3,0xA9},        // ĥ   0xC4A5  [ 75c ] 1 16 29 9
        {0xC3,0xAA},        // Ħ   0xC4A6  [ 75d ] 1 16 29 10
        {0xC3,0xB1},        // ħ   0xC4A7  [ 75e ] 1 16 29 17
        {0xC3,0xB3},        // Ĩ   0xC4A8  [ 75f ] 1 16 29 19
        {0xC3,0xB5},        // ĩ   0xC4A9  [ 760 ] 1 16 29 21
        {0xC3,0xB7},        // Ī   0xC4AA  [ 761 ] 1 16 29 23
        {0xC4,0x61},        // ī   0xC4AB  [ 762 ] 1 17 3 1
        {0xC4,0x62},        // Ĭ   0xC4AC  [ 763 ] 1 17 3 2
        {0xC4,0x65},        // ĭ   0xC4AD  [ 764 ] 1 17 3 5
        {0xC4,0x69},        // Į   0xC4AE  [ 765 ] 1 17 3 9
        {0xC4,0x71},        // į   0xC4AF  [ 766 ] 1 17 3 17
        {0xC4,0x73},        // İ   0xC4B0  [ 767 ] 1 17 3 19
        {0xC4,0x75},        // ı   0xC4B1  [ 768 ] 1 17 3 21
        {0xC4,0x77},        // Ĳ   0xC4B2  [ 769 ] 1 17 3 23
        {0xC4,0x81},        // ĳ   0xC4B3  [ 76a ] 1 17 4 1
        {0xC4,0x82},        // Ĵ   0xC4B4  [ 76b ] 1 17 4 2
        {0xC4,0x85},        // ĵ   0xC4B5  [ 76c ] 1 17 4 5
        {0xC4,0x89},        // Ķ   0xC4B6  [ 76d ] 1 17 4 9
        {0xC4,0x91},        // ķ   0xC4B7  [ 76e ] 1 17 4 17
        {0xC4,0x93},        // ĸ   0xC4B8  [ 76f ] 1 17 4 19
        {0xC4,0x95},        // Ĺ   0xC4B9  [ 770 ] 1 17 4 21
        {0xC4,0x96},        // ĺ   0xC4BA  [ 771 ] 1 17 4 22
        {0xC4,0x97},        // Ļ   0xC4BB  [ 772 ] 1 17 4 23
        {0xC4,0xA1},        // ļ   0xC4BC  [ 773 ] 1 17 5 1
        {0xC4,0xA2},        // Ľ   0xC4BD  [ 774 ] 1 17 5 2
        {0xC4,0xB7},        // ľ   0xC4BE  [ 775 ] 1 17 5 23
        {0xC4,0xE1},        // Ŀ   0xC4BF  [ 776 ] 1 17 7 1
        {0xC4,0xE2},        // ��   0xC4C0  [ 777 ] 1 17 7 2
        {0xC4,0xE5},        // ��   0xC4C1  [ 778 ] 1 17 7 5
        {0xC4,0xE8},        // ��   0xC4C2  [ 779 ] 1 17 7 8
        {0xC4,0xE9},        // ��   0xC4C3  [ 77a ] 1 17 7 9
        {0xC4,0xF1},        // ��   0xC4C4  [ 77b ] 1 17 7 17
        {0xC4,0xF3},        // ��   0xC4C5  [ 77c ] 1 17 7 19
        {0xC4,0xF5},        // ��   0xC4C6  [ 77d ] 1 17 7 21
        {0xC4,0xF6},        // ��   0xC4C7  [ 77e ] 1 17 7 22
        {0xC4,0xF7},        // ��   0xC4C8  [ 77f ] 1 17 7 23
        {0xC5,0x41},        // ��   0xC4C9  [ 780 ] 1 17 10 1
        {0xC5,0x42},        // ��   0xC4CA  [ 781 ] 1 17 10 2
        {0xC5,0x45},        // ��   0xC4CB  [ 782 ] 1 17 10 5
        {0xC5,0x49},        // ��   0xC4CC  [ 783 ] 1 17 10 9
        {0xC5,0x51},        // ��   0xC4CD  [ 784 ] 1 17 10 17
        {0xC5,0x53},        // ��   0xC4CE  [ 785 ] 1 17 10 19
        {0xC5,0x55},        // ��   0xC4CF  [ 786 ] 1 17 10 21
        {0xC5,0x57},        // ��   0xC4D0  [ 787 ] 1 17 10 23
        {0xC5,0x61},        // ��   0xC4D1  [ 788 ] 1 17 11 1
        {0xC5,0x65},        // ��   0xC4D2  [ 789 ] 1 17 11 5
        {0xC5,0x69},        // ��   0xC4D3  [ 78a ] 1 17 11 9
        {0xC5,0x71},        // ��   0xC4D4  [ 78b ] 1 17 11 17
        {0xC5,0x73},        // ��   0xC4D5  [ 78c ] 1 17 11 19
        {0xC5,0x75},        // ��   0xC4D6  [ 78d ] 1 17 11 21
        {0xC5,0x76},        // ��   0xC4D7  [ 78e ] 1 17 11 22
        {0xC5,0x77},        // ��   0xC4D8  [ 78f ] 1 17 11 23
        {0xC5,0x81},        // ��   0xC4D9  [ 790 ] 1 17 12 1
        {0xC5,0xA1},        // ��   0xC4DA  [ 791 ] 1 17 13 1
        {0xC5,0xA2},        // ��   0xC4DB  [ 792 ] 1 17 13 2
        {0xC5,0xA5},        // ��   0xC4DC  [ 793 ] 1 17 13 5
        {0xC5,0xA9},        // ��   0xC4DD  [ 794 ] 1 17 13 9
        {0xC5,0xB1},        // ��   0xC4DE  [ 795 ] 1 17 13 17
        {0xC5,0xB3},        // ��   0xC4DF  [ 796 ] 1 17 13 19
        {0xC5,0xB5},        // ��   0xC4E0  [ 797 ] 1 17 13 21
        {0xC5,0xB7},        // ��   0xC4E1  [ 798 ] 1 17 13 23
        {0xC5,0xC1},        // ��   0xC4E2  [ 799 ] 1 17 14 1
        {0xC5,0xC2},        // ��   0xC4E3  [ 79a ] 1 17 14 2
        {0xC5,0xC5},        // ��   0xC4E4  [ 79b ] 1 17 14 5
        {0xC5,0xC9},        // ��   0xC4E5  [ 79c ] 1 17 14 9
        {0xC5,0xD1},        // ��   0xC4E6  [ 79d ] 1 17 14 17
        {0xC5,0xD7},        // ��   0xC4E7  [ 79e ] 1 17 14 23
        {0xC5,0xE1},        // ��   0xC4E8  [ 79f ] 1 17 15 1
        {0xC5,0xF7},        // ��   0xC4E9  [ 7a0 ] 1 17 15 23
        {0xC6,0x41},        // ��   0xC4EA  [ 7a1 ] 1 17 18 1
        {0xC6,0x49},        // ��   0xC4EB  [ 7a2 ] 1 17 18 9
        {0xC6,0x61},        // ��   0xC4EC  [ 7a3 ] 1 17 19 1
        {0xC6,0x81},        // ��   0xC4ED  [ 7a4 ] 1 17 20 1
        {0xC6,0x82},        // ��   0xC4EE  [ 7a5 ] 1 17 20 2
        {0xC6,0x85},        // ��   0xC4EF  [ 7a6 ] 1 17 20 5
        {0xC6,0x89},        // ��   0xC4F0  [ 7a7 ] 1 17 20 9
        {0xC6,0x91},        // ��   0xC4F1  [ 7a8 ] 1 17 20 17
        {0xC6,0x93},        // ��   0xC4F2  [ 7a9 ] 1 17 20 19
        {0xC6,0x95},        // ��   0xC4F3  [ 7aa ] 1 17 20 21
        {0xC6,0x97},        // ��   0xC4F4  [ 7ab ] 1 17 20 23
        {0xC6,0xA1},        // ��   0xC4F5  [ 7ac ] 1 17 21 1
        {0xC6,0xA5},        // ��   0xC4F6  [ 7ad ] 1 17 21 5
        {0xC6,0xA9},        // ��   0xC4F7  [ 7ae ] 1 17 21 9
        {0xC6,0xB7},        // ��   0xC4F8  [ 7af ] 1 17 21 23
        {0xC6,0xC1},        // ��   0xC4F9  [ 7b0 ] 1 17 22 1
        {0xC6,0xD7},        // ��   0xC4FA  [ 7b1 ] 1 17 22 23
        {0xC6,0xE1},        // ��   0xC4FB  [ 7b2 ] 1 17 23 1
        {0xC6,0xE2},        // ��   0xC4FC  [ 7b3 ] 1 17 23 2
        {0xC6,0xE5},        // ��   0xC4FD  [ 7b4 ] 1 17 23 5
        {0xC6,0xE9},        // ��   0xC4FE  [ 7b5 ] 1 17 23 9
        {0xC6,0xF1},        // š   0xC5A1  [ 7b6 ] 1 17 23 17
        {0xC6,0xF3},        // Ţ   0xC5A2  [ 7b7 ] 1 17 23 19
        {0xC6,0xF5},        // ţ   0xC5A3  [ 7b8 ] 1 17 23 21
        {0xC6,0xF7},        // Ť   0xC5A4  [ 7b9 ] 1 17 23 23
        {0xC7,0x41},        // ť   0xC5A5  [ 7ba ] 1 17 26 1
        {0xC7,0x45},        // Ŧ   0xC5A6  [ 7bb ] 1 17 26 5
        {0xC7,0x49},        // ŧ   0xC5A7  [ 7bc ] 1 17 26 9
        {0xC7,0x51},        // Ũ   0xC5A8  [ 7bd ] 1 17 26 17
        {0xC7,0x61},        // ũ   0xC5A9  [ 7be ] 1 17 27 1
        {0xC7,0x62},        // Ū   0xC5AA  [ 7bf ] 1 17 27 2
        {0xC7,0x65},        // ū   0xC5AB  [ 7c0 ] 1 17 27 5
        {0xC7,0x69},        // Ŭ   0xC5AC  [ 7c1 ] 1 17 27 9
        {0xC7,0x71},        // ŭ   0xC5AD  [ 7c2 ] 1 17 27 17
        {0xC7,0x73},        // Ů   0xC5AE  [ 7c3 ] 1 17 27 19
        {0xC7,0x77},        // ů   0xC5AF  [ 7c4 ] 1 17 27 23
        {0xC7,0xA1},        // Ű   0xC5B0  [ 7c5 ] 1 17 29 1
        {0xC7,0xA2},        // ű   0xC5B1  [ 7c6 ] 1 17 29 2
        {0xC7,0xA5},        // Ų   0xC5B2  [ 7c7 ] 1 17 29 5
        {0xC7,0xA9},        // ų   0xC5B3  [ 7c8 ] 1 17 29 9
        {0xC7,0xB1},        // Ŵ   0xC5B4  [ 7c9 ] 1 17 29 17
        {0xC7,0xB3},        // ŵ   0xC5B5  [ 7ca ] 1 17 29 19
        {0xC7,0xB5},        // Ŷ   0xC5B6  [ 7cb ] 1 17 29 21
        {0xC7,0xB7},        // ŷ   0xC5B7  [ 7cc ] 1 17 29 23
        {0xC8,0x61},        // Ÿ   0xC5B8  [ 7cd ] 1 18 3 1
        {0xC8,0x62},        // Ź   0xC5B9  [ 7ce ] 1 18 3 2
        {0xC8,0x65},        // ź   0xC5BA  [ 7cf ] 1 18 3 5
        {0xC8,0x69},        // Ż   0xC5BB  [ 7d0 ] 1 18 3 9
        {0xC8,0x6A},        // ż   0xC5BC  [ 7d1 ] 1 18 3 10
        {0xC8,0x71},        // Ž   0xC5BD  [ 7d2 ] 1 18 3 17
        {0xC8,0x73},        // ž   0xC5BE  [ 7d3 ] 1 18 3 19
        {0xC8,0x75},        // ſ   0xC5BF  [ 7d4 ] 1 18 3 21
        {0xC8,0x76},        // ��   0xC5C0  [ 7d5 ] 1 18 3 22
        {0xC8,0x77},        // ��   0xC5C1  [ 7d6 ] 1 18 3 23
        {0xC8,0x81},        // ��   0xC5C2  [ 7d7 ] 1 18 4 1
        {0xC8,0x82},        // ��   0xC5C3  [ 7d8 ] 1 18 4 2
        {0xC8,0x85},        // ��   0xC5C4  [ 7d9 ] 1 18 4 5
        {0xC8,0x89},        // ��   0xC5C5  [ 7da ] 1 18 4 9
        {0xC8,0x91},        // ��   0xC5C6  [ 7db ] 1 18 4 17
        {0xC8,0x93},        // ��   0xC5C7  [ 7dc ] 1 18 4 19
        {0xC8,0x95},        // ��   0xC5C8  [ 7dd ] 1 18 4 21
        {0xC8,0x96},        // ��   0xC5C9  [ 7de ] 1 18 4 22
        {0xC8,0x97},        // ��   0xC5CA  [ 7df ] 1 18 4 23
        {0xC8,0xA1},        // ��   0xC5CB  [ 7e0 ] 1 18 5 1
        {0xC8,0xB7},        // ��   0xC5CC  [ 7e1 ] 1 18 5 23
        {0xC8,0xE1},        // ��   0xC5CD  [ 7e2 ] 1 18 7 1
        {0xC8,0xE2},        // ��   0xC5CE  [ 7e3 ] 1 18 7 2
        {0xC8,0xE5},        // ��   0xC5CF  [ 7e4 ] 1 18 7 5
        {0xC8,0xE9},        // ��   0xC5D0  [ 7e5 ] 1 18 7 9
        {0xC8,0xEB},        // ��   0xC5D1  [ 7e6 ] 1 18 7 11
        {0xC8,0xF1},        // ��   0xC5D2  [ 7e7 ] 1 18 7 17
        {0xC8,0xF3},        // ��   0xC5D3  [ 7e8 ] 1 18 7 19
        {0xC8,0xF5},        // ��   0xC5D4  [ 7e9 ] 1 18 7 21
        {0xC8,0xF6},        // ��   0xC5D5  [ 7ea ] 1 18 7 22
        {0xC8,0xF7},        // ��   0xC5D6  [ 7eb ] 1 18 7 23
        {0xC9,0x41},        // ��   0xC5D7  [ 7ec ] 1 18 10 1
        {0xC9,0x42},        // ��   0xC5D8  [ 7ed ] 1 18 10 2
        {0xC9,0x45},        // ��   0xC5D9  [ 7ee ] 1 18 10 5
        {0xC9,0x49},        // ��   0xC5DA  [ 7ef ] 1 18 10 9
        {0xC9,0x51},        // ��   0xC5DB  [ 7f0 ] 1 18 10 17
        {0xC9,0x53},        // ��   0xC5DC  [ 7f1 ] 1 18 10 19
        {0xC9,0x55},        // ��   0xC5DD  [ 7f2 ] 1 18 10 21
        {0xC9,0x57},        // ��   0xC5DE  [ 7f3 ] 1 18 10 23
        {0xC9,0x61},        // ��   0xC5DF  [ 7f4 ] 1 18 11 1
        {0xC9,0x65},        // ��   0xC5E0  [ 7f5 ] 1 18 11 5
        {0xC9,0x76},        // ��   0xC5E1  [ 7f6 ] 1 18 11 22
        {0xC9,0x81},        // ��   0xC5E2  [ 7f7 ] 1 18 12 1
        {0xC9,0x85},        // ��   0xC5E3  [ 7f8 ] 1 18 12 5
        {0xC9,0xA1},        // ��   0xC5E4  [ 7f9 ] 1 18 13 1
        {0xC9,0xA2},        // ��   0xC5E5  [ 7fa ] 1 18 13 2
        {0xC9,0xA5},        // ��   0xC5E6  [ 7fb ] 1 18 13 5
        {0xC9,0xA9},        // ��   0xC5E7  [ 7fc ] 1 18 13 9
        {0xC9,0xB1},        // ��   0xC5E8  [ 7fd ] 1 18 13 17
        {0xC9,0xB3},        // ��   0xC5E9  [ 7fe ] 1 18 13 19
        {0xC9,0xB5},        // ��   0xC5EA  [ 7ff ] 1 18 13 21
        {0xC9,0xB7},        // ��   0xC5EB  [ 800 ] 1 18 13 23
        {0xC9,0xBC},        // ��   0xC5EC  [ 801 ] 1 18 13 28
        {0xC9,0xC1},        // ��   0xC5ED  [ 802 ] 1 18 14 1
        {0xC9,0xC5},        // ��   0xC5EE  [ 803 ] 1 18 14 5
        {0xC9,0xE1},        // ��   0xC5EF  [ 804 ] 1 18 15 1
        {0xCA,0x41},        // ��   0xC5F0  [ 805 ] 1 18 18 1
        {0xCA,0x45},        // ��   0xC5F1  [ 806 ] 1 18 18 5
        {0xCA,0x55},        // ��   0xC5F2  [ 807 ] 1 18 18 21
        {0xCA,0x57},        // ��   0xC5F3  [ 808 ] 1 18 18 23
        {0xCA,0x61},        // ��   0xC5F4  [ 809 ] 1 18 19 1
        {0xCA,0x81},        // ��   0xC5F5  [ 80a ] 1 18 20 1
        {0xCA,0x82},        // ��   0xC5F6  [ 80b ] 1 18 20 2
        {0xCA,0x85},        // ��   0xC5F7  [ 80c ] 1 18 20 5
        {0xCA,0x89},        // ��   0xC5F8  [ 80d ] 1 18 20 9
        {0xCA,0x91},        // ��   0xC5F9  [ 80e ] 1 18 20 17
        {0xCA,0x93},        // ��   0xC5FA  [ 80f ] 1 18 20 19
        {0xCA,0x95},        // ��   0xC5FB  [ 810 ] 1 18 20 21
        {0xCA,0x97},        // ��   0xC5FC  [ 811 ] 1 18 20 23
        {0xCA,0xA1},        // ��   0xC5FD  [ 812 ] 1 18 21 1
        {0xCA,0xB6},        // ��   0xC5FE  [ 813 ] 1 18 21 22
        {0xCA,0xC1},        // ơ   0xC6A1  [ 814 ] 1 18 22 1
        {0xCA,0xE1},        // Ƣ   0xC6A2  [ 815 ] 1 18 23 1
        {0xCA,0xE2},        // ƣ   0xC6A3  [ 816 ] 1 18 23 2
        {0xCA,0xE5},        // Ƥ   0xC6A4  [ 817 ] 1 18 23 5
        {0xCA,0xE9},        // ƥ   0xC6A5  [ 818 ] 1 18 23 9
        {0xCA,0xF1},        // Ʀ   0xC6A6  [ 819 ] 1 18 23 17
        {0xCA,0xF3},        // Ƨ   0xC6A7  [ 81a ] 1 18 23 19
        {0xCA,0xF7},        // ƨ   0xC6A8  [ 81b ] 1 18 23 23
        {0xCB,0x41},        // Ʃ   0xC6A9  [ 81c ] 1 18 26 1
        {0xCB,0x45},        // ƪ   0xC6AA  [ 81d ] 1 18 26 5
        {0xCB,0x49},        // ƫ   0xC6AB  [ 81e ] 1 18 26 9
        {0xCB,0x51},        // Ƭ   0xC6AC  [ 81f ] 1 18 26 17
        {0xCB,0x57},        // ƭ   0xC6AD  [ 820 ] 1 18 26 23
        {0xCB,0x61},        // Ʈ   0xC6AE  [ 821 ] 1 18 27 1
        {0xCB,0x62},        // Ư   0xC6AF  [ 822 ] 1 18 27 2
        {0xCB,0x65},        // ư   0xC6B0  [ 823 ] 1 18 27 5
        {0xCB,0x68},        // Ʊ   0xC6B1  [ 824 ] 1 18 27 8
        {0xCB,0x69},        // Ʋ   0xC6B2  [ 825 ] 1 18 27 9
        {0xCB,0x6B},        // Ƴ   0xC6B3  [ 826 ] 1 18 27 11
        {0xCB,0x71},        // ƴ   0xC6B4  [ 827 ] 1 18 27 17
        {0xCB,0x73},        // Ƶ   0xC6B5  [ 828 ] 1 18 27 19
        {0xCB,0x75},        // ƶ   0xC6B6  [ 829 ] 1 18 27 21
        {0xCB,0x81},        // Ʒ   0xC6B7  [ 82a ] 1 18 28 1
        {0xCB,0x85},        // Ƹ   0xC6B8  [ 82b ] 1 18 28 5
        {0xCB,0x89},        // ƹ   0xC6B9  [ 82c ] 1 18 28 9
        {0xCB,0x91},        // ƺ   0xC6BA  [ 82d ] 1 18 28 17
        {0xCB,0x93},        // ƻ   0xC6BB  [ 82e ] 1 18 28 19
        {0xCB,0xA1},        // Ƽ   0xC6BC  [ 82f ] 1 18 29 1
        {0xCB,0xA2},        // ƽ   0xC6BD  [ 830 ] 1 18 29 2
        {0xCB,0xA5},        // ƾ   0xC6BE  [ 831 ] 1 18 29 5
        {0xCB,0xA9},        // ƿ   0xC6BF  [ 832 ] 1 18 29 9
        {0xCB,0xB1},        // ��   0xC6C0  [ 833 ] 1 18 29 17
        {0xCB,0xB3},        // ��   0xC6C1  [ 834 ] 1 18 29 19
        {0xCB,0xB5},        // ��   0xC6C2  [ 835 ] 1 18 29 21
        {0xCB,0xB7},        // ��   0xC6C3  [ 836 ] 1 18 29 23
        {0xCC,0x61},        // ��   0xC6C4  [ 837 ] 1 19 3 1
        {0xCC,0x62},        // ��   0xC6C5  [ 838 ] 1 19 3 2
        {0xCC,0x63},        // ��   0xC6C6  [ 839 ] 1 19 3 3
        {0xCC,0x65},        // ��   0xC6C7  [ 83a ] 1 19 3 5
        {0xCC,0x69},        // ��   0xC6C8  [ 83b ] 1 19 3 9
        {0xCC,0x6B},        // ��   0xC6C9  [ 83c ] 1 19 3 11
        {0xCC,0x71},        // ��   0xC6CA  [ 83d ] 1 19 3 17
        {0xCC,0x73},        // ��   0xC6CB  [ 83e ] 1 19 3 19
        {0xCC,0x75},        // ��   0xC6CC  [ 83f ] 1 19 3 21
        {0xCC,0x76},        // ��   0xC6CD  [ 840 ] 1 19 3 22
        {0xCC,0x77},        // ��   0xC6CE  [ 841 ] 1 19 3 23
        {0xCC,0x7B},        // ��   0xC6CF  [ 842 ] 1 19 3 27
        {0xCC,0x81},        // ��   0xC6D0  [ 843 ] 1 19 4 1
        {0xCC,0x82},        // ��   0xC6D1  [ 844 ] 1 19 4 2
        {0xCC,0x85},        // ��   0xC6D2  [ 845 ] 1 19 4 5
        {0xCC,0x89},        // ��   0xC6D3  [ 846 ] 1 19 4 9
        {0xCC,0x91},        // ��   0xC6D4  [ 847 ] 1 19 4 17
        {0xCC,0x93},        // ��   0xC6D5  [ 848 ] 1 19 4 19
        {0xCC,0x95},        // ��   0xC6D6  [ 849 ] 1 19 4 21
        {0xCC,0x96},        // ��   0xC6D7  [ 84a ] 1 19 4 22
        {0xCC,0x97},        // ��   0xC6D8  [ 84b ] 1 19 4 23
        {0xCC,0xA1},        // ��   0xC6D9  [ 84c ] 1 19 5 1
        {0xCC,0xA2},        // ��   0xC6DA  [ 84d ] 1 19 5 2
        {0xCC,0xE1},        // ��   0xC6DB  [ 84e ] 1 19 7 1
        {0xCC,0xE2},        // ��   0xC6DC  [ 84f ] 1 19 7 2
        {0xCC,0xE5},        // ��   0xC6DD  [ 850 ] 1 19 7 5
        {0xCC,0xE9},        // ��   0xC6DE  [ 851 ] 1 19 7 9
        {0xCC,0xF1},        // ��   0xC6DF  [ 852 ] 1 19 7 17
        {0xCC,0xF3},        // ��   0xC6E0  [ 853 ] 1 19 7 19
        {0xCC,0xF5},        // ��   0xC6E1  [ 854 ] 1 19 7 21
        {0xCC,0xF6},        // ��   0xC6E2  [ 855 ] 1 19 7 22
        {0xCC,0xF7},        // ��   0xC6E3  [ 856 ] 1 19 7 23
        {0xCD,0x41},        // ��   0xC6E4  [ 857 ] 1 19 10 1
        {0xCD,0x42},        // ��   0xC6E5  [ 858 ] 1 19 10 2
        {0xCD,0x45},        // ��   0xC6E6  [ 859 ] 1 19 10 5
        {0xCD,0x49},        // ��   0xC6E7  [ 85a ] 1 19 10 9
        {0xCD,0x51},        // ��   0xC6E8  [ 85b ] 1 19 10 17
        {0xCD,0x53},        // ��   0xC6E9  [ 85c ] 1 19 10 19
        {0xCD,0x55},        // ��   0xC6EA  [ 85d ] 1 19 10 21
        {0xCD,0x57},        // ��   0xC6EB  [ 85e ] 1 19 10 23
        {0xCD,0x61},        // ��   0xC6EC  [ 85f ] 1 19 11 1
        {0xCD,0x65},        // ��   0xC6ED  [ 860 ] 1 19 11 5
        {0xCD,0x69},        // ��   0xC6EE  [ 861 ] 1 19 11 9
        {0xCD,0x71},        // ��   0xC6EF  [ 862 ] 1 19 11 17
        {0xCD,0x73},        // ��   0xC6F0  [ 863 ] 1 19 11 19
        {0xCD,0x76},        // ��   0xC6F1  [ 864 ] 1 19 11 22
        {0xCD,0x77},        // ��   0xC6F2  [ 865 ] 1 19 11 23
        {0xCD,0x81},        // ��   0xC6F3  [ 866 ] 1 19 12 1
        {0xCD,0x89},        // ��   0xC6F4  [ 867 ] 1 19 12 9
        {0xCD,0x93},        // ��   0xC6F5  [ 868 ] 1 19 12 19
        {0xCD,0x95},        // ��   0xC6F6  [ 869 ] 1 19 12 21
        {0xCD,0xA1},        // ��   0xC6F7  [ 86a ] 1 19 13 1
        {0xCD,0xA2},        // ��   0xC6F8  [ 86b ] 1 19 13 2
        {0xCD,0xA5},        // ��   0xC6F9  [ 86c ] 1 19 13 5
        {0xCD,0xA9},        // ��   0xC6FA  [ 86d ] 1 19 13 9
        {0xCD,0xB1},        // ��   0xC6FB  [ 86e ] 1 19 13 17
        {0xCD,0xB3},        // ��   0xC6FC  [ 86f ] 1 19 13 19
        {0xCD,0xB5},        // ��   0xC6FD  [ 870 ] 1 19 13 21
        {0xCD,0xB7},        // ��   0xC6FE  [ 871 ] 1 19 13 23
        {0xCD,0xC1},        // ǡ   0xC7A1  [ 872 ] 1 19 14 1
        {0xCD,0xD7},        // Ǣ   0xC7A2  [ 873 ] 1 19 14 23
        {0xCE,0x41},        // ǣ   0xC7A3  [ 874 ] 1 19 18 1
        {0xCE,0x45},        // Ǥ   0xC7A4  [ 875 ] 1 19 18 5
        {0xCE,0x61},        // ǥ   0xC7A5  [ 876 ] 1 19 19 1
        {0xCE,0x65},        // Ǧ   0xC7A6  [ 877 ] 1 19 19 5
        {0xCE,0x69},        // ǧ   0xC7A7  [ 878 ] 1 19 19 9
        {0xCE,0x73},        // Ǩ   0xC7A8  [ 879 ] 1 19 19 19
        {0xCE,0x75},        // ǩ   0xC7A9  [ 87a ] 1 19 19 21
        {0xCE,0x81},        // Ǫ   0xC7AA  [ 87b ] 1 19 20 1
        {0xCE,0x82},        // ǫ   0xC7AB  [ 87c ] 1 19 20 2
        {0xCE,0x85},        // Ǭ   0xC7AC  [ 87d ] 1 19 20 5
        {0xCE,0x88},        // ǭ   0xC7AD  [ 87e ] 1 19 20 8
        {0xCE,0x89},        // Ǯ   0xC7AE  [ 87f ] 1 19 20 9
        {0xCE,0x8B},        // ǯ   0xC7AF  [ 880 ] 1 19 20 11
        {0xCE,0x91},        // ǰ   0xC7B0  [ 881 ] 1 19 20 17
        {0xCE,0x93},        // Ǳ   0xC7B1  [ 882 ] 1 19 20 19
        {0xCE,0x95},        // ǲ   0xC7B2  [ 883 ] 1 19 20 21
        {0xCE,0x97},        // ǳ   0xC7B3  [ 884 ] 1 19 20 23
        {0xCE,0xA1},        // Ǵ   0xC7B4  [ 885 ] 1 19 21 1
        {0xCE,0xB7},        // ǵ   0xC7B5  [ 886 ] 1 19 21 23
        {0xCE,0xE1},        // Ƕ   0xC7B6  [ 887 ] 1 19 23 3
        {0xCE,0xE5},        // Ƿ   0xC7B7  [ 888 ] 1 7 14 11
        {0xCE,0xE9},        // Ǹ   0xC7B8  [ 889 ] 1 7 14 19
        {0xCE,0xF1},        // ǹ   0xC7B9  [ 88a ] 1 7 15 3
        {0xCE,0xF5},        // Ǻ   0xC7BA  [ 88b ] 1 7 15 11
        {0xCF,0x41},        // ǻ   0xC7BB  [ 88c ] 1 7 20 3
        {0xCF,0x45},        // Ǽ   0xC7BC  [ 88d ] 1 7 20 11
        {0xCF,0x49},        // ǽ   0xC7BD  [ 88e ] 1 7 20 19
        {0xCF,0x51},        // Ǿ   0xC7BE  [ 88f ] 1 7 21 3
        {0xCF,0x55},        // ǿ   0xC7BF  [ 890 ] 1 7 21 11
        {0xCF,0x57},        // ��   0xC7C0  [ 891 ] 1 7 21 15
        {0xCF,0x61},        // ��   0xC7C1  [ 892 ] 1 7 22 3
        {0xCF,0x65},        // ��   0xC7C2  [ 893 ] 1 7 22 10
        {0xCF,0x69},        // ��   0xC7C3  [ 894 ] 1 7 22 19
        {0xCF,0x71},        // ��   0xC7C4  [ 895 ] 1 7 23 3
        {0xCF,0x73},        // ��   0xC7C5  [ 896 ] 1 7 23 7
        {0xCF,0x75},        // ��   0xC7C6  [ 897 ] 1 7 23 11
        {0xCF,0xA1},        // ��   0xC7C7  [ 898 ] 1 7 26 3
        {0xCF,0xA2},        // ��   0xC7C8  [ 899 ] 1 7 26 5
        {0xCF,0xA5},        // ��   0xC7C9  [ 89a ] 1 7 26 11
        {0xCF,0xA9},        // ��   0xC7CA  [ 89b ] 1 7 26 19
        {0xCF,0xB1},        // ��   0xC7CB  [ 89c ] 1 7 27 3
        {0xCF,0xB3},        // ��   0xC7CC  [ 89d ] 1 7 27 7
        {0xCF,0xB5},        // ��   0xC7CD  [ 89e ] 1 7 27 11
        {0xCF,0xB7},        // ��   0xC7CE  [ 89f ] 1 7 27 15
        {0xD0,0x61},        // ��   0xC7CF  [ 8a0 ] 1 8 6 3
        {0xD0,0x62},        // ��   0xC7D0  [ 8a1 ] 1 8 6 5
        {0xD0,0x65},        // ��   0xC7D1  [ 8a2 ] 1 8 6 11
        {0xD0,0x69},        // ��   0xC7D2  [ 8a3 ] 1 8 6 19
        {0xD0,0x6E},        // ��   0xC7D3  [ 8a4 ] 1 8 6 29
        {0xD0,0x71},        // ��   0xC7D4  [ 8a5 ] 1 8 7 2
        {0xD0,0x73},        // ��   0xC7D5  [ 8a6 ] 1 8 7 7
        {0xD0,0x75},        // ��   0xC7D6  [ 8a7 ] 1 8 7 11
        {0xD0,0x77},        // ��   0xC7D7  [ 8a8 ] 1 8 7 15
        {0xD0,0x81},        // ��   0xC7D8  [ 8a9 ] 1 8 8 3
        {0xD0,0x82},        // ��   0xC7D9  [ 8aa ] 1 8 8 5
        {0xD0,0x85},        // ��   0xC7DA  [ 8ab ] 1 8 8 11
        {0xD0,0x89},        // ��   0xC7DB  [ 8ac ] 1 8 8 19
        {0xD0,0x91},        // ��   0xC7DC  [ 8ad ] 1 8 9 3
        {0xD0,0x93},        // ��   0xC7DD  [ 8ae ] 1 8 9 7
        {0xD0,0x95},        // ��   0xC7DE  [ 8af ] 1 8 9 11
        {0xD0,0x96},        // ��   0xC7DF  [ 8b0 ] 1 8 9 13
        {0xD0,0x97},        // ��   0xC7E0  [ 8b1 ] 1 8 9 15
        {0xD0,0xA1},        // ��   0xC7E1  [ 8b2 ] 1 8 10 3
        {0xD0,0xB7},        // ��   0xC7E2  [ 8b3 ] 1 8 11 15
        {0xD0,0xE1},        // ��   0xC7E3  [ 8b4 ] 1 8 14 3
        {0xD0,0xE2},        // ��   0xC7E4  [ 8b5 ] 1 8 14 5
        {0xD0,0xE5},        // ��   0xC7E5  [ 8b6 ] 1 8 14 11
        {0xD0,0xE9},        // ��   0xC7E6  [ 8b7 ] 1 8 14 18
        {0xD0,0xEB},        // ��   0xC7E7  [ 8b8 ] 1 8 14 23
        {0xD0,0xF1},        // ��   0xC7E8  [ 8b9 ] 1 8 15 3
        {0xD0,0xF3},        // ��   0xC7E9  [ 8ba ] 1 8 15 7
        {0xD0,0xF5},        // ��   0xC7EA  [ 8bb ] 1 8 15 11
        {0xD0,0xF7},        // ��   0xC7EB  [ 8bc ] 1 8 15 15
        {0xD1,0x41},        // ��   0xC7EC  [ 8bd ] 1 8 20 3
        {0xD1,0x42},        // ��   0xC7ED  [ 8be ] 1 8 20 5
        {0xD1,0x45},        // ��   0xC7EE  [ 8bf ] 1 8 20 11
        {0xD1,0x49},        // ��   0xC7EF  [ 8c0 ] 1 8 20 19
        {0xD1,0x51},        // ��   0xC7F0  [ 8c1 ] 1 8 21 3
        {0xD1,0x53},        // ��   0xC7F1  [ 8c2 ] 1 8 21 7
        {0xD1,0x55},        // ��   0xC7F2  [ 8c3 ] 1 8 21 11
        {0xD1,0x57},        // ��   0xC7F3  [ 8c4 ] 1 8 21 15
        {0xD1,0x61},        // ��   0xC7F4  [ 8c5 ] 1 8 22 3
        {0xD1,0x62},        // ��   0xC7F5  [ 8c6 ] 1 8 22 5
        {0xD1,0x65},        // ��   0xC7F6  [ 8c7 ] 1 8 22 11
        {0xD1,0x69},        // ��   0xC7F7  [ 8c8 ] 1 8 22 19
        {0xD1,0x71},        // ��   0xC7F8  [ 8c9 ] 1 8 23 2
        {0xD1,0x73},        // ��   0xC7F9  [ 8ca ] 1 8 23 7
        {0xD1,0x75},        // ��   0xC7FA  [ 8cb ] 1 8 23 11
        {0xD1,0x76},        // ��   0xC7FB  [ 8cc ] 1 8 23 13
        {0xD1,0x77},        // ��   0xC7FC  [ 8cd ] 1 8 23 15
        {0xD1,0x81},        // ��   0xC7FD  [ 8ce ] 1 8 24 3
        {0xD1,0x85},        // ��   0xC7FE  [ 8cf ] 1 8 24 11
        {0xD1,0x89},        // ȡ   0xC8A1  [ 8d0 ] 1 8 24 19
        {0xD1,0x93},        // Ȣ   0xC8A2  [ 8d1 ] 1 8 25 7
        {0xD1,0xA1},        // ȣ   0xC8A3  [ 8d2 ] 1 8 26 3
        {0xD1,0xA2},        // Ȥ   0xC8A4  [ 8d3 ] 1 8 26 5
        {0xD1,0xA5},        // ȥ   0xC8A5  [ 8d4 ] 1 8 26 11
        {0xD1,0xA9},        // Ȧ   0xC8A6  [ 8d5 ] 1 8 26 19
        {0xD1,0xAE},        // ȧ   0xC8A7  [ 8d6 ] 1 8 26 29
        {0xD1,0xB1},        // Ȩ   0xC8A8  [ 8d7 ] 1 8 27 3
        {0xD1,0xB3},        // ȩ   0xC8A9  [ 8d8 ] 1 8 27 7
        {0xD1,0xB5},        // Ȫ   0xC8AA  [ 8d9 ] 1 8 27 11
        {0xD1,0xB7},        // ȫ   0xC8AB  [ 8da ] 1 8 27 15
        {0xD1,0xBB},        // Ȭ   0xC8AC  [ 8db ] 1 8 27 22
        {0xD1,0xC1},        // ȭ   0xC8AD  [ 8dc ] 1 8 28 3
        {0xD1,0xC2},        // Ȯ   0xC8AE  [ 8dd ] 1 8 28 5
        {0xD1,0xC5},        // ȯ   0xC8AF  [ 8de ] 1 8 28 11
        {0xD1,0xC9},        // Ȱ   0xC8B0  [ 8df ] 1 8 28 19
        {0xD1,0xD5},        // ȱ   0xC8B1  [ 8e0 ] 1 8 29 11
        {0xD1,0xD7},        // Ȳ   0xC8B2  [ 8e1 ] 1 8 29 15
        {0xD1,0xE1},        // ȳ   0xC8B3  [ 8e2 ] 1 8 11110 3
        {0xD1,0xE2},        // ȴ   0xC8B4  [ 8e3 ] 1 8 11110 5
        {0xD1,0xE5},        // ȵ   0xC8B5  [ 8e4 ] 1 8 11110 11
        {0xD1,0xF5},        // ȶ   0xC8B6  [ 8e5 ] 1 8 11111 11
        {0xD1,0xF7},        // ȷ   0xC8B7  [ 8e6 ] 1 8 11111 15
        {0xD2,0x41},        // ȸ   0xC8B8  [ 8e7 ] 1 9 4 3
        {0xD2,0x42},        // ȹ   0xC8B9  [ 8e8 ] 1 9 4 5
        {0xD2,0x45},        // Ⱥ   0xC8BA  [ 8e9 ] 1 9 4 11
        {0xD2,0x49},        // Ȼ   0xC8BB  [ 8ea ] 1 9 4 19
        {0xD2,0x53},        // ȼ   0xC8BC  [ 8eb ] 1 9 5 7
        {0xD2,0x55},        // Ƚ   0xC8BD  [ 8ec ] 1 9 5 11
        {0xD2,0x57},        // Ⱦ   0xC8BE  [ 8ed ] 1 9 5 14
        {0xD2,0x61},        // ȿ   0xC8BF  [ 8ee ] 1 9 6 3
        {0xD2,0x65},        // ��   0xC8C0  [ 8ef ] 1 9 6 11
        {0xD2,0x69},        // ��   0xC8C1  [ 8f0 ] 1 9 6 19
        {0xD2,0x73},        // ��   0xC8C2  [ 8f1 ] 1 9 7 7
        {0xD2,0x75},        // ��   0xC8C3  [ 8f2 ] 1 9 7 11
        {0xD2,0x81},        // ��   0xC8C4  [ 8f3 ] 1 9 8 3
        {0xD2,0x82},        // ��   0xC8C5  [ 8f4 ] 1 9 8 5
        {0xD2,0x85},        // ��   0xC8C6  [ 8f5 ] 1 9 8 11
        {0xD2,0x89},        // ��   0xC8C7  [ 8f6 ] 1 9 8 19
        {0xD2,0x8E},        // ��   0xC8C8  [ 8f7 ] 1 9 8 29
        {0xD2,0x91},        // ��   0xC8C9  [ 8f8 ] 1 9 9 3
        {0xD2,0x95},        // ��   0xC8CA  [ 8f9 ] 1 9 9 11
        {0xD2,0x97},        // ��   0xC8CB  [ 8fa ] 1 9 9 15
        {0xD2,0xA1},        // ��   0xC8CC  [ 8fb ] 1 9 10 3
        {0xD2,0xA5},        // ��   0xC8CD  [ 8fc ] 1 9 10 11
        {0xD2,0xA9},        // ��   0xC8CE  [ 8fd ] 1 9 10 19
        {0xD2,0xB1},        // ��   0xC8CF  [ 8fe ] 1 9 11 3
        {0xD2,0xB7},        // ��   0xC8D0  [ 8ff ] 1 9 11 14
        {0xD2,0xC1},        // ��   0xC8D1  [ 900 ] 1 9 12 3
        {0xD2,0xC2},        // ��   0xC8D2  [ 901 ] 1 9 12 5
        {0xD2,0xC5},        // ��   0xC8D3  [ 902 ] 1 9 12 11
        {0xD2,0xC9},        // ��   0xC8D4  [ 903 ] 1 9 12 19
        {0xD2,0xD7},        // ��   0xC8D5  [ 904 ] 1 9 13 15
        {0xD2,0xE1},        // ��   0xC8D6  [ 905 ] 1 9 14 3
        {0xD2,0xE2},        // ��   0xC8D7  [ 906 ] 1 9 14 5
        {0xD2,0xE5},        // ��   0xC8D8  [ 907 ] 1 9 14 11
        {0xD2,0xE9},        // ��   0xC8D9  [ 908 ] 1 9 14 19
        {0xD2,0xF1},        // ��   0xC8DA  [ 909 ] 1 9 15 3
        {0xD2,0xF3},        // ��   0xC8DB  [ 90a ] 1 9 15 7
        {0xD2,0xF5},        // ��   0xC8DC  [ 90b ] 1 9 15 11
        {0xD2,0xF7},        // ��   0xC8DD  [ 90c ] 1 9 15 15
        {0xD3,0x41},        // ��   0xC8DE  [ 90d ] 1 9 20 3
        {0xD3,0x42},        // ��   0xC8DF  [ 90e ] 1 9 20 5
        {0xD3,0x45},        // ��   0xC8E0  [ 90f ] 1 9 20 11
        {0xD3,0x49},        // ��   0xC8E1  [ 910 ] 1 9 20 19
        {0xD3,0x51},        // ��   0xC8E2  [ 911 ] 1 9 21 2
        {0xD3,0x55},        // ��   0xC8E3  [ 912 ] 1 9 21 11
        {0xD3,0x57},        // ��   0xC8E4  [ 913 ] 1 9 21 15
        {0xD3,0x61},        // ��   0xC8E5  [ 914 ] 1 9 22 3
        {0xD3,0x62},        // ��   0xC8E6  [ 915 ] 1 9 22 5
        {0xD3,0x65},        // ��   0xC8E7  [ 916 ] 1 9 22 11
        {0xD3,0x67},        // ��   0xC8E8  [ 917 ] 1 9 22 15
        {0xD3,0x68},        // ��   0xC8E9  [ 918 ] 1 9 22 17
        {0xD3,0x69},        // ��   0xC8EA  [ 919 ] 1 9 22 19
        {0xD3,0x6A},        // ��   0xC8EB  [ 91a ] 1 9 22 21
        {0xD3,0x71},        // ��   0xC8EC  [ 91b ] 1 9 23 3
        {0xD3,0x73},        // ��   0xC8ED  [ 91c ] 1 9 23 7
        {0xD3,0x75},        // ��   0xC8EE  [ 91d ] 1 9 23 11
        {0xD3,0x77},        // ��   0xC8EF  [ 91e ] 1 9 23 15
        {0xD3,0x7B},        // ��   0xC8F0  [ 91f ] 1 9 23 23
        {0xD3,0x81},        // ��   0xC8F1  [ 920 ] 1 9 24 3
        {0xD3,0x85},        // ��   0xC8F2  [ 921 ] 1 9 24 11
        {0xD3,0x89},        // ��   0xC8F3  [ 922 ] 1 9 24 19
        {0xD3,0x91},        // ��   0xC8F4  [ 923 ] 1 9 25 2
        {0xD3,0x93},        // ��   0xC8F5  [ 924 ] 1 9 25 7
        {0xD3,0x97},        // ��   0xC8F6  [ 925 ] 1 9 25 15
        {0xD3,0xA1},        // ��   0xC8F7  [ 926 ] 1 9 26 3
        {0xD3,0xA2},        // ��   0xC8F8  [ 927 ] 1 9 26 5
        {0xD3,0xA5},        // ��   0xC8F9  [ 928 ] 1 9 26 11
        {0xD3,0xA9},        // ��   0xC8FA  [ 929 ] 1 9 26 19
        {0xD3,0xB1},        // ��   0xC8FB  [ 92a ] 1 9 27 3
        {0xD3,0xB3},        // ��   0xC8FC  [ 92b ] 1 9 27 7
        {0xD3,0xB5},        // ��   0xC8FD  [ 92c ] 1 9 27 11
        {0xD3,0xB7}         // ��   0xC8FE  [ 92d ] 1 9 27 14
};

/*
 *  2 ����Ʈ ������ �ѱ�:
 * 
 * |        first byte             |  |          second Byte          |
 * |                               |  |                               |
 *    7   6   5   4   3   2   1   0      7   6   5   4   3   2   1   0
 * +---+---+---+---+---+---+---+---+  +---+---+---+---+---+---+---+---+
 * | 1 |   |   |   |   |   |   |   |  |   |   |   |   |   |   |   |   |
 * +---+---+---+---+---+---+---+---+  +---+---+---+---+---+---+---+---+
 *   |   |               |   |                  |   |               |
 *   |   +---------------+   +------------------+   +---------------+
 *   |         �ʼ�                  �߼�                  ����
 *   |
 * MSB(�ѱ�(1)/����(0) ǥ��)

 * ��ü�ڼ� :
 * ��ħ ���� ���� : �ʼ�(19) x �߼�(21) = 399 ��
 * ��ħ �ִ� ���� : �ʼ�(19) x �߼�(21) x ����(27) = 10,773 �� 
 */
 
// tables for processing Korean font
// �ʼ� : space + ����(14) + ������(5) = 20 ��
unsigned char table_initial[21] = {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
// �߼� : space + ����(10) + ������(11) = 22 ��
unsigned char table_vowel[30] = {0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21};
// ���� : space + ����(14) + ������(11) + ������(2) = 28 ��
unsigned char table_final[30] = {0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,17,18,19,20,21,22,23,24,25,26,27};

unsigned char bul_initial[2][22] = {{0,0,0,0,0,0,0,0,0,1,3,3,3,1,2,4,4,4,2,1,3,0},
                                   {0,5,5,5,5,5,5,5,5,6,7,7,7,6,6,7,7,7,6,6,7,5}};
unsigned char bul_final[22] = {0,0,2,0,2,1,2,1,2,3,0,2,1,3,3,1,2,1,3,3,1,1};

/* ----------------------------------------------------------------------------
 * convert Korean KS code to KSSM code
 * -------------------------------------------------------------------------- */
uint16_t korean_ks2kssm_converter(uint16_t ks)
{
    uint8_t msb, lsb;
    uint16_t index, kssm;
    
    msb = ks>>8;
    lsb = ks&0xff;

    if((ks>=0xb0a1) && (ks<=0xc8fe)) {
        index = (msb-0xb0)*94 + lsb-0xa1;
        kssm = kssm_code_table[index][0]<<8;
        kssm |= kssm_code_table[index][1];
        return kssm;
    }
    else
        return 0;
}

/* ----------------------------------------------------------------------------
 * convert Korean KSSM code to KS code
 * -------------------------------------------------------------------------- */
uint16_t korean_kssm2ks_converter(uint16_t kssm)
{
    uint16_t index, high, low, ks;
    int16_t pos;
    
    for(low=0, high=MAX_KS_CODE_NUM; low <= high; ) {
        index = (low+high)>>1;
        pos = kssm - (kssm_code_table[index][0]<<8)
            - kssm_code_table[index][1];    
                    
        if(pos < 0)
            high = index - 1;
        else if(pos > 0)
            low = index + 1;
        else
            break;
    }        
            
    if(index != MAX_KS_CODE_NUM) {
        ks = (index/94 + 0xb0)<<8;
        ks |= (index%94) + 0xa1;
    }
    else {
        for(ks = 0x2020, index=0; index < 51; index++) {
            if(sg_table[index] == kssm) {
                ks = 0xa4a1 + index;
                break;
            }
        }    
    }   
    return ks;
}

/* ----------------------------------------------------------------------------
 * convert Unicode to kssm code
 * -------------------------------------------------------------------------- */
uint16_t korean_unicode2kssm_converter(uint16_t unicode)
{
    uint8_t initial, vowel, final;
    uint16_t kssm;
    
    initial = (unicode-0xac00)/(28*21);
    vowel = (unicode-0xac00)%(28*21)/28;
    final = (unicode-0xac00)%28;
    
    kssm = 0x8000;
    kssm |= (initial+2)<<10;
    kssm |= unicode_table_vowel[vowel]<<5;
    kssm |= unicode_table_final[final];
    
    return kssm;
}

/* ----------------------------------------------------------------------------
 * convert Unicode to ks code
 * -------------------------------------------------------------------------- */

#endif

