// Sweep the motor speed from full-speed reverse (-1.0) to full speed forwards (1.0)

#include "mbed.h"
#include "Motor.h"
#include <string>
//Motor m(D10, D9, D8); // pwm, fwd, rev

PwmOut Motor(D10);
DigitalOut direction(D9);
Serial pc(USBTX, USBRX); // tx, rx
Serial lora(PA_13, PA_14);
Timer timer;

char buffer[200]= {0, };
char ch;
int status_flag = 0;
int change_flag = 0;


bool control_something_on(void)
{
    if(status_flag == 1) {
        pc.printf("\r\n [Already ON] \r\n");
        return false;
    } else {
        pc.printf("\r\n [Fan ON] \r\n");
        status_flag = 1;

        Motor.write(0);

        return true;
    }
    /*for (float s= 0.3; s < 1.0 ; s += 0.01) {
        m.speed(s);
        if( s > 0.9 ){
            s = 0;
        }
        wait(0.02);
    }*/
}

bool control_something_off(void)
{
    if( status_flag == 0 ) {
        pc.printf("\r\n [Already OFF] \r\n");
        return false;
    } else {
        pc.printf("\r\n [Fan OFF] \r\n");
        status_flag = 0;
        Motor.write(1);

        return true;

        //m.speed(0);
    }
}

void recv(void)
{
    string str;
    lora.gets(buffer,49);
    str = buffer;

    pc.printf(buffer); //Debug for recv
    while(1) {
        if(!(lora.readable())) {
            break;
        }
        ch = lora.getc();
    }
    if(strstr(buffer, "\"led\":0") != NULL) {
        pc.printf("\r\n RECV CONTROL MSG [OFF]\r\n");
        if( control_something_off() == true ) {
            lora.printf("AT+SKTPDAT=1,telemetry,0,{\"FAN\":\"off\"}\r\n");
        }

    }
    if(strstr(buffer, "\"led\":1") != NULL) {
        pc.printf("\r\n RECV CONTROL MSG [ON]\r\n");
        if( control_something_on() == true ) {
            lora.printf("AT+SKTPDAT=1,telemetry,0,{\"FAN\":\"on\"}\r\n");
        }
    }


}


int main()
{
    pc.baud(115200);
    lora.baud(115200);

    unsigned int curr_Time1;
    unsigned int curr_Time2;

    direction.write(1); // fan
    Motor.period_ms(1); // fan
    Motor.write(1);
    lora.printf("AT*RNDISDATA=1\r\n");
    wait(1);

    pc.printf("Hello World!\n\r");
    timer.start();
    curr_Time1 = timer.read();

    //lora.printf("AT+SKTPCON=1,MQTT,218.53.242.111,1883,120,1,simple_v1.0,0e768bc0370e11e8a3f1,ServiceID,Device2\r\n");
    lora.printf("AT+SKTPCON=1,MQTT,211.234.246.112,1883,120,1,simple_v1.0,795a3b00ac1411e8aaea,smartfarm1,smartfarmFAN\r\n");
    pc.printf("[SKTPCON OK]\n\r");
    lora.attach(&recv,Serial::RxIrq);
}