#include "mbed.h"
#include "Serial_HL.h"
#include "FuncGenFSST.h"
#include "Tp1Ord.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

SignedRampGen fg1;
float ampl1 = 1.0;
float v1 = 0; // ausgang nach der Amplitude
Tp1Ord tp1;

void CommandHandler();

void ExecSignalChain();

Ticker tc;

AnalogOut dac1(PA_5);

int main(void)
{
	pc.format(8,SerialBLK::None,1);
	pc.baud(500000); // 115200
	ua0.SvMessage("FuncGen"); // Meldung zum PC senden
	
	// tc.attach_us(&ExecSignalChain, 100); // Mit timer-Interrupt für 10khz audio
	
	Timer stw; stw.start();
	while(1) {
		CommandHandler();
		if( stw.read_us()>10000 ) { // 100Hz
			stw.reset();
			ExecSignalChain(); // zur simulation mit 100Hz aufrufen
			if( ua0.acqON ) {
				ua0.WriteSV(1, v1);
				ua0.WriteSV(2, tp1.y);
			}
		}
	}
	return 1;
}

void ExecSignalChain()
{
	fg1.CalcOneStep();
	v1 = ampl1*fg1.val;
	tp1.CalcOneStep(v1);
	// Achtung skalierung und Übersteuerung bedenken
	// dac1.write( 0.5 + 0.5*v1);
}

void CommandHandler()
{
	uint8_t cmd;
	if( !pc.IsDataAvail() )
		return;
	
	cmd = ua0.GetCommand();
	
	if( cmd==2 )
	{
		fg1.SetFrequ(ua0.ReadF());
		ua0.SvMessage("Set Frequ");
	}
	if( cmd==3 )
	{
		ampl1=ua0.ReadF();
		ua0.SvMessage("Set Ampl.");
	}
	if( cmd==4 )
	{
		tp1.SetAlpha(ua0.ReadF());
		ua0.SvMessage("Set Alpha");
	}
}