/* mbed MCP4261 Library, for driving the 8-Bit Single/Dual SPI Digital POT with Non-Volatile Memory
 * Copyright (c) 2015, Created by Steen Joergensen (stjo2809)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 #include "mbed.h"
 #include "MCP4261.h"
 
//=============================================================================
// Public functions
//=============================================================================

    MCP4261::MCP4261(SPI& spi, PinName nCs, PinName nWP, PinName nSHDN): _spi(spi), _nCs(nCs), _nWP(nWP), _nSHDN(nSHDN) 
    {
        _nCs = 1;            
    }    
    
    MCP4261::MCP4261(SPI& spi, PinName nCs, PinName nWP): _spi(spi), _nCs(nCs), _nWP(nWP), _nSHDN(NC) 
    {
        _nCs = 1;           
    }    
    
    int MCP4261::read(char address)
    {
        return _read(address);    
    }

   
    void MCP4261::write(char address, int data)
    {
        _write(address, data);
    }
    
    void MCP4261::inc(bool number)
    {
        if(number == 0)
        {
            _make_command_byte(CB_INCR, VW0_ADDR, 0); 
            _nCs = 0;
            _spi.write(_command_byte);
            _nCs = 1;   
        }
        else
        {
            _make_command_byte(CB_INCR, VW1_ADDR, 0);
            _nCs = 0;
            _spi.write(_command_byte);
            _nCs = 1;    
        }    
    }
   
    void MCP4261::dec(bool number)
    {
        if(number == 0)
        {
            _make_command_byte(CB_DECR, VW0_ADDR, 0); 
            _nCs = 0;
            _spi.write(_command_byte);
            _nCs = 1;   
        }
        else
        {
            _make_command_byte(CB_DECR, VW1_ADDR, 0);
            _nCs = 0;
            _spi.write(_command_byte);
            _nCs = 1;    
        }     
    }
    
    
    int MCP4261::status()
    {
        return _read(STATUS_ADDR);    
    }
    
    
    int MCP4261::tcon()
    {
        return _read(TCON_ADDR);    
    }
    
   
    void MCP4261::tcon(int data)
    {
        _write(TCON_ADDR, data);    
    }
    
    
    int MCP4261::wiper(bool number)
    {
        if(number == 0)
        {
            return _read(VW0_ADDR);
        }
        else
        {
            return _read(VW1_ADDR);
        }
             
    }
    
    
    void MCP4261::wiper(bool number, int data)
    {
        if(number == 0)
        {
            _write(VW0_ADDR, data);
        }
        else
        {
            _write(VW1_ADDR, data);
        }       
    }
    
    
    int MCP4261::nvwiper(bool number)
    {
        if(number == 0)
        {
            return _read(NVW0_ADDR);
        }
        else
        {
            return _read(NVW1_ADDR);
        }     
    }
    
    
    void MCP4261::nvwiper(bool number, int data)
    {
        if(number == 0)
        {
            _write(NVW0_ADDR, data);
        }
        else
        {
            _write(NVW1_ADDR, data);
        }    
    }
    
    
    void MCP4261::shdn(bool act)
    {
        _nSHDN = ~act;    
    }
    
    
    void MCP4261::wp(bool act)
    {
        _nWP = ~act;
    }
    
//=============================================================================
// Private functions
//=============================================================================

    char MCP4261::_make_command_byte(int com, char address, int data)
    {
        if(data > 0xff && data <= 0x3FF)
        {
            _command_byte = address << 4;                   // add address to _command_byte  
            _command_byte = _command_byte | (data >> 8);    // add data to _command_byte
            _command_byte = _command_byte | (com << 2);     // add com to _command_byte         
        }
        else
        {
            _command_byte = address << 4;                   // add address to _command_byte  
            _command_byte = _command_byte | (com << 2);     // add com to _command_byte      
        }
        
        return _command_byte;   
    }
    
    int MCP4261::_read(char address)                         
    {
        int _response_msb;
        int _response_lsb;
        int _response;
         
        _response = 0;                                      // clear _response for old data
        _response_msb = 0;                                  // clear _response_msb for old data
        _response_lsb = 0;                                  // clear _response_lsb for old data
        
        _make_command_byte(CB_READ, address, 0);                       
        
        _nCs = 0;
        _response_msb = _spi.write(_command_byte);
        _response_lsb = _spi.write(0xff);                   // not important bit of the 16 bits
        _nCs = 1;
        
        _response = _response_msb << 8;
        _response = _response | _response_lsb;
        
        return _response;
    }
                                    
    void MCP4261::_write(char address, int data)            
    {
        _make_command_byte(CB_WRITE, address, data);
        int _send_data = data & 0xff;
        
        _nCs = 0;
        _spi.write(_command_byte);
        _spi.write(_send_data);
        _nCs = 1;
    }

  



