/* mbed MCP3204 Library, for driving the 2.7V 4-Channel 12-Bit A/D Converters with SPI™ Serial Interface
 * Copyright (c) 2015, Created by Steen Joergensen (stjo2809)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 #include "mbed.h"
 #include "MCP3204.h"
 
//=============================================================================
// Public functions
//=============================================================================

    MCP3204::MCP3204(SPI& spi, PinName nCs) : _spi(spi), _nCs(nCs)
    {
        _nCs = 1; _nCs = 0; _nCs = 1;   
    }
    
    int MCP3204::sgl(char channel)
    {
        return _read(SINGLE, channel);    
    }
        
    int MCP3204::diff(char channel)
    {
        return _read(DIFFERENTIAL, channel);    
    }
    
//=============================================================================
// Private functions
//=============================================================================
    
    int MCP3204::_make_value_from_responce(int _msb, int _lsb)
    {
        int responce = _msb << 8;
        responce = responce | _lsb;
        responce = responce & 0xfff;
        
        return responce;  
    }
        
    int MCP3204::_read(char sgl_or_diff, char channel)
    {
        _nCs = 0;
        _spi.write(sgl_or_diff);
        int responce_msb = _spi.write(channel);
        int responce_lsb = _spi.write(0xff);                           // don't care bits
        _nCs = 1;
        
        int responce = _make_value_from_responce(responce_msb, responce_lsb);
        
        return responce;     
    }    
