/* mbed MCP3204 Library, for driving the 2.7V 4-Channel 12-Bit A/D Converters with SPI™ Serial Interface
 * Copyright (c) 2015, Created by Steen Joergensen (stjo2809)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "mbed.h"

#ifndef MBED_MCP3204_H
#define MBED_MCP3204_H

//=============================================================================
// Declaration of variables & custom #defines
//=============================================================================

#define CH0             0x00       // Channel 0 for single and for differential is CH0 = IN+ and CH1 = IN- 
#define CH1             0x40       // Channel 1 for single and for differential is CH0 = IN- and CH1 = IN+
#define CH2             0x80       // Channel 2 for single and for differential is CH2 = IN+ and CH3 = IN-
#define CH3             0xC0       // Channel 3 for single and for differential is CH2 = IN- and CH3 = IN+
#define SINGLE          0x06       // Single command
#define DIFFERENTIAL    0x04       // Differential command 

//=============================================================================
// Functions Declaration
//=============================================================================

/** Interface to the 4-Channel 12-Bit A/D Converters with SPI interface
 *
  *  Using the driver:
 *   - remenber to setup SPI in main routine or use pins instance.
 *
 *  Defaults in this driver on start up:
 *   - Datasheet start up
 */
class MCP3204 {
public:
    /** Create an instance of the MCP3204 connected via specfied SPI instance.
     *
     * @param spi The mbed SPI instance (make in main routine)
     * @param nCs The SPI chip select pin.
     */
    MCP3204(SPI& spi, PinName nCs);    

    /** Read from single channel.
     *
     * use defines to simplify use of function ( CH0, CH1, CH2, CH3)
     * @param channel The channel to receive the 12 bits value from.
     */
    int sgl(char channel);
    
    /** Read from differential channel.
     *
     * use defines to simplify use of function ( CH0, CH1, CH2, CH3)
     * @param channel The channel to receive the 12 bits value from.
     */
    int diff(char channel);
      

private:
    SPI& _spi;
    DigitalOut _nCs;
   
    int _make_value_from_responce(int _msb, int _lsb);    
    int _read(char sgl_or_diff, char channel);             

};

#endif