/* SpwfInterface NetworkSocketAPI Example Program
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"

#define PORT 1234
#define MAX_PENDING 1
 
#define IP "184.106.153.149" 
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "HJM51JXEXCLTX2KQ";
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

/*************************************/

SpwfSAInterface spwf(D8, D2, false);
int temp=5;
int humid=1;

int http_demo(void)
{
    TCPSocket socket(&spwf);
    char buffer[256];
    char message[40];
    int err;
    printf("Sending HTTP Data to thingspeak...\r\n");

    // Open a socket on the network interface, and create a TCP connection to thingspeak
    //socket.open(&spwf);
    err=socket.connect(IP,80); // connecting to thingspeak
    if(err!=0) {
        pc.printf("\r\nCould not connect to Socket, err = %d!!\r\n", err); 
        return -1;
        } 
    else 
        pc.printf("\r\nconnected to host server\r\n"); 
    
    // Send a simple http request
    sprintf(message,"field1=%d&field2=%d",temp,humid);
    printf("Message Length=%d\r\n",(int)strlen(message));
    sprintf(buffer,"POST /update HTTP/1.1\r\nHost: api.thingspeak.com\r\nConnection: close\r\nX-THINGSPEAKAPIKEY: %s\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: %d\r\n\r\n%s",thingSpeakKey,(int)strlen(message),message);
    pc.printf("Request to %s\r\n", buffer);
    //char sbuffer[] = "GET / HTTP/1.1\r\nHost: www.arm.com\r\n\r\n";
    int scount = socket.send(buffer, (int)strlen(buffer));
    printf("sent %d [%.*s]\r\n", scount, strstr(buffer, "\r\n")-buffer, buffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    return 0;
}

int main() 
{
    int err;    
    char * ssid = "iPhone";
    char * seckey = "abcd1234";  
    pc.printf("\r\nNucleo F411RE + WiFi + Thingspeak\r\n");     
    pc.printf("\r\nconnecting to AP\r\n");
            
    if(spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2)) {      
        pc.printf("\r\nnow connected\r\n");
    } else {
        pc.printf("\r\nerror connecting to AP.\r\n");
        return -1;
    }   

    const char *ip = spwf.get_ip_address();
    const char *mac = spwf.get_mac_address();
    
    pc.printf("\r\nIP Address is: %s\r\n", (ip) ? ip : "No IP");
    pc.printf("\r\nMAC Address is: %s\r\n", (mac) ? mac : "No MAC");     
    
    while(1) 
    { 
        wait(20);
        myled = !myled;
   
        int err=http_demo();
        if(err==0)
            pc.printf("Thingspeak update completed successfully\r\n");
        else
            pc.printf("Error occurred %d\r\n",err); 
    }
}

