#include <iostream>
#include "mbed.h"

// Sensors drivers present in the BSP library
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "stm32l475e_iot01_psensor.h"
#include "stm32l475e_iot01_magneto.h"
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"
#include "MB85RSxx_SPI.h"

//DigitalOut led1(LED1); //toggles as part of the main sensor loop
DigitalOut led2(LED2); //toggles during FRAM test

//reference definition: MB85RSxx_SPI(PinName mosi, PinName miso, PinName sclk, PinName nss);
//warning: code requires a single valid hFram definition - no error checking in place.
#define ESHD_FRAM_SPI1

#ifdef ESHD_FRAM_SPI1 //SPI1 pin definition: Arduino connector CN1, MB1297, RevD
MB85RSxx_SPI hFram(PA_7, PA_6, PA_5, PA_2);
#endif

#ifdef ESHD_FRAM_SPI2 //SPI2 pin definition: PMOD connector CN10, MB1297, RevD
MB85RSxx_SPI hFram(PD_4, PD_3, PD_1, PD_5);
#endif

#ifdef ESHD_FRAM_SPI3 //SPI3 pin definition: No external interface on MB1297, RevD
MB85RSxx_SPI hFram(PC_12, PC_11, PC_10, PC_9);
#endif

#define ESHD_FRAM_NUM_BYTES (8 * 1024) //8KBytes

#define ESHD_FRAM_TEST_DATA ((testAddr * 0x51)&0xff)

#define ESHD_RUN_SENSOR_LOOP
//#define SINGLE_STEP_SPI_WRITE
//#define SINGLE_STEP_SPI_READ
#define ESHD_FRAM_TEST_ERROR_INSERT 0 //set one bit in the ESHD_FRAM_TEST_ERROR_INSERT byte to intentionally induce write errors

int ESHD_testFram(int addrOffset, int addrRange, int testMode)
{
    int testData=0;
    int testAddr=0;
    int rtnVal = 0;
    
    printf("\nFRAM test Utility\n");
    printf("~~~~~~~~~~~~~~~~~\n\n");
    hFram.Init();
    printf("\nFRAM Fill Memory\n");

    for(testAddr=0; testAddr<addrRange; testAddr++)
    {
        testData = ESHD_FRAM_TEST_DATA | ESHD_FRAM_TEST_ERROR_INSERT;
        //fill byte by byte
        hFram.write(testAddr, (char)testData);
#ifdef SINGLE_STEP_SPI_WRITE
    int step;
    cin >> step;
#endif    
    }
    printf("\nFRAM Read-Check\n");

    for(testAddr=0; testAddr<addrRange; testAddr++)
    {
        testData = hFram.read(testAddr);
        if(testData != ESHD_FRAM_TEST_DATA)
        {
            printf("\nFRAM test failure - memory = 0x%04x, expected value = 0x%02x, data read = 0x%02x\n\n",
               testAddr, ESHD_FRAM_TEST_DATA, testData);
            rtnVal = -1;                    
        }
#ifdef SINGLE_STEP_SPI_WRITE
    int step;
    cin >> step;
#endif    
    }
    printf("\nFRAM Test Complete\n");

    return (rtnVal);
}


int main()
{
    printf("\n\nESHD Main Menu\n");
    printf("~~~~~~~~~~~~~~\n\n");

#ifdef ESHD_RUN_SENSOR_LOOP
    float sensor_value = 0;
    int16_t pDataXYZ[3] = {0};
    float pGyroDataXYZ[3] = {0};

    BSP_TSENSOR_Init();
    BSP_HSENSOR_Init();
    BSP_PSENSOR_Init();

    BSP_MAGNETO_Init();
    BSP_GYRO_Init();
    BSP_ACCELERO_Init();

    while(1) {
        printf("\n\nESHD Sensor Loop\n");
        printf("~~~~~~~~~~~~~~~~\n\n");

        led2 = 1;

        sensor_value = BSP_TSENSOR_ReadTemp();
        printf("TEMPERATURE = %.2f degC\n", sensor_value);

        sensor_value = BSP_HSENSOR_ReadHumidity();
        printf("HUMIDITY    = %.2f %%\n", sensor_value);

        sensor_value = BSP_PSENSOR_ReadPressure();
        printf("PRESSURE is = %.2f mBar\n", sensor_value);

        led2 = 0;

        wait(1);

        led2 = 1;

        BSP_MAGNETO_GetXYZ(pDataXYZ);
        printf("\nMAGNETO_X = %d\n", pDataXYZ[0]);
        printf("MAGNETO_Y = %d\n", pDataXYZ[1]);
        printf("MAGNETO_Z = %d\n", pDataXYZ[2]);

        BSP_GYRO_GetXYZ(pGyroDataXYZ);
        printf("\nGYRO_X = %.2f\n", pGyroDataXYZ[0]);
        printf("GYRO_Y = %.2f\n", pGyroDataXYZ[1]);
        printf("GYRO_Z = %.2f\n", pGyroDataXYZ[2]);

        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        printf("\nACCELERO_X = %d\n", pDataXYZ[0]);
        printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
        printf("ACCELERO_Z = %d\n", pDataXYZ[2]);

        led2 = 0;
#else
    //Always run testFram()
    while(1) {
#endif  //ESHD_RUN_SENSOR_LOOP

        ESHD_testFram(0, ESHD_FRAM_NUM_BYTES, 1);

        wait(1);
    }
    
}
