#include "mbed.h"
#include "BLEDevice.h"
#include "IR.h"
#include "nRF51822n.h"

BLEDevice ble;

DigitalOut myled(LED1);
DigitalOut yourled(LED2);

#define DEBUG 1
#ifdef DEBUG
    Serial py(USBTX, USBRX);
    #define LOG(args...)    py.printf(args)
#else
    #define LOG(args...)
#endif

const static uint8_t beaconPayload[] = {
    0x00, 0x4C, // Company identifier code (0x004C == Apple)
    0x02,       // ID
    0x15,       // length of the remaining payload
    0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4, // UUID
    0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x61,
    0x13, 0x37, // the major value to differenciate a location
    0xBA, 0xCE, // the minor value to differenciate a location
    0xC8        // 2's complement of the Tx power (-56dB)
};

extern GattService ir_service;
extern GattCharacteristic header, one, zero, ptrail, predata, code;

void onDataWritten(uint16_t handle)
{
    LOG("Data written! %i\n", handle);
    for (int i = 0; i < ir_service.getCharacteristicCount(); i++) {
        GattCharacteristic* characteristic = ir_service.getCharacteristic(i);
        characteristic->getMaxLength();
        if (characteristic->getHandle() == handle) {
            uint16_t max_length = characteristic->getMaxLength();
            ble.readCharacteristicValue(handle, characteristic->getValuePtr(), &max_length);
            break;
        }
    }
    
    if (code.getHandle() == handle) {
        fireIRCode(header.getValuePtr(), one.getValuePtr(), zero.getValuePtr(), ptrail.getValuePtr(), predata.getValuePtr(), code.getValuePtr());
    }
}

void disconnectionCallback(void)
{
    LOG("Disconnected!\n");
    LOG("Restarting the advertising process\n");
    ble.startAdvertising();
}

void connectionCallback(void)
{
    LOG("Connected!\n");
}

void onDataSent(uint16_t data)
{
    LOG("onDataSent!\n");
}

int main() {
    ble.init();
    ble.onConnection(connectionCallback);
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);
    ble.onDataSent(onDataSent);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    
    uint8_t uuid_array_service[16]   = {'b', 'f', 't', 'j', ' ', 'i', 'r', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    ble.accumulateAdvertisingPayload(GapAdvertisingData::INCOMPLETE_LIST_128BIT_SERVICE_IDS,
                                        uuid_array_service, sizeof(uuid_array_service));
    
    ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,
                    beaconPayload, sizeof(beaconPayload));
    
    ble.startAdvertising();
    
    ble.addService(ir_service);
    
    myled = 1;
    
    LOG("Starting up.\n");
    
    

    while (true) {
        ble.waitForEvent();
        myled = !myled;
    }
}