#include "mbed.h"
#include "IR.h"
#include "TxIR.hpp"

#define WORD(x, i) ((x)[(i)] << 8 | (x)[(i) + 1])

TxIR txir(p14);
Serial px(USBTX, USBRX);

void fireIRCode(uint8_t* header, uint8_t* one, uint8_t* zero, uint8_t* ptrail, uint8_t* predata, uint8_t* code)
{
    px.printf("Going to fire.\n");
    int raw_codes_length = 67;
    unsigned raw_codes[raw_codes_length];
    raw_codes[0] = WORD(header, 0);
    raw_codes[1] = WORD(header, 2);
    int offset = 2;
    for(int i = 0; i < 16 * 2; i += 2) {
        int bit = predata[i / 16] & 0x80;
        uint8_t* signal = bit ? one : zero;
        raw_codes[i + offset] = WORD(signal, 0);
        raw_codes[i + offset + 1] = WORD(signal, 2);
        predata[i / 16] <<= 1;
    }
    offset = 34;
    for(int i = 0; i <  16 * 2; i += 2) {
        int bit = code[i / 16] & 0x80;
        uint8_t* signal = bit ? one : zero;
        raw_codes[i + offset] = WORD(signal, 0);
        raw_codes[i + offset + 1] = WORD(signal, 2);
        code[i / 16] <<= 1;
    }
    raw_codes[66] = WORD(ptrail, 0);
    
    px.printf("Full sequence received: [%i", raw_codes[0]);
    for (int i=1; i<67; i++) {
        px.printf(", %i", raw_codes[i]);
    }
    px.printf("]\n");
    
    txir.txSeq(26, 67, raw_codes);

    px.printf("Wrote message :)\n");
}