/**
 * Copyright 2014 Nordic Semiconductor
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

#include "Puck.h"

Puck* puck = &Puck::getPuck();

const UUID CUBE_SERVICE_UUID = stringToUUID("bftj cube       ");
const UUID DIRECTION_UUID = stringToUUID("bftj cube dirctn");


InterruptIn myButton(P0_16);
InterruptIn button2(P0_17);

uint8_t buttonHasBeenPressed = 0;

void callback() {
    buttonHasBeenPressed = 1;
}
void callback2() {
    buttonHasBeenPressed = 2;
}

int main() {
    
    myButton.rise(&callback);
    myButton.enable_irq();

    button2.rise(&callback2);
    button2.enable_irq();

    int characteristicValueLength = 1;
    puck->addCharacteristic(
        CUBE_SERVICE_UUID,
        DIRECTION_UUID,
        characteristicValueLength,
        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
    
    puck->init(0xC1BE);

    while(puck->drive()) {
        if (buttonHasBeenPressed) {
            /* do stuff */
            int length = 1;
            puck->updateCharacteristicValue(DIRECTION_UUID, &buttonHasBeenPressed, length);
            
            // Reset
            buttonHasBeenPressed = 0;
        }
    }
}