#include "mbed.h"
#include "HTTPClient.h"
#include "LM75B.h"
#include "MMA7660.h"
#include "EthernetInterface.h"


LM75B sensor(D14,D15);
MMA7660 accel(PTE25 , PTE24);
char buffer[256];
char resp[1024];
char val[4][16];   
int ret = 0;

Serial pc(USBTX,USBRX);
//Ethernet Interface
EthernetInterface eth;
//HTTP Client for interfacing to web services
HTTPClient http;
#define IP "184.106.153.149" // thingspeak.com IP Address

//http client init
HTTPMap map;
HTTPText inText(resp, 1024);
//String thingtweetAPIKey = "TTEVLP931ODJ5GMT";


int main () {   
//ethernet init
    eth.init(); //Use DHCP
    ret= eth.connect();

    if (!ret){
            pc.printf("\r\nConnected, IP: %s, MASK: %s, GW: %s",
            eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
    } else {
        pc.printf("\r\nError eth.connect() - ret = %d", ret);
    }
    
    while(1){
        pc.printf("\r\nWriting to thingspeak");
        map.put("api_key","xxx");  /* Fill your thingspeak API KEY*/
        sprintf(val[0],"%4.1f",sensor.read());
        map.put("field1", val[0]);
        pc.printf("\r\nPosting Data...");
        ret = http.post("https://api.thingspeak.com/update", map, &inText);     //writing data to Thingspeak
        if (!ret){
            pc.printf("\r\nPOST successfully - read %d characters", strlen(resp));
            pc.printf("\r\nResult: %s\n", resp);
        }else{
            pc.printf("\r\nError Connecting to ethernet port - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
        }
    }
}
