#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"

DigitalOut red (LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);
AnalogIn pot1 (A0);
AnalogIn pot2 (A1);
C12832 lcd(D11, D13, D12, D7, D10);
LM75B sensor(D14,D15);
PwmOut spkr(D6);
void start(void);
void menu(void);
int ctrl=3;
int main ()
{
    red = 1;
    green = 1;
    blue = 1;
    lcd.cls();
    start();
    menu();
    while(1) {
        if (left == 1) {
            ctrl = 1;
        }
        if (right == 1) {
            ctrl = 2;
        }
        if (up == 1) {
            ctrl = 1;
        }
        if (down == 1) {
            ctrl = 2;
        }
        if (fire == 1){
            ctrl = 0;
            }
        switch (ctrl){
        case 0:
            menu();
            break;
        case 1:
            while(1) {
                lcd.cls();
                lcd.locate(0,3);
                lcd.printf("Temp = %.1f\n", sensor.temp());
                float i = 0.0;
                i = sensor.temp();
                if (i>28.0) {
                    blue =1;
                    green = 1;
                    red = 0;
                lcd.locate(0,15);
                lcd.printf("So Hot!");
                } else if (i<18.0) {
                    red = 1;
                    green = 1;
                    blue = 0;
                lcd.locate(0,15);
                lcd.printf("Really Cold.....");
                } else {
                    red = 1;
                    blue = 1;
                    green = 0;
                lcd.locate(0,15);
                lcd.printf("Comfortable!!!");
                }
                wait(1.0);
                if(fire == 1) {
                    lcd.cls();
                    ctrl = 0;
                    red = 1;
                    green = 1;
                    blue = 1;
                    break;
                }
            }
            break;
        case 2:
            while(1) {
                lcd.cls();
                lcd.locate(0,3);
                lcd.printf("Pot 1 = %.2f", (float)pot1);
                lcd.locate(0,14);
                lcd.printf("Pot 2 = %.2f", (float)pot2);
                wait(0.1);
                spkr.period((float)pot1/(float)pot2);
                spkr=0.8;
                wait(0.02);
                if(fire == 1) {
                    ctrl = 0;
                    spkr = 0;
                    lcd.cls();
                    break;
                }
            }
            break;
        }
    }
}
void menu(void)
{
    lcd.locate(0,3);
    lcd.printf("welcome to mbed world!");
}

void start(void)
{
    int j=5;
    while(1) {
        lcd.locate(0,3);
        lcd.printf("reboot system please wait");
        lcd.locate(0,15);
        lcd.printf("time : %d",j);
        j--;
        wait(1.0);
        if(j==0) {
            break;
        }
    }
    lcd.cls();
}

