#include "munincli.h"
#include "dispBoB.h"

namespace
{
const char* MUNIN_SERVER_ADDRESS = "172.28.22.45";
const int MUNIN_SERVER_PORT = 4949;
}

namespace {
// Munin command(s):
char CMD_FETCH_USERS[] = "fetch users\n";
}


int main()
{
    MuninClient munin_lcd;
    munin_lcd.dhcp_connection();    // DHCP connection
    dispBoB bob_display(p28, p27, p26);

    while(true) {
        while (munin_lcd.socket_connection(MUNIN_SERVER_ADDRESS, MUNIN_SERVER_PORT) < 0) {
            wait(1);
        }

        munin_lcd.socket_recv();
        munin_lcd.socket_send(CMD_FETCH_USERS, sizeof(CMD_FETCH_USERS));
        munin_lcd.socket_recv_all();
        {
            const char *param = "usercount.value";
            const int counter_value = munin_lcd.get_param_value(param);
            bob_display.cls();
            bob_display.printf("% 6d\n", counter_value);
        }

        munin_lcd.socket_close();
        wait(3);
    }
}
