// RFID Tweeter
/*
  Update: 21-06-2010
  The basic authentication service for twitter is going down.
  To continue using that program, the code has been updated to use http://supertweet.net which acts as an API proxy.
  Simply visit the website to setup your twitter account for this API.
  See: http://www.supertweet.net/about/documentation
*/

#include "mbed.h"
#include "ID12RFID.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

#define TWITTER_USER "myusername"
#define TWITTER_PASSWORD "myverysecurepassword"

#define IDS_COUNT 3
const int ids_list[IDS_COUNT] = {89481809, 89481810, 89481811};
const char* names_list[IDS_COUNT] = {"Donatien", "Simon", "Dan"};

EthernetInterface ethernet;
HTTPClient twitter;

ID12RFID rfid(p14);
DigitalOut tag_present(LED1);
DigitalOut tweet_ok(LED4);

int main() {
  ethernet.init();
  ethernet.connect();
  twitter.basicAuth(TWITTER_USER, TWITTER_PASSWORD);

  while(true) {
    int id = rfid.read();
    tag_present = 1;
    for(int i = 0; i < IDS_COUNT; i++) {
      if (ids_list[i] == id) {
        HTTPMap msg;
        msg.put("status", names_list[i]);
        //msg["status"] += " just arrived home!";
        HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL);
        tweet_ok = !r;
      }
    }
    tag_present = 0;
  }
}
