/**
@file Game.h
@brief Header file of the game rule which contain member functions, variables and functions definition
@brief Revision 1.0
@author Huynh Minh Tuan Le
@date April 2015
*/

#ifndef GAME_H
#define GAME_H

#include "mbed.h"
#include "MMA8452.h"
#include "N5110.h"
#include "Clock.h"


Ticker gatimer; ///< Set a ticker for the game timing
int gatimerFlag = 0; ///< Declare game ISR flag as a integer type variable

void gatimerExpired()
{
    gatimerFlag = 1; ///Set flag for timer of the game
}

///Game Class
class Game
{
private:
    /**
    * The acceleration variable recalled from MMA8452.h
    */
    Acceleration accel; ///Acceleration variable declared in MMA8452 class

public:
    /**
    * A function that contains condition of easy mode.
    * The conditions: Threshold value of 2g - Time interval for reading data of 0.1s.
    */
    void easyMode();
    /**
    * A function that contains condition of normal mode.
    * The conditions: Threshold value of 3g - Time interval for reading data of 0.2s.
    */
    void norMode();
    /**
    * A functionthat contains condition of hard mode.
    * The conditions: Threshold value of 3g - Time interval for reading data of 0.4s.
    */
    void hardMode();
    /**
    * A global variable to store play score.
    * This score will later transfer into an array.
    */
    int score;
    /**
    * An array to store set of scores.
    * The array structure is as follow:
    * Easy high score, Easy current score, Normal high score, Normal current score, Hard high score, Hard current score.
    */
    int scoArr[6];
    /**
    * A function used to reset the game condition.
    */
    void reset();
    /**
    * A funtion to draw a battery image when playing game.
    */
    void battImag();
};

void Game::easyMode ()
{
    lcd.printString("EASY MODE",16,0); //Displaying the title of difficulty level
    lcd.drawRect(30,32,28,12,0); //Drawing an empty battery image
    lcd.drawRect(59,36,1,4,1); //Drawing a tip of battery image
    if (gatimerFlag) {
        gatimerFlag = 0;
        accel = mma8452.readValues(); //Read the value from MMA8452 sensor
        
        if (accel.y > 2 || accel.y < -2) { //Easy mode: If the value of accelerator data exceed 2g, the score will increase by one unit
            score++;
            char scorebuffer[14];
            sprintf(scorebuffer,"Score:%d",score); //Score will be displayed as unsigned Decimal Interger number
            lcd.printString(scorebuffer,6,3);
            battImag();
        }
    }
    //Condition for storing "score" and transferring "score" between scoArr elements. 
    scoArr[1] = score; //Store "score" variable into 2nd element of scoArr array
    if(scoArr[0] > scoArr[1]) { //If 1st element is greater than 2nd element, store in 2nd element
        scoArr[1] = score;
    } else if(scoArr[0] < scoArr[1]) { //Vice versa, store in 1st element
        scoArr[0] = score;
    }
}

void Game::norMode()
{
    lcd.printString("NORMAL MODE",9,0); //Displaying the title of difficulty level
    lcd.drawRect(30,32,28,12,0); //Drawing an empty battery image
    lcd.drawRect(59,36,1,4,1); //Drawing a tip of battery image
    if (gatimerFlag) {
        gatimerFlag = 0;
        accel = mma8452.readValues(); //Read the value from MMA8452 sensor

        if (accel.y > 3 || accel.y < -3) { //Normal mode: If the value of accelerator data exceed 3g, the score will increase by one unit
            score++;
            char scorebuffer[14];
            sprintf(scorebuffer,"Score:%d",score); //Score will be displayed as unsigned Decimal Interger number
            lcd.printString(scorebuffer,6,3);
            battImag();
        }
    }
    //Condition for storing "score" and transferring "score" between scoArr elements.
    scoArr[3] = score; //Store "score" variable into 4th element of scoArr array
    if(scoArr[2] > scoArr[3]) { //If 3rd element is greater than 4th element, store in 4th element
        scoArr[3] = score;
    } else if(scoArr[2] < scoArr[3]) { //Vice versa, store in 3rd element
        scoArr[2] = score;
    }
}

void Game::hardMode()
{
    lcd.printString("HARD MODE",16,0); //Displaying the title of difficulty level
    lcd.drawRect(30,32,28,12,0); //Drawing an empty battery image
    lcd.drawRect(59,36,1,4,1); //Drawing a tip of battery image
    if (gatimerFlag) {
        gatimerFlag = 0;
        accel = mma8452.readValues(); //Read the value from MMA8452 sensor
        
        if (accel.y > 3.5 || accel.y < -3.5) { //Hard mode: If the value of accelerator data exceed 3.5g, the score will increase by one unit
            score++;
            char scorebuffer[14];
            sprintf(scorebuffer,"Score:%d",score); //Score will be displayed as unsigned Decimal Interger number
            lcd.printString(scorebuffer,6,3);
            battImag();
        }
    }
    //Condition for storing "score" and transferring "score" between scoArr elements.
    scoArr[5] = score; //Store "score" variable into 6th element of scoArr array
    if(scoArr[4] > scoArr[5]) { //If 5th element is greater than 6th element, store in 6th element
        scoArr[5] = score;
    } else if(scoArr[4] < scoArr[5]) { //Vice versa, store in 5th element
        scoArr[4] = score;
    }
}

void Game::reset()
{
    score = 0;
    CClock = 60;
}

void Game::battImag()
{
    if (score>20 && score<40) {
        lcd.drawRect(32,34,3,8,1);
    }
    if (score>40 && score<60) {
        lcd.drawRect(32,34,6,8,1);
    }
    if (score>60 && score<80) {
        lcd.drawRect(32,34,9,8,1);
    }
    if (score>80 && score<100) {
        lcd.drawRect(32,34,12,8,1);
    }
    if (score>100 && score<120) {
        lcd.drawRect(32,34,15,8,1);
    }
    if (score>120 && score<140) {
        lcd.drawRect(32,34,18,8,1);
    }
    if (score>140 && score<160) {
        lcd.drawRect(32,34,21,8,1);
    }
    if (score>160) {
        lcd.drawRect(32,34,24,8,1);
    }
}


#endif