/**
@file Clock.h
@brief Header file of a count down clock containing Ticker on RTC and display time on N5110 Nokia Screen
@brief Revision 1.0
@author Huynh Minh Tuan Le
@date April 2015
*/

#ifndef CLOCK_H
#define CLOCK_H

#include "mbed.h"
#include "N5110.h"
#include "MMA8452.h"
#include "beep.h"

Ticker timer; ///<Ticker object for the count down clock. Called as a timer
int CClock; ///<A variable for storing clock value in seconds.
/**
@namespace Flashing led.
@brief A led to give a notification when the game is in last 10s.
*/
DigitalOut led(p22); ///<A variable of the flashing led. 
/**
@namespace Knightrunner leds. 
*/
BusOut leds(LED1, LED2, LED3, LED4); ///<A variable for outputing a set of four on-board leds. 
/**
@namespace Beep sound.
*/
Beep beep(p26); ///<An output analgoue signal of a piezzo buzzer.

int timerFlag = 0; ///<A flag for timer ticker object.

void timerExpired() ///Function of setting flag for timer.
{
    timerFlag = 1; //Set flag for timer of the countdown
}

///Clock Class
class Clock
{
public:
    /**
    * The function that makes a LED flash.
    */
    void flashLed();
    /**
    * The function that display LEDs on the embed.
    */
    void knightrunner();
    /**
    * The count down function occur during the game.
    * The clock start from 60s to 0s.
    * In the last 10s of the clock, the function will flash an LED and generate alerting sound.
    */
    void countDown();
    /**
    * The function that display "Time Out" message on the Nokia screen
    * and run funtion knightrunner.
    */
    void timeout();
};

void Clock::knightrunner()
{
    int t = 5;
    while(t > 0) {

        for(int i=1; i<=8; i=i*2) {
            leds = i;
            wait (0.05);
        }
        for(int j=4; j>=2; j=j/2) {
            leds = j;
            wait(0.05);
        }
        t = t - 2;
    }
}

void Clock::flashLed()
{
    led =!led;
}

void Clock::countDown()
{
    if (timerFlag) {
        timerFlag = 0;
        if (CClock > 10) {
            CClock = CClock - 1;
            char Clockbuffer[14];
            sprintf(Clockbuffer," %d", CClock);
            lcd.printString(Clockbuffer,33,2);
        } else if (CClock > 0) {
            CClock = CClock - 1;
            char Clockbuffer[14];
            sprintf(Clockbuffer," %d", CClock);
            lcd.printString(Clockbuffer,39,2);
            beep.beep(1000,0.2);
            wait(0.1);
            beep.beep(10000,0.2);
            wait(0.1);
            beep.beep(600,0.2);
            flashLed();
        }
    }
}

void Clock::timeout()
{
    lcd.clear();
    lcd.printString("Time Out",16,3);
    knightrunner();
    CClock = CClock - 1;
    leds = 0;
}

#endif