/**
@file Menu.h
@brief This header file contains the project menu and using FSM
@brief Revision 1.0
@author Huynh Minh Tuan Le
@date April 2015
*/

#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"

///Menu class
class Menu
{
public:
    /**
    * Welcome function
    * @brief It shows a welcome message on screen.
    */
    void welcome(); 
    /**
    * The first sub menu of Main menu.
    * @brief It has same factor of the Main menu which are Main menu title, Play and Score.
    * @brief It shows a cursor of circle pointing at "Play" factor.
    */
    void main();
    /**
    * The Highscore sector contains the highest score of player and the current score they have.
    */
    void highscore();
    /**
    * The Startgame sector contains options of game difficulty.
    * @brief It allows player to choose which difficulty level to play.
    */
    void gameset();
    /**
    * The Yourscore sector is a place showing your current score.
    */
    void yourscore();
};

void Menu::welcome()
{
    lcd.drawRect(0,0,84,3,1);
    wait(0.5);
    lcd.drawRect(80,0,3,47,1);
    wait(0.5);
    lcd.drawRect(0,44,84,3,1);
    wait(0.5);
    lcd.drawRect(0,0,3,47,1);
    wait(0.5);
    lcd.printString("Accel-cize",13,2);
    wait(1.5);
    lcd.printString("Activate",18,3);
    wait(0.5);
    int i = 0;
    while(i<5) {
        lcd.inverseMode();
        wait(0.2);
        lcd.normalMode();
        wait(0.2);
        i++;
    }
    lcd.clear();
}

void Menu::main()
{
    lcd.printString("MAIN MENU",16,1);
    lcd.printString("Play",31,3);
    lcd.printString("Score",28,4);
}

void Menu::highscore()
{
    lcd.printString("HIGH SCORE",13,1);
    lcd.printString("Easy",31,2);
    lcd.printString("Normal",25,3);
    lcd.printString("Hard",31,4);
}

void Menu::yourscore()
{
    lcd.printString("YOUR SCORE",13,1);
    lcd.printString("Main menu",16,3);
    lcd.printString("Reset",16,4);
}

void Menu::gameset()
{
    lcd.printString("GAME MODE",15,1);
    lcd.printString("Easy",31,2);
    lcd.printString("Normal",25,3);
    lcd.printString("Hard",31,4);
}

#endif