/**
@file Accel-cize.cpp
@brief This is a main file where the code runs.
@brief Revision 1.0
@author Huynh Minh Tuan Le
@date April 2015
*/

#include "MMA8452Test.h"
#include "GameFSM.h"
#include "PowerControl/PowerControl.h"

AnalogIn adjust(p20); ///<A analogue-in variable for potentiometer.
Timer t; ///<A timer object t for timing the moment to put mbed into sleep mode.
FSM program; ///<A "program" variable declared with FSM class.
Menu wel; ///<A "wel" variable declared with Menu class.
Test init; ///<A "init" variable declared with Test class from MMA8452Test.h header file.

int main()
{
    init.initial(); //A Function to initialise the Nokia 5110 screen and reading data from MMA8452.
    
    ButtonU.rise(&BuUPress); 
    ButtonD.rise(&BuDPress);
    ButtonA.rise(&BuAPress);
    ButtonB.rise(&BuBPress);

    wel.welcome(); //Run the welcome function from Menu class.

    while(1) {
        lcd.setBrightness(adjust); //Attach the screen LED brightness value to potentiometer. 

        program.proact(); //Running proact function from FSM class.

        //////// Timer for the mbed go to sleep mode when waiting for 2 mins ////////

        if ((BuAFlag==0) && (BuBFlag==0) && (BuDFlag==0) && (BuUFlag==0)) { //If all buttons are not pressed, start the timer t.
            t.start();
        }
        if ((BuAFlag)||(BuBFlag)||(BuUFlag)||(BuDFlag)) { //If one of the buttons is pressed, reset timer t.
            t.reset();
        }
        if (t.read()>10) { //If timer t greater than 10s,
            lcd.setBrightness(0); //Set LCD brightness to zero.
            t.stop(); //Stop timer t.
            Sleep(); //Put mbed into sleep mode.
        }
    }
}
