#ifndef MMA8452TEST_H
#define MMA8452TEST_H

#include "mbed.h"
#include "MMA8452.h"
#include "N5110.h"
N5110 lcd(p7,p8,p9,p10,p11,p13,p21); //pwm for led backlight
MMA8452 mma8452(p28,p27);  // SDA, SCL
Serial serial(USBTX,USBRX);
DigitalOut Xalert(LED1);
DigitalOut Yalert(LED2);
DigitalOut Zalert(LED3);

class Test
{
private:

    Acceleration acceleration;  // Accleration structure declared in MMA8452 class


public:

    void initial();
    void test();

};

void Test::initial ()
{
    mma8452.init();  // 100 Hz update rate, ±4g scale
    lcd.init();
}

void Test::test ()
{
    while(1) {
        acceleration = mma8452.readValues();   // read current values and print over serial port
        if (acceleration.x < 0) {
            Xalert = !Xalert;
        } else {
            Xalert = 0;
        }
        if (acceleration.y <0) {
            Yalert = !Yalert;
        } else {
            Yalert = 0;
        }
        if (acceleration.z < 0) {
            Zalert = !Zalert;
        } else {
            Zalert = 0;
        }

        char xbuffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        char ybuffer[14];
        char zbuffer[14];
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long

        int xlength = sprintf(xbuffer,"x = %.2f",acceleration.x); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (xlength <= 14)  // if string will fit on display
            lcd.printString(xbuffer,0,1);           // display on screen

        int ylength = sprintf(ybuffer,"y = %.2f",acceleration.y);

        if (ylength <= 14)
            lcd.printString(ybuffer,0,2);

        int zlength = sprintf(zbuffer,"z = %.2f",acceleration.z);

        if (zlength <= 14)
            lcd.printString(zbuffer,0,3);
        //lcd.printf("x = %.2f g y = %.2f g z = %.2f g\n",acceleration.x,acceleration.y,acceleration.z);


        wait(0.5);   // short delay until next reading
    }
}
#endif