#include "mbed.h"
#include "SRF05.h"
#include "QEI.h"
#include "TextLCD.h"
#include <math.h>
#include "DebouncedIn.h"

SRF05 srf(PTD0, PTD5);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
QEI encoder (PTD7, PTD6, NC, 1);
DebouncedIn Pulsador(PTA17);
PwmOut myled(LED1);

// Definición de comandos para LCD

int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int C1=0x0F;
float val;

int main() {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Bienvenido");
    wait(1);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Distancia");
    
         // //Analog input from 0.0 to 3.3V
         // controller.setInputLimits(0.0, 3.3);
         // //Pwm output from 0.0 to 1.0
         // controller.setOutputLimits(0.0, 1.0);
         // //If there's a bias.
         // controller.setBias(0.3);
         // controller.setMode(AUTO_MODE);
         // //We want the process variable to be 1.7V
         // controller.setSetPoint(1.7);
  
     while(1) {
         lcd.locate(0,1);
         lcd.printf("%.2f\n", srf.read());
         myled=srf.read()*0.01;   
         wait_ms(100);
     } 
 }
 