#include "mbed.h"
#include "TextLCD.h"

Serial device(D14, D15);  // tx, rx
DigitalOut L1(LED1);
PwmOut pwm(PTA5);
AnalogIn Sens(A0);

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

char value;
float SP=0.05;
float SPd=0;
float Cai=0;
float Asen;
float p=0;
float SPdroid;

int main() {
    pwm.period_ms(20);
    L1=1;
    lcd.locate(0,0);
    lcd.printf("Bienvenido");
    lcd.locate(0,1);
    lcd.printf("Control del VTOL");
    wait(2);
    lcd.cls();
            lcd.locate(0,0);
            lcd.printf("D:");
            lcd.locate(5,0);
            lcd.printf("S:");
            lcd.locate(10,0);
            lcd.printf("BT:");
    while(1){
        if(device.readable()){
            value=device.getc();
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("D:");
            lcd.locate(5,0);
            lcd.printf("S:");
            lcd.locate(10,0);
            lcd.printf("BT:");
                if(value=='0'){
                    SP=0.054;
                }
                if(value=='3'){
                    SP=0.0745;
                }
                if(value=='1'){
                    if(SP<1.00) SP=SP+0.0001;
                }
                if(value=='2'){
                    if(SP>0.00) SP=SP-0.0001;
                }
                if(value=='4'){
                    Cai=1;
                }
                if(value=='X'){
                    SPdroid=device.getc()-48;
                    fflush(stdin);
                    SP=(SPdroid+1)/200+0.05;
                }
        }
        Asen=(7.21/8)*Sens.read();
        //pwm=1;
        //wait_ms(SP);
        //pwm=0;
        //wait_ms(20-SP);
            if(Cai==1){
                while(!Cai==0){
                    SP=SP-0.0001;
                    if(SP<0.054){
                        Cai=0;
                        }
                wait_ms(50);
                SPd=SP*100;
                lcd.locate(0,1);
                lcd.printf("%.2f ",SPd);
                pwm.write(SP);
                }
            }
            SPd=SP*100;
            lcd.locate(0,1);
            lcd.printf("%.2f %.2f %.2f",SPd,Asen,SPdroid);
            pwm.write(SP);
    }
}