#include "mbed.h"
#include "scolor_TCS3200.h"

/* *****************************************************************************
Programa que solicita telemetria al sistema embebido, por medio del comando  0xFe
para preguntar por el color  que detecta el sensor TCS3200

el sistema embebido recibe  el inicio de trama FE  y el número de comado: 01
   
|   INITELE  |  CMD       |   
|     0xfe   | 0x01       | 


para enviar los comandos usar el programa Coolterm http://freeware.the-meiers.org/


@fabeltranm 2019
fbeltranm@ecci.edu.co

********************************************************************************
   datasheet https://www.mouser.com/catalog/specsheets/TCS3200-E11.pdf


    S0      Frequency scaling 
    S1      Frequency scaling 
    S2      Photo diode selection 
    S3      Photo diode selection 
    OutFreq Frequency

       -----------------------------------
      |   ____________     ____________   |
----> |  |            |   |            |  |                ___     ___ 
Light |  | Photodiode |   |   Current  |--|---OUTPUT_FREQ |   |___|   |___
----> |  |   Array    |---|     to     |  |
      |  |            |   |  Frequency |  |
      |  |____________|   |____________|  |
      |       ^  ^             ^  ^       |
       -------|--|-------------|--|-------
              |  |             |  |
             S2 S3            S0  S1
             
SO | S1 | OUTPUT FREQUENCY SCALING |        | S2 | S3 |   PHOTODIODE TYPE   |
 0 | 0  |        power down        |        |  0 | 0  |         Red         |
 0 | 1  |           2%             |        |  0 | 1  |         Blue        |
 1 | 0  |           20%            |        |  1 | 0  |  Clear (no filter)  |
 1 | 1  |           100%           |        |  1 | 1  |         Green       | 
             
******************************************************************************/
#define INITCMD 0xFF // comando de sonido ff 01 3
#define INITELE 0xFE // comando de sensor de colores fe 01
#define CMD  0x01 // 

#define DO  104 
#define RE  153
#define MI  166
#define FA  184
#define SO  205



Serial command(USBTX, USBRX);
//                     S0,    S1,   S2,   S3,    OUT
scolor_TCS3200 scolor(PA_8, PB_10, PB_4, PB_5, PB_3);
PwmOut mybuzzer(PB_9);

// definición de las funciones

void setup_uart(); // funcion conexion pc
void leer_datos(); // funcion de lectura de comandos HEX
void leer_color();// recepcion de la lectura de frecuencia del sensor 

void buzzer_on(uint8_t tono, uint8_t tiempo);

uint8_t cmd;
uint8_t tono;    // variable almacena la frecuencia del buzzer
uint8_t tiempo;    // varable almacena los tiempos del buzzer leer_datos()

int main() {

    setup_uart();
    while(1){    
        leer_datos();
        if (cmd==CMD){}
            leer_color();
           buzzer_on(tono, tiempo);        
    }    
}



void setup_uart(){
    
    command.baud(115200);
    printf ("hola mundo sonido vicion");

    
}


void leer_datos(){
    
    while(command.getc()!= INITELE);
    cmd=command.getc();

   while(command.getc()!= INITCMD);
    tono=command.getc();
    tiempo=command.getc();
    
    
}


void leer_color(){
    
 
    
    long     red = scolor.ReadRed();
    long     green = scolor.ReadGreen();
    long     blue = scolor.ReadBlue();
    long     clear = scolor.ReadClear();
 
    //printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d    \n ", red, green, blue, clear);
    
    if (red < blue && green > blue && red < 35) 
  {  
   printf ("   Rojo");    
  }   
  else if (blue < red && blue < green && green < red)  
  {  
   printf ("   Azul");        
  }    
    else if (red > green && blue > green )  
  {  
   printf("   Verde");       
  }  
  else{
  printf("  ");  
  }   
  }  
    

void buzzer_on(uint8_t tono, uint8_t tiempo){
        
/* complementar el código necesario
 */

     mybuzzer.write(0);
     switch(tono){
        case 1: mybuzzer.period_us(DO);break;
        case 2: mybuzzer.period_us(RE);break;
        case 3: mybuzzer.period_us(MI);break;
        case 4: mybuzzer.period_us(FA);break;
        default:mybuzzer.period_us(SO); break;
        }
     mybuzzer.write(0.5);
     
     wait(tiempo);
     mybuzzer.write(0);
     
   
}

    
    