#include "mbed.h"

int rtCount;
Timeout timeTick;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

void flip_1() {
    led1 = !led1;
}

void flip_2() {
    led2 = !led2;
}

void action() {
    //  Set timer to call back
    timeTick.attach(&action, 0.1); // setup flipper to call flip after 2 seconds
    rtCount++;   // increment realtime counter
    if (rtCount == 5) {
        flip_1();
    } else if (rtCount == 10) {
        flip_1();
        flip_2();
        rtCount = 0;
    }
}

int main() {
    rtCount = 0;
    led1 = 1;
    led2 = 1;
    timeTick.attach(&action, 0.1); // setup flipper to call flip after 2 seconds

    // spin in a main loop. flipper will interrupt it to call flip
    while (1) {}
}
