#include "mbed.h"
#include "config.h"
#include "sx1276-mbed-hal.h"
#include "main.h"

// Override stdout to use our serial port
FileHandle* mbed::mbed_override_console(int fd) {
    static UARTSerial pc(PA_9, PA_10, 115200);
    return &pc;
}


static RadioEvents_t RadioEvents;

SX1276Generic *Radio;
DigitalOut blueLed = DigitalOut(LED);

// NOTE: By default the sample application is in recieve mode.
// Connect PIN PC_2 to 3.3v to transmit
DigitalIn txModeIndicator = DigitalIn(TX_IND, PullDown);

int timeoutCount, errCount, recvCount = 0;

int main() 
{
    
    blueLed = 1;

    Radio = new SX1276Generic(NULL, RFM95_SX1276,
            LORA_SPI_MOSI, LORA_SPI_MISO, LORA_SPI_SCLK, LORA_CS, LORA_RESET,
            LORA_DIO0, LORA_DIO1, LORA_DIO2, LORA_DIO3, LORA_DIO4, LORA_DIO5);
        
    printf("LoDev RX/TX Demo Application\n" );
    printf("Freqency: %.1f\n", (double)RF_FREQUENCY/1000000.0);
    printf("TXPower: %d dBm\n",  TX_OUTPUT_POWER);
    printf("Bandwidth: %d Hz\n", LORA_BANDWIDTH);
    printf("Spreading factor: SF%d\n", LORA_SPREADING_FACTOR);
    
    // Initialize Radio driver
    RadioEvents.TxDone = OnTxDone;
    RadioEvents.RxDone = OnRxDone;
    RadioEvents.RxError = OnRxError;
    RadioEvents.TxTimeout = OnTxTimeout;
    RadioEvents.RxTimeout = OnRxTimeout;    
    if (Radio->Init( &RadioEvents ) == false) {
        while(1) {
            printf("Radio could not be detected!\n");
            wait( 1 );
        }
    }

    Radio->DetectBoardType();
    Radio->SetChannel(RF_FREQUENCY ); 

    Radio->SetTxConfig( MODEM_LORA, TX_OUTPUT_POWER, 0, LORA_BANDWIDTH,
                         LORA_SPREADING_FACTOR, LORA_CODINGRATE,
                         LORA_PREAMBLE_LENGTH, LORA_FIX_LENGTH_PAYLOAD_ON,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                         LORA_IQ_INVERSION_ON, 2000 );
    
    Radio->SetRxConfig( MODEM_LORA, LORA_BANDWIDTH, LORA_SPREADING_FACTOR,
                         LORA_CODINGRATE, 0, LORA_PREAMBLE_LENGTH,
                         LORA_SYMBOL_TIMEOUT, LORA_FIX_LENGTH_PAYLOAD_ON, 0,
                         LORA_CRC_ENABLED, LORA_FHSS_ENABLED, LORA_NB_SYMB_HOP, 
                         LORA_IQ_INVERSION_ON, true );
                              
    printf("Starting loop\n"); 
        
    uint16_t frameCount = 0;
    char buffer[18]; 

    bool txMode = false;    
    if(txModeIndicator == 1) {
        // Transmit
        txMode = true;
    } else {
        Radio->Rx(0);
    }

    while( 1 )
    {
        blueLed = 1;
        if(txMode) {
            wait_ms(5000);
            sprintf(buffer, "%u Hello World", frameCount);
            printf("Sending packet: %s\n", buffer);
            Radio->Send( buffer, strlen(buffer) );
            frameCount++;
        } else {
            wait_ms(100);
        }
        
    }
}

void OnTxDone(void *radio, void *userThisPtr, void *userData)
{
    Radio->Sleep( );
    blueLed = 0;
    printf("> OnTxDone\n");
}

void OnRxDone(void *radio, void *userThisPtr, void *userData, uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr)
{
    Radio->Sleep( );
    blueLed = 0;
    recvCount++;
    printf("Status: Recv=%d, Error=%d, Timeout=%d\n", recvCount, errCount, timeoutCount);
    printf("> OnRxDone: RssiValue=%d dBm, SnrValue=%d\n", rssi, snr);
    printf("Data[%d]: %.*s\n", size, size, payload);
    Radio->Rx(0);
}

void OnTxTimeout(void *radio, void *userThisPtr, void *userData)
{
    Radio->Sleep( );
    blueLed = 0;
    printf("> OnTxTimeout\n");
}

void OnRxTimeout(void *radio, void *userThisPtr, void *userData)
{
    Radio->Sleep( );
    blueLed = 0;
    printf("> OnRxTimeout\n");
    timeoutCount++;
    blueLed = 0;
    Radio->Rx(0);
}

void OnRxError(void *radio, void *userThisPtr, void *userData)
{
    Radio->Sleep( );
    printf("> OnRxError\n");
    errCount++;
    blueLed = 0;
    Radio->Rx(0);
}