#include "mbed.h"
#define MAXPOS 255

PwmOut servoX(PB_3);
PwmOut servoY(PB_4);
PwmOut servoZ(PB_5);


DigitalIn botoncirculo(PA_0);
DigitalIn botonpunto(PB_0);
DigitalIn botonlinea(PC_1);
DigitalIn botoncuadrado(PC_0);
float xvalue, yvalue, xiline,yiline,xfline,yfline;
int xisquare, yisquare,lenght,xlado,ylado;
double i,j,r;
 
 
 
int coord2pulse(float coord)
{
    if(0 <= coord <= MAXPOS)
    return int(coord*1000/150+750);
    return 750;
}
 
 
void vertex2d(float x, float y, float z){
 
    int pulseX = coord2pulse(x);
    int pulseY = coord2pulse(y);
    int pulseZ = coord2pulse(z);
    servoX.pulsewidth_us(pulseX);
    servoY.pulsewidth_us(pulseY);
    servoZ.pulsewidth_us(pulseZ);
}


void maxpos()
{
vertex2d(255 ,255,255);
}  
  
  void home()
{
    vertex2d(255,255,242);
    wait_ms(600);
}    

void punto()
{
    xvalue = 100;
    yvalue = 100;
    
    vertex2d(xvalue,yvalue,242);
    wait_ms(600);
    vertex2d(xvalue,yvalue,180);
    wait_ms(600);
}    
  
  void linea()
{      

    xiline = 250;
    yiline = 250;
    xfline = 10;
    yfline = 10;
    
    vertex2d(xiline,yiline,242);
    wait_ms(600);
    vertex2d(xiline,yiline,180);
    wait_ms(600);
    vertex2d(xfline,yfline,180);
    wait_ms(600);
}       

void cuadrado(){
 
 xisquare = 10;
 yisquare = 10;
 lenght = 200;
 
 
 xlado = lenght + xisquare;
 ylado = lenght + yisquare;
 
 vertex2d(xisquare,yisquare,242);
 wait_ms(600);
 vertex2d(xisquare,yisquare,180);
 wait_ms(600);
 vertex2d(xlado,yisquare,180);  
 wait_ms(600);
 vertex2d(xlado,ylado,180); 
 wait_ms(600);
 vertex2d(xisquare,ylado,180); 
 wait_ms(600);
 vertex2d(xisquare,yisquare,180); 
 wait_ms(600);
  }
  
  
  void circulo()
  {
  double x1=125,x2,y1=125,y2;
  vertex2d(x1 ,y1,240);
  wait(2);
  r=60;

  wait_ms(600);
 
  for (  x2=0;x2<=r;x2++){
      y2= pow(((r*r)-(x2*x2)),0.5);
      i=  x2+x1;  
      j=y1+y2;
      vertex2d(i ,j,180) ;
      wait_ms(30);
      }
       
    for (  x2=r;x2>=0;x2--){
      y2= pow(((r*r)-(x2*x2)),0.5);   
      i=  x2+x1;  
      j= y1 - y2;
      vertex2d(i ,j,180) ;
      wait_ms(30);
       }
  
  for (  x2=0;x2<=r;x2++){
      y2= pow(((r*r)-(x2*x2)),0.5);   
      i=  x1- x2;  
      j= y1 - y2;
      vertex2d(i ,j,180) ;
      wait_ms(30);
       }
      
      
    for (  x2=r;x2>=0;x2--){
   y2= pow(((r*r)-(x2*x2)),0.5);   
      i=  x1-x2;  
      j=y1+y2;
      vertex2d(i ,j,180) ;
      wait_ms(30);
       }
    
   
     vertex2d(i ,j,240) ;
     wait_ms(600);
      
   if(x2==r)
   {
    home();
    wait(1);
    }
     
  }
 
int main() {
      
      while(1) {
      
 // configurar periodo
    servoX.period_ms(20);
    servoY.period_ms(20);
    servoZ.period_ms(20);
    
     home();  
     wait(1);
        
     if (botonpunto == 1) { 
     punto();
     wait(1);
     }
     
     if (botonlinea == 1) { 
   
     linea();
     wait(1);
     }
     
     if (botoncuadrado == 1) { 
     cuadrado();
     wait(1);
     }
     
     if (botoncirculo == 1) { 
     circulo();
     wait(1);
     }
     }
     }

