 #include "mbed.h"
#include "SRF05.h"

Timer chrono1;
Timer chrono2;
Timer chrono3;
Timer chrono4;
Timer chrono5;
Timer chrono6;
//Timer chrono7;
//Timer chrono8;

InterruptIn ch1(p23);
InterruptIn ch2(p24);
InterruptIn ch3(p25);
InterruptIn ch4(p26);
InterruptIn ch5(p29);
InterruptIn ch6(p30);
//InterruptIn Ultra1(p5);
//InterruptIn Ultra2(p7);

SRF05 srf1(p6, p5);//p6:trigger, p5:echo
SRF05 srf2(p8, p7);//p8:trigger, p7:echo

Serial PC(USBTX, USBRX);
Serial moteurs(p9, p10);

DigitalOut del(LED1);
//DigitalOut puls1(p6);
//DigitalOut puls2(p8);

char etat_US=0;
double tps_ch1=0,tps_ch2=0,tps_ch3=0,tps_ch4=0,tps_ch5=0,tps_ch6=0,dist_US1=0,dist_US2=0;

void initial_PWMIn(void);
//void initial_Ultrasons(void);
int calcul_vitesse(void);
int calcul_direction(void);
void ecriture_moteurs(int vitesse, int gouvernail); 
//void impulsion1(void);
//void impulsion2(void);
 
void ch1_start() {
  chrono1.start();
}

void ch1_stop()
{
    chrono1.stop();
    tps_ch1 = chrono1.read_us();
    chrono1.reset();
}

void ch2_start() {
  chrono2.start();
}

void ch2_stop()
{
    chrono2.stop();
    tps_ch2 = chrono2.read_us();
    chrono2.reset();
}

void ch3_start() {
  chrono3.start();
}

void ch3_stop()
{
    chrono3.stop();
    tps_ch3 = chrono3.read_us();
    chrono3.reset();
}

void ch4_start() {
  chrono4.start();
}

void ch4_stop()
{
    chrono4.stop();
    tps_ch4 = chrono4.read_us();
    chrono4.reset();
}

void ch5_start() {
  chrono5.start();
}

void ch5_stop()
{
    chrono5.stop();
    tps_ch5 = chrono5.read_us();
    chrono5.reset();
}

void ch6_start() {
  chrono6.start();
}

void ch6_stop()
{
    chrono6.stop();
    tps_ch6 = chrono6.read_us();
    chrono6.reset();
}
/*
void Ultra1_start()
{
    if(etat_US==0) 
    {
        chrono7.reset();
        chrono7.start();
    }
}

void Ultra1_stop()//Arrêt du chronomètre du capteur 1 et impulsion capteur 2
{
    if(etat_US==0)
    {
        chrono7.stop();
        dist_US1=chrono7.read_us()/58.0;//donne la distance en cm
        etat_US = 1;
        impulsion2();
    }
}

void Ultra2_start()//Lancement du chronomètre du capteur 2 
{
    if(etat_US==1) 
    {
        chrono8.reset();
        chrono8.start();
    }
}

void Ultra2_stop()//Arrêt du chronomètre du capteur 2 et lancement d'une impulsion sur le capteur 1
{
    if(etat_US==1)
    {
        chrono8.stop();
        dist_US2=chrono8.read_us()/58.0;//donne la distance en cm
        etat_US = 0;
        impulsion1();
    }
}
*/

int main() {
  
  PC.baud(460800);
  initial_PWMIn();
  //initial_Ultrasons();
  //impulsion1();
  
  int vitesse,direction;
                               
  while(true) {
    
    if(tps_ch6 > 1200) del = 1; //Allume la led si ch6 en position haute
    if(tps_ch6 < 1200) del = 0; //Allume la led si ch6 en position basse
    
    dist_US1 = srf1.read();
    dist_US2 = srf2.read();
    //vitesse = calcul_vitesse();
    //direction = calcul_direction();
    
    //ecriture_moteurs(vitesse,direction);
    
    PC.printf("Tps haut entree 1:%.lfus\n\r",tps_ch1);
    PC.printf("Tps haut entree 2:%.lfus\n\r",tps_ch2);
    PC.printf("Tps haut entree 3:%.lfus\n\r",tps_ch3);
    PC.printf("Tps haut entree 4:%.lfus\n\r",tps_ch4);
    PC.printf("Tps haut entree 5:%.lfus\n\r",tps_ch5);
    PC.printf("Tps haut entree 6:%.lfus\n\r",tps_ch6);
    PC.printf("Distance 1:%.lfcm\n\r",dist_US1);
    PC.printf("Distance 2:%.lfcm\n\r",dist_US2);
    //PC.printf("Vitesse :%d\n\r",vitesse);
    //PC.printf("Direction : %d\n\r",direction);
    PC.printf("\n\r");
    wait(0.2);
  }
}

void initial_PWMIn(void)
{ 
  ch1.rise(&ch1_start);
  ch1.fall(&ch1_stop); 
  
  ch2.rise(&ch2_start);
  ch2.fall(&ch2_stop);
  
  ch3.rise(&ch3_start);
  ch3.fall(&ch3_stop); 
  
  ch4.rise(&ch4_start);
  ch4.fall(&ch4_stop);
  
  ch5.rise(&ch5_start);
  ch5.fall(&ch5_stop); 
  
  ch6.rise(&ch6_start);
  ch6.fall(&ch6_stop);
  
  chrono1.reset();
  chrono2.reset();
  chrono3.reset();
  chrono4.reset();
  chrono5.reset();
  chrono6.reset();
}
/*
void initial_Ultrasons(void)
{
    Ultra1.rise(&Ultra1_start);
    Ultra1.fall(&Ultra1_stop);
    
    Ultra2.rise(&Ultra2_start);
    Ultra2.fall(&Ultra2_stop);
}

void impulsion1(void)
{
    puls1 = 1;
    wait (0.00002);
    puls1 = 0;
}

void impulsion2(void)
{
    puls2 = 1;
    wait (0.00002);
    puls2 = 0;
}
*/
int calcul_vitesse(void)
{
    int val_ch2,val_ch3,vitesse;
    
    val_ch2 = (tps_ch2-1500)/5; //calcul d'une valeur entre -100 et 100 selon la position du joystick
    val_ch3 = (tps_ch3-1500)/5; 
    
    //On compare les valeurs absolues des valeurs:c'est le joystick le plus éloigné
    //de la position centrale qui domine
    if(abs(val_ch2)>abs(val_ch3)) vitesse = val_ch2;
    else vitesse = val_ch3;
    
    //vitesse nulle si les infos ne sont pas cohérentes
    if((tps_ch2<950)||(tps_ch2>2050)||(tps_ch3<950)||(tps_ch3>2050)) vitesse = 0; 
    
    if(abs(vitesse)<5) vitesse = 0;//Moteur immobile si jostick pas actionné
    if(vitesse>100) vitesse = 100; //saturation
    if(vitesse<-100) vitesse = -100; //saturation
    
    return vitesse;
}

int calcul_direction(void)
{
    int val_ch4,direction;
    
    //calcul d'une valeur entre -100 et 100 selon la position du joustick
    val_ch4 = (tps_ch4-1500)/5; 
    
    //On compare les valeurs absolues des valeurs:c'est le joystick le plus éloigné
    //de la position centrale qui domine
    direction = val_ch4;
    
    //vitesse nulle si les infos ne sont pas cohérentes
    if((tps_ch4<950)||(tps_ch4>2050)) direction = 0; 
    
    if(abs(direction)<5) direction = 0;//Moteur immobile si jostick pas actionné
    if(direction>100) direction = 100; //saturation
    if(direction<-100) direction = -100; //saturation
    
    return direction;
}

void ecriture_moteurs(int vitesse, int gouvernail)
{
    moteurs.printf("$%d|%d*",vitesse,gouvernail);
}
