#include "mbed.h"

AnalogIn potard_adc(p15); // La valeur analog rentre sur le pin P15

//Liaison série
Serial PC(USBTX,USBRX);
Serial centrale(p9,p10);
void lecture_centrale(int *ptr1,int* ptr2);

//gouvernail
PwmOut monpwm_gouv(p26); // Le PWM_gouv est sur le pin P26
DigitalOut ina_gouv(p27); // La valeur numérique sort sur le pin P27
DigitalOut inb_gouv(p25); // La valeur numérique sort sur le pin P25

//propulsion
PwmOut monpwm_pro(p21); // Le PWM est sur le pin P21
DigitalOut ina_pro(p11); // La valeur numérique sort sur le pin P11
DigitalOut inb_pro(p12); // La valeur numérique sort sur le pin P12

int main() 
{   

    //Liason série
    int vitesse,direction;
    centrale.baud(9600);
    PC.baud(460800);
    
    //gouvernail
    monpwm_gouv.period_us(50);  // f= 20 000 Hz    
    ina_gouv.write(1); //on force à 1 ina pour le mettre en sens horaire
    inb_gouv.write(0); //on force à 0 inb pour le mettre en sens anti-horaire
    
    //propulsion
    monpwm_pro.period_us(50);  // f= 20 000 Hz
    ina_pro.write(1); //on force à 1 ina pour le mettre en sens horaire
    inb_pro.write(0); //on force à 0 inb pour le mettre en sens anti-horaire
    
    while(1)
    {
        
        lecture_centrale(&vitesse,&direction);
        
        //Réglage du sens de rotation
        if(direction>= 0)
        {
            //on règle sur le sens horaire
            ina_pro.write(1); 
            inb_pro.write(0);
        }
        else
        {
            //on règle sur le sens anti-horaire
            ina_pro.write(0); 
            inb_pro.write(1);
        }
        
        PC.printf("Vitesse :%d\n\rDirection:%d\n\r",vitesse,direction);
        //monpwm_pro.write(0.1);
        //monpwm_gouv.write(0.05); //Le rapport cyclique du moteur de gouvernail
        monpwm_gouv.write(direction/200.0);
        //monpwm_pro.write(vitesse/100.0); //Le rapport cyclique du moteur de propulsion
        wait(0.01);//Tempo
    }
}


void lecture_centrale(int* ptr1,int* ptr2)
{
char fin=0;
char etat = 0;
char a,i=0;
char buffer[30];

while(fin==0)
{
if (centrale.readable())
{ // attention PC.readable reste à 1 tant qu'il n'y a pas eu de getc qui vide le buffer
a=centrale.getc();

switch(etat)
{
case 0 :
if(a=='$')//On attend le début d'une trame
{
buffer[0] = '$';
i=1;
etat = 1;
}
break;

case 1 ://Après le début d'une trame, on récupère la trame en entier et on l'analyse
buffer[i] = a;
i++;
if(a=='*')
{
sscanf(buffer,"$%d|%d*",ptr1,ptr2);
fin = 1;
i=0;
etat=0;
}
break;

default :
etat = 0;
break;

}
}
}
}