#include "mbed.h"
#include <string.h>

//Serial PC(USBTX, USBRX);
Serial ZigBee(A4, A5);//Série (Tx,Rx)

DigitalOut del(LED1);
char drapeau_envoi = 0;

int reception_ZigBee(int id,int* commande_coach,float* velnormal,float* velangular,float* veltangent,int* wheelspeed,int* spinner);
void envoi_ZigBee(int ZB_id,int ZB_statut,int ZB_pos_x,int ZB_pos_y);

int main()
{
    //Varaibles avec toutes les données
    int id = 1;
    int commande_coach  = 32;
    float velnormal     = 32;
    float velangular    = 33;
    float veltangent    = 43;
    int wheelspeed      = 23;
    int spinner         = 43;
    
    int statut = 0;
    int pos_x  = 324;
    int pos_y  = 345;
    char drapeau_reception;
    
    //PC.baud(115200);
    ZigBee.baud(115200);
    
    while (1) {
        drapeau_reception = reception_ZigBee(id,&commande_coach,&velnormal,&velangular,&veltangent,&wheelspeed,&spinner);
        if(drapeau_reception == 1){
            envoi_ZigBee(id,statut,pos_x,pos_y);
            drapeau_reception = 0;
        }
        wait(0.01);
    }
}

void envoi_ZigBee(int ZB_id,int ZB_statut,int ZB_pos_x,int ZB_pos_y){
    //Envoi de trames de la forme : "Did(int)|controle(int)|x(float)|y(float)F"
    char message[200];
    sprintf(message,"D%d|%d|%d|%dF",ZB_id,ZB_statut,ZB_pos_x,ZB_pos_y);
    ZigBee.printf(message);
}

int reception_ZigBee(int id,int* commande_coach,float* velnormal,float* velangular,float* veltangent,int* wheelspeed,int* spinner){
    del = !del;
    //Chaine de caractères qui va recevoir les données
    char message[200];
    char drapeau = 0;
    unsigned char i = 0;
    int test_id = 0;
    
    //Tant qu'il y a quelque chose dans le buffer, on l'ajoute à une chaîne de caractères 
    while(ZigBee.readable()) {
        message[i] = ZigBee.getc();
        i++;
    }
        
    //Si on a reçu quelque chose
    if(i>0){
        //Séparation des données
        sscanf(message,"D%d|%d|%f|%f|%f|%d|%dF\n\r",
                &test_id,
                commande_coach,
                veltangent,
                velnormal,
                velangular,
                spinner,
                wheelspeed
                );
                
        //On vide la chaîne de caractères contenant le message
        for(i=0;i<sizeof(message);i++){
            message[i] = 0;
        }
        i=0;
        drapeau = 1;
        
    }
    return drapeau;
}