
#include "mbed.h"

#include "GroveGPS.h"

Serial gps_serial(p9, p10, 9600);
Serial pc(USBTX, USBRX); //Initialise une liason série via le connecteur USB du pc

Thread gpsThread;
GroveGPS gps;

// Runs at 1Hz and updates the GPS location every second
void gps_updater_thread() {
    char i;
    while(true) {
        char latBuffer[16], lonBuffer[16];
        gps.getLatitude(latBuffer);
        gps.getLongitude(lonBuffer);

        // Utilize latitude and longitude values here
        pc.printf("Latitude: %s, Longitude: %s\n\r", latBuffer, lonBuffer);
        /*for(i=0;i<16;i++)
        {
            pc.printf("%c ",latBuffer[i]);
        }
        pc.printf("\n\r");*/
        wait(1);
    }
}

int main() {
    
    pc.baud(115200);//Initialise la vitesse de la communication série

    // Start a thread to get updated GPS values
    gpsThread.start(gps_updater_thread);

    // Read the serial bus to get NMEA GPS details
    while (true) {
        if (gps_serial.readable()) {
            gps.readCharacter(gps_serial.getc());
        }
    }

    return 0;
}