
#include "mbed.h"
#include "HMC5883L.h"

HMC5883L compass(p9, p10);
Serial pc(USBTX, USBRX); //Initialise une liason série via le connecteur USB du pc
 
int main(void)
{
    pc.baud(115200);//Initialise la vitesse de la communication série
    int16_t data[3] = {0};
    double heading = 0.0f;
    
    compass.init();
    
    while(1) {
        compass.getXYZ(data);
        wait(0.1f);
        heading = compass.getHeadingXYDeg();
        pc.printf("x: %4d, y: %4d, z: %4d\n\r", data[0], data[1], data[2]);
        pc.printf("heading: %3.2f\n\r", heading);
        wait(1.0f);
    }
}
