#include "mbed.h"

Timer chrono1;
Timer chrono2;
Timer chrono3;
Timer chrono4;
Timer chrono5;
Timer chrono6;

InterruptIn ch1(p23);
InterruptIn ch2(p24);
InterruptIn ch3(p25);
InterruptIn ch4(p26);
InterruptIn ch5(p29);
InterruptIn ch6(p30);

DigitalOut del(LED1);

Serial PC(USBTX, USBRX);

double tps_ch1=0,tps_ch2=0,tps_ch3=0,tps_ch4=0,tps_ch5=0,tps_ch6=0;

void initial_PWMIn(void); 
 
void ch1_start() {
  chrono1.start();
}

void ch1_stop()
{
    chrono1.stop();
    tps_ch1 = chrono1.read_us();
    chrono1.reset();
}

void ch2_start() {
  chrono2.start();
}

void ch2_stop()
{
    chrono2.stop();
    tps_ch2 = chrono2.read_us();
    chrono2.reset();
}

void ch3_start() {
  chrono3.start();
}

void ch3_stop()
{
    chrono3.stop();
    tps_ch3 = chrono3.read_us();
    chrono3.reset();
}

void ch4_start() {
  chrono4.start();
}

void ch4_stop()
{
    chrono4.stop();
    tps_ch4 = chrono4.read_us();
    chrono4.reset();
}

void ch5_start() {
  chrono5.start();
}

void ch5_stop()
{
    chrono5.stop();
    tps_ch5 = chrono5.read_us();
    chrono5.reset();
}

void ch6_start() {
  chrono6.start();
}

void ch6_stop()
{
    chrono6.stop();
    tps_ch6 = chrono6.read_us();
    chrono6.reset();
}

int main() {
  
  PC.baud(460800);
  initial_PWMIn();
                               
  while(true) {
    PC.printf("Tps haut entree 1:%.lfus\n\r",tps_ch1);
    PC.printf("Tps haut entree 2:%.lfus\n\r",tps_ch2);
    PC.printf("Tps haut entree 3:%.lfus\n\r",tps_ch3);
    PC.printf("Tps haut entree 4:%.lfus\n\r",tps_ch4);
    PC.printf("Tps haut entree 5:%.lfus\n\r",tps_ch5);
    PC.printf("Tps haut entree 6:%.lfus\n\r\n\r",tps_ch6);
    
    if(tps_ch6 > 1200) del = 1; //Allume la led si ch6 en position haute
    if(tps_ch6 < 1200) del = 0; //Allume la led si ch6 en position basse
    wait(0.2);
  }
}

void initial_PWMIn(void)
{
  ch1.rise(&ch1_start);
  ch1.fall(&ch1_stop); 
  
  ch2.rise(&ch2_start);
  ch2.fall(&ch2_stop);
  
  ch3.rise(&ch3_start);
  ch3.fall(&ch3_stop); 
  
  ch4.rise(&ch4_start);
  ch4.fall(&ch4_stop);
  
  ch5.rise(&ch5_start);
  ch5.fall(&ch5_stop); 
  
  ch6.rise(&ch6_start);
  ch6.fall(&ch6_stop);
  
  chrono1.reset();
  chrono2.reset();
  chrono3.reset();
  chrono4.reset();
  chrono5.reset();
  chrono6.reset();
}