#include "mbed.h"

Serial energie(p28, p27);
Serial moteurs(p9, p10);

Serial PC(USBTX,USBRX);

void lecture_energie(double* ptr1);
void ecriture_moteurs(int vitesse);

int main() {
    double niveau = 0;
    int vitesse=7;
    
    moteurs.baud(9600);
    energie.baud(9600);
    PC.baud(460800);
    
    while(1) {
        //lecture_energie(&niveau);//attention:on reste dans lecture_energie tant qu'on n'a pas la trame en entier
        ecriture_moteurs(vitesse);
        PC.printf("Niveau : %lf\n\r",niveau);
        vitesse++;
        wait(0.2);
    }
}

void ecriture_moteurs(int vitesse)
{
    moteurs.printf("$%d*",vitesse);
}


void lecture_energie(double* ptr1)
{
    char fin=0;
    char etat = 0;
    char a,i=0;
    char buffer[17];
    
    while(fin==0)
    {
if (energie.readable()) 
        {  // attention PC.readable reste à 1 tant qu'il n'y a pas eu de getc qui vide le buffer
            a=energie.getc();
            
        switch(etat)
        {
            case 0 :
            if(a=='$')//On attend le début d'une trame
            {
                buffer[0] = '$';
                i=1;
                etat = 1;
            }
            break;
            
            case 1 ://Après le début d'une trame, on récupère la trame en entier et on l'analyse
            buffer[i] = a;
            i++;
            if(a=='*')
            {
                sscanf(buffer,"$%lf*",ptr1);
                fin = 1;
                i=0;
                etat=0;
            }
            break;
            
            default :
            etat = 0;
            break;
            

           }
           }
           }
           }