#include "x10rf.h"

x10rf::x10rf(PinName pin) : pin(pin)
{}

// -------------------------------------- Fonctions X10 ---------------------------------
// Envoi entête:
void x10rf::x10_sendpreamble(void)
{
    pin = 0;     // X10PIN à 0.
    wait_ms(40) ;
    pin = 1;    // X10PIN à 1.
    wait_ms(9) ;
    pin = 0;    // X10PIN à 0.
    wait_us(4500) ;
}

// --------------------------------------------------------------------------------------
// Envoi bit:
void x10rf::x10_sendbit(void)
{
    pin = 1;     // X10PIN à 1.
    wait_us(560) ;
    pin = 0;      // X10PIN à 0.
    wait_us(560) ;
}

// -----------------------
// Envoi d'un octet X10 RF
void x10rf::x10_sendoctet(char X10octet)
{
    char nobit, valbit;
    for (nobit=0; nobit<=7; nobit++) {
        valbit=X10octet & 0x80;
        X10octet=(X10octet << 1);

        x10_sendbit();              // On envoi un bit
        if ( valbit ) {             // Si bit à 1 pause + longue.
            wait_us(1200) ;
        }
    }
}

// Envoie trame X10, House Code / Unit Code / Action (ON/OFF/DIM/BRIGHT)
void x10rf::x10_sendcmd(char House, char Unit, char Action)
{
    char hc, uc ;

    hc = house_code[House - 0x41] ; // Lit code correspondant dans tableau house_code.

    if(Unit>8) {
        hc |= 0x04 ;
        Unit-=8;
    }

    uc = unit_code[Unit-1] ;        // Lit code correspondant dans tableau unit_code.

    if (Action==OFF)
        uc |= 0x20 ;
    else if(Action==BRIGHT)
        uc=0x88;
    else if(Action==DIM)
        uc=0x98;

    // Envoie commande X10 hc/uc.
    x10_sendpreamble() ;
    x10_sendoctet(hc) ;        // house code
    x10_sendoctet(~hc) ;       // ~house code
    x10_sendoctet(uc) ;        // unit code
    x10_sendoctet(~uc) ;       // ~unit code
    x10_sendbit() ;
}