#include "mbed.h"   // Stephen Reidy; T00214774; Instrumentation  Report
#include "LM75B.h"  // Tempsensor  header 
#include "C12832.h" // LCD Screen header 

LM75B tempsensor(p28,p27);           // temp sensor initialised, pins 28 & 27
Serial pc(USBTX,USBRX);              // Transmit & Receive initialised
C12832 lcd(p5, p7, p6, p8, p11);     // LCD Pins initialised
DigitalOut testled(LED1);            // LED 1 digital out initialised
AnalogIn Heater (p19);               //Read digital in
DigitalOut RED(p23);                 // colour LED 1
DigitalOut GREEN(p24);               // colour LED 2
DigitalOut BLUE(p25);                // colour LED 3

int main ()
{
    while (1) {

        if (tempsensor.open()) {                                // check of sensoe is connected
            testled = 1;                                        // if yes LED ON
            pc.printf("Tempsensor connected \n");               // PC print Tempsensor connected
        } else {                                                // if temp sensor not connected, print Error
            lcd.printf("Error. Tempsensor not connected \n");
            pc.printf("Error. Tempsensor not connected \n");
        }

        if (tempsensor > 25.000 && Heater > 0.5) {      //if tempsensor is more than 25, display red led
            RED = 0;
            GREEN = 1;
            BLUE = 1;
            lcd.printf(" switch OFF Heat ");
            wait (.5);
        }                                      //Delay for clarity

        if (tempsensor < 25.000 && Heater < 0.5) {      //if tempsensor is more than 25, display red led
            RED = 1;
            GREEN = 1;
            BLUE = 0;
            lcd.printf(" switch ON Heat ");
            wait (.5);                                        //Delay for clarity
        }

        lcd.cls();                                          //Clear LCD screen
        lcd.locate(0,0);                                    // LCD text location
        lcd.printf("Temp = %.3f\n", (float)tempsensor);     // Print "Temp = " tempsensor value
    }


}

