#include "mbed.h"
//configuração de portas
AnalogIn POT(A5);
PwmOut ENA(D2);
DigitalOut IN1A(D5);
DigitalOut IN2A(D4);
InterruptIn ENCONDER(D3);

Timer tempo;
int pulsos =0;
const int HIGH = 1;
const int LOW = 0;
const int fonte = 12;

//abertura de porta serial com a conexão USB
Serial pc(USBTX, USBRX);
  
 
void Contador_BD(){pulsos++;}

void Motor_A(float duty_cyle){
    IN1A = LOW;
    IN2A = HIGH;
    ENA.write(duty_cyle);
}

int main(){
    pc.baud(9600);
    tempo.start(); 
    ENCONDER.fall(&Contador_BD);
    while(true){
        float velocidade = POT.read();
        Motor_A(velocidade);
        if(tempo.read_ms() >= 1000){
            pc.printf("TENSAO ARMADURA: %f\n\r", fonte*velocidade);
            pc.printf("RPM: %d\n\r",pulsos*2);
            pulsos=0;
            tempo.reset();
        }
        
    }
}