#include "mbed.h"
// -------------- Definição portas --------------
PwmOut IN_1 (PA_8); // IHM07M1 PWM
PwmOut IN_2 (PA_9);
PwmOut IN_3 (PA_10);
DigitalOut EN_1 (PC_10); // IHM07M1 ENABLE
DigitalOut EN_2 (PC_11);
DigitalOut EN_3 (PC_12);
DigitalIn button(PC_13); // botão de usuário
AnalogIn potenciometro(PB_1);
Serial pc(USBTX, USBRX);

bool estado;

float map(float x, float in_min, float in_max, float out_min, float out_max){
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

int main(){
    // SETUP
    pc.baud(9600);
    estado = false; 
    //3 braços começam desacoplados
    EN_1 = 2; // Braço A
    EN_2 = 2; // Braço B
    EN_3 = 2; // Braço C
    //frequencia de acionamento (gates dos transistores) PWM -> 1ms
    IN_1.period_ms(1); 
    IN_2.period_ms(1); 
    IN_3.period_ms(1); 
    //pwm com duty cicle 0%
    IN_1.write(0); 
    IN_2.write(0); 
    IN_3.write(0);
    while(1) {
        int leitura = potenciometro.read();// leitura do potenciometro
        float delay = map(leitura, 0, 4095, 0.008, 0.003);

        if (button == 0) {
            // VARIAÇÃO entre estado e !estado = Irá ligar ou desligar o motor
            estado = !estado;
            wait_ms(200);
        }

        if(estado) {
            //acionamento de cada braço com diferentes polaridades seguidas de desacoplamento
            // 2 - desacoblado, 1 HIGH, 0 LOW (ENABLE)
            // 1 High - 0 LOW (INPUT)
            //STEP 1
            IN_1 = 1;
            EN_1 = 1;
            wait(delay);
            IN_1 = 0;
            EN_1 = 2;

            //STEP 2
            IN_3 = 1;
            EN_3 = 0;
            wait(delay);
            IN_3 = 0;
            EN_3 = 2;

            //STEP 3
            IN_2 = 1;
            EN_2 = 1;
            wait(delay);
            IN_2 = 0;
            EN_2 = 2;

            // STEP 4
            IN_1 = 1;
            EN_1 = 0;
            wait(delay);
            IN_1 = 0;
            EN_1 = 2;

            //STEP 5
            IN_3 = 1;
            EN_3 = 1;
            wait(delay);
            IN_3 = 0;
            EN_3 = 2;

            //STEP 6
            IN_2 = 1;
            EN_2 = 0;
            wait(delay);
            IN_2 = 0;
            EN_2 = 2;
        }
    }

}