/*
 * mbed library to use a Bosch Sensortec BMP085 sensor
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
#ifndef BMP085_H
#define BMP085_H

#include "mbed.h"

enum BMP085_oss {
    BMP085_oss1 = 0,
    BMP085_oss2 = 1,
    BMP085_oss4 = 2,
    BMP085_oss8 = 3
};

class BMP085{
public:
    BMP085(PinName p_sda, PinName p_scl, BMP085_oss p_oss = BMP085_oss1);
    BMP085(I2C& p_i2c, BMP085_oss p_oss = BMP085_oss1);

    float get_temperature();
    long get_pressure();
    //float get_pressure();
    void update();

protected:
    void init(BMP085_oss);
    unsigned short twi_readshort (int, int);
    unsigned long twi_readlong (int, int);
    void twi_writechar (int, int, int);

    I2C i2c;
    float temperature;
    long pressure;
    //float pressure;

private:

    short ac1, ac2, ac3, b1, b2, mb, mc, md, oss;
    unsigned short ac4, ac5, ac6;
};

#endif