//sleep mode
void steven_Sleep(void) {
    
    LPC_SC->PCON=0x0; 
    // SRC[SLEEPDEEP] set to 0 = sleep, this bit control whether the processor uses sleep or deep sleep as its  low power mode
    SCB->SCR &= ~SCB_SCR_SLEEPDEEP_Msk;
    
    // wait for interrupt
    __WFI();
}
// "Deep Sleep" mode
void steven_DeepSleep(void) {

    
    // PCON[PD] set to DeepSleep
    LPC_SC->PCON = 0x0;
    
    // SRC[SLEEPDEEP] set to 0 = DeepSleep
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    
    // wait for interrupt
    __WFI();
}

//"Power-Down" Mode
void steven_PowerDown(void)
{
   SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
   LPC_SC->PCON=0x1; // PM1=0, PM0=1, enter power down mode if the SLEEPDEEP bit in SCR is 1
   __WFI();
   //reset back to normal
   LPC_SC->PCON = 0x1;
}

//"Deep Power-Down" Mode
void steven_DeepPowerDown(void)
{
   SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
   LPC_SC->PCON = 0x3;//// PM1=1, PM0=1, enter deep power down mode if the SLEEPDEEP bit in SCR is 1
   __WFI();
   //reset back to normal
  LPC_SC->PCON =0x0;
}

// "Brown-out Reduced Power mode"
void steven_BOGD_PowerDown(void)
{
    LPC_SC->PCON=0x1d; // PM1=0, PM0=1, enter power down mode if the SLEEPDEEP bit in SCR is 1; BOGD
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    __WFI();
}
 