#include "mbed.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
#include "WakeUp.h"
#include "powercontrol.h"
#include "ClockControl/ClockControl.h"


DigitalOut myled1(LED1);
DigitalOut myled2(LED2) ;
DigitalOut myled3(LED3) ;

Timer t;



int main()
{
    //profiling_PHY_PowerDown();
    //PHY_PowerUp();// power up PHY because it was powerred up as default. We might power it down when test "Turn off PHY".
    
    myled1=1;
    wait(0.5);
    myled1=0;
    char char_get=0;
    int num_get=0;
    char* powermode[7]={ "[1] no low power", "[2] sleep mode", "[3] deep sleep mode", "[4] power down mode", "[5] Brown-out Reduced Power mode", "[6] Deep Power Down", "[7] Turn off PHY"};
    
    
    printf("Which frequency you want to run \r\n");
    printf("[1] 96MHz \r\n");
    printf("[2] 48MHz \r\n");
    char_get=getchar();
    num_get=char_get-48;
   
    
    switch (num_get){
        case 1: setSystemFrequency(0x3, 0x1, 12, 1);break;
        case 2: setSystemFrequency(0x3, 0x1, 12, 2);break;
        default: setSystemFrequency(0x3, 0x1, 12, 1);break;
    }
     Serial pc (USBTX, USBRX);
    pc.printf ("num_get is %d \r\n", num_get);
    wait (3);
    num_get=0;
    char_get=0;
    
    while (num_get>7 || num_get<1){
        pc.printf("Which power mode you want to choose: \r\n");
        for (int a=0;a<7;a++)
            pc.printf("%s \r\n", powermode[a]);
        char_get=pc.getc(); // get char from serial
        num_get=char_get-48;// convert char to int, minus 48 since ascii num start from 48
        if (num_get>7 || num_get<1)       
            pc.printf("You have choosen an invalid num, please choose a correct one\r\n");
    }      
    pc.printf ("I am going to test %s\r\n",powermode[num_get-1]);
    myled2=1;
    wait(0.5);
    myled2=0;
    WakeUp::set(10);
    //WakeUp::set(70);
    switch (num_get){
        case  1: break;
        case  2: steven_Sleep();break;
        case  3: steven_DeepSleep(); break;
        case  4: steven_PowerDown();break;
        case  5: steven_BOGD_PowerDown();break;
        case  6: steven_DeepPowerDown(); break;
        case  7: PHY_PowerDown(); break;
        default: pc.printf("Not valid input\n"); break;          
    }     
   while (1);
}
