#include "mbed.h"
#include "USBHostMSD.h"

DigitalOut led(LED1);
DigitalOut debug_pin(A5);

void msd_task(void const*)
{
    USBHostMSD msd("usb");
    int i = 0;

    debug_pin = 0;

    while(1)
    {
        // try to connect a MSD device
        while(!msd.connect())
        {
            Thread::wait(500);
            printf("Waiting for USB stick..\n");
        }
       
        FILE* fp = fopen("/usb/my_test.txt", "w");
       
        while(1)
        {
            if(fp != NULL)
            {
                debug_pin = 1;
                
                fprintf(fp, "Hello, SD Card World: that's the string number %d!\r\n", i++);
                //printf("Goodbye World!\r\n");
                //fclose(fp);
                
                debug_pin = 0;
            }
            else 
            {
                printf("FILE == NULL\r\n");
            }

            Thread::wait(10);

            // if device disconnected, try to connect again
            //if(!msd.connected())
            //    break;
        }
    }
}


int main()
{
    Thread msdTask(msd_task, NULL, osPriorityNormal, 1024*8);
    
    while(1)
    {
        led=!led;
        Thread::wait(500);
    }
}