/***************************************************************************
                                   DUMP I2C
                                 +----------+ 
Do an I2C Dump for testing.

Fast PWM is use for dump ov7670 REG, I must have xclock for using I2C.
You can remove them.

Stéphane PEREZ (stefkpl)

****************************************************************************/

#include "mbed.h"
#include "FastPWM.h"

 // Test DUMP I2C
#define _ADDR     (0x42) 
#define CAMERA_CLK_PERIOD .1// ==> 10Mhz 100nS 
#define VSYNC   D9
 
I2C i2c(I2C_SDA, I2C_SCL);
 
DigitalOut myled(LED1);

FastPWM __xclk(VSYNC);

Serial pc(SERIAL_TX, SERIAL_RX);
char value;
char cmd;
int main()
{
    __xclk.period_us(CAMERA_CLK_PERIOD);
    __xclk.write(0.5);   
   
    pc.printf("Begin Scan\r\n");
 
    for (char n=0; n<0xFF; n++){

        i2c.write(_ADDR, &n, 1);
        i2c.read(_ADDR, &value, 1);
        pc.printf("addresse 0x%x \t- reg:0x%x \t- value:%d \t- 0x%X\r\n",_ADDR, n, value, value);

    }
    // because n cannot be upper than 0xFF on the loop, and I don't want use another ... ;-)
    value = 0xFF;
    i2c.write(_ADDR, &value, 1);
    i2c.read(_ADDR, &value, 1);
    pc.printf("addresse 0x%x \t- reg:0x%x \t- value:%d \t- 0x%X\r\n",_ADDR, 0xFF, value, value);

    pc.printf("End Scan\r\n");
    
    while (1) {
        myled = !myled;
        wait(0.2);
    }
 
}
 
