#include "mbed.h"
#include "stdio.h"
#include "string.h"
#include "GPS.h"
 
Timer t;
DigitalOut LedVerde(LED2);
PwmOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
AnalogIn in(PTB0);
PwmOut Pwm1(PTD1);


Serial GSM(PTE0,PTE1);  
Serial pc(USBTX,USBRX);

char DEvol[255];
char DSvol[255];
char buffer[512];
char resp[6];
char tam[2];
char mensaje[100];
int duty;
float pwm;

int i, K, C, LENOUTvol, LENINvol;
int c=0;
char msg[256];
char char1;
int cmgs;
char out[16], OtroOut[16];
int ret = 1;
char tel[15];
float vol,yolo;
char volt[255];
char buf[100];
char trama1[] = "0011000A91";
char trama2[] = "0000AA";

void reverse(char *str, int len)
{
    int i=0, j=len-1, temp;
    while (i<j)
    {
        temp = str[i];
        str[i] = str[j];
        str[j] = temp;
        i++; j--;
    }
}
 
 // Converts a given integer x to string str[].  d is the number
 // of digits required in output. If d is more than the number
 // of digits in x, then 0s are added at the beginning.
int intToStr(int x, char str[], int d)
{
    int i = 0;
    while (x)
    {
        str[i++] = (x%10) + '0';
        x = x/10;
    }
 
    // If number of digits required is more, then
    // add 0s at the beginning
    while (i < d)
        str[i++] = '0';
 
    reverse(str, i);
    str[i] = '\0';
    return i;
}
 
// Converts a floating point number to string.
void ftoa(float n, char *res, int afterpoint)
{
    // Extract integer part
    int ipart = (int)n;
 
    // Extract floating part
    float fpart = n - (float)ipart;
 
    // convert integer part to string
    int i = intToStr(ipart, res, 0);
 
    // check for display option after point
    if (afterpoint != 0)
    {
        res[i] = '.';  // add dot
 
        // Get the value of fraction part upto given no.
        // of points after dot. The third parameter is needed
        // to handle cases like 233.007
        float fp=10;
        fpart =fpart * pow(fp,afterpoint);
        
        intToStr((int)fpart, res + i + 1, afterpoint);
    }
}
 
void FlushGSM(void) { 
    char1 = 0;
    while (GSM.readable()){
        char1 = GSM.getc();
    }
        return;
}
 
void callback(){
    // Note: you need to actually read from the serial to clear the RX interrupt
    pc.printf("%c\n", GSM.getc()); 
}
 
// Esta funcion de abajo lee todo un bufer hasta encontrar CR o LF y el resto lo rellena de
// $, count es lo que va a leer. Lo leido lo mete en buffer que es una cadena previamente definida
// incorpora medida de tiempo si se demora mas de tres segundos retorna fracaso con -1
int readBuffer(char *buffer,int count){
    int i=0; 
    t.start();  // start timer
    while(1) {
        while (GSM.readable()) {
            char c = GSM.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(t.read() > 3) {
            t.stop();
            t.reset();
            break;
        }
    }
    wait(0.5);
    while(GSM.readable()){  // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}
 
// Esta función de abajo limpia o borra todo un "buffer" de tamaño "count",
// lo revisa elemento por elemento y le mete el caracter null que indica fin de cadena.
// No retorna nada.
void cleanBuffer(char *buffer, int count){
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
 
// Esta función de abajo envia un comando parametrizado como cadena
// puede ser un comando tipo AT.
void sendCmd(char *cmd){
    GSM.puts(cmd);
}
 
// Esta función de abajo espera la respuesta de un comando que debe ser idéntica a la cadena "resp" y un tiempo "timeout",
// si todo sale bien retorna un cero que en la programacion hay que validar,
// si algo sale mal (no se parece o se demora mucho) retorna -1 que debera validarse con alguna expresion logica.
int waitForResp(char *resp, int timeout){
    int len = strlen(resp);
    int sum=0;
    t.start();
 
    while(1) {
        if(GSM.readable()) {
            char c = GSM.getc();
            sum = (c==resp[sum]) ? sum+1 : 0;// esta linea de C# sum se incrementa o se hace cero segun c
            if(sum == len)break;  //ya acabo se sale
        }
        if(t.read() > timeout) {  // time out chequea el tiempo minimo antes de salir perdiendo
            t.stop();
            t.reset();
            return -1;
        }
    }
    t.stop();                 // stop timer  antes de retornar
    t.reset();                    // clear timer
    while(GSM.readable()) {      // display the other thing..
        char c = GSM.getc();
    }
    return 0;
}
 
// Esta función de abajo es muy completa y útil, se encarga de enviar el comando y esperar la respuesta.
// Si todo sale bien retorna un cero (herencia de las funciones contenedoras) que en la programacion hay que validar
// con alguna expresion lógica.
int sendCmdAndWaitForResp(char *cmd, char *resp, int timeout){
    sendCmd(cmd);
    return waitForResp(resp,timeout);
}
 
// Esta función de abajo chequea que el módem este vivo, envia AT, le contesta con OK y espera 2 segundos.
int powerCheck(void){ // Este comando se manda para verificar si el módem esta vivo o conectado.
    return sendCmdAndWaitForResp("AT\r\n", "OK", 2);    
}
 
// Esta función de abajo chequea el estado de la sim card
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
int checkSIMStatus(void){
    char gprsBuffer[30];
    int count = 0;
    cleanBuffer(gprsBuffer, 30);
    while(count < 3){
        sendCmd("AT+CPIN?\r\n");
        readBuffer(gprsBuffer,30);
        if((NULL != strstr(gprsBuffer,"+CPIN: READY"))){
            break;
        }
        count++;
        wait(1);
    }
 
    if(count == 3){
        return -1;
    }
    return 0;
}
 
// Esta función de abajo chequea la calidad de la señal
// y si todo sale bien retorna con el valor de señal útil o un -1 si no es aceptable, en la programacion hay que validar
// con alguna expresión lógica.
int checkSignalStrength(void){
    char gprsBuffer[100];
    int index, count = 0;
    cleanBuffer(gprsBuffer,100);
    while(count < 3){
        sendCmd("AT+CSQ\r\n");
        readBuffer(gprsBuffer,25);
        if(sscanf(gprsBuffer, "AT+CSQ$$$$+CSQ: %d", &index)>0) {
            break;
        }
        count++;
        wait(1);
    }
    if(count == 3){
        return -1;
    }
    return index;
}
 
// Esta funcion de abajo inicaliza el módem. Se compone de un grupo de subfunciones ya definidas previamente
// primero chequea que este vivo,
// segundo chequea el estado de la simcard,
// tercero chequea la intencidad de señal celular,
// cuarto aplica la configuracion
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
int init(){
    if (0 != sendCmdAndWaitForResp("AT\r\n", "OK", 3)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CNMI=1,1\r\n", "OK", 3)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CMGF=0\r\n", "OK", 3)){
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("AT+CBST=7,0,1\r\n", "OK", 3)){ //velocidad fija a 9600, modem asincronico no transparente
        return -1;
    }
    if (0 != sendCmdAndWaitForResp("ATE\r\n", "OK", 3)){ //se le quita el eco al modem GSM
        return -1;
    }
    LedVerde=0;
    return 0;
}
  
// Esta funcion de abajo intenta leer un mensaje de texto en formato PDU o HEX
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresión lógica.
int readSMSpdu(char *message, int index){
    int i = 0;
    char gprsBuffer[100];
    char *p,*s;
    GSM.printf("AT+CMGR=%d\r\n",index);
    cleanBuffer(gprsBuffer,100);
    readBuffer(gprsBuffer,100);
    if(NULL == ( s = strstr(gprsBuffer,"+CMGR"))) {
        return -1;
    }
    if(NULL != ( s = strstr(gprsBuffer,"+32"))) {
        p = s + 6;
        while((*p != '$')&&(i < 5)) {
            message[i++] = *(p++);
        }
        message[i] = '\0';
    }
    return 0;
}
 
// Esta función de abajo borra mensajes SMS del modem
// y si todo sale bien retorna un cero que en la programacion hay que validar
// con alguna expresion logica.
int deleteSMS(int index){
    char cmd[32];
    snprintf(cmd,sizeof(cmd),"AT+CMGD=%d\r\n",index);
    sendCmd(cmd);
    return 0;
}
 
 
int main(){
       
    GSM.baud(9600);
    GSM.format(8,Serial::None,1);     
    LedVerde = 1; // APAGO LOS LEDS
    //LedRojo = 1; 
    LedAzul = 1;
    //LedRojo = 0; // PRENDO EL LED ROJO
    // Quito el eco del modem
    
    // CONFIGURACIÓN DEL MODEM GSM (TELEFONO CELULAR SIEMENS A56i).
    inicio1:        
        ret = init();
        if(ret==0){
            //LedRojo = 1;
            LedVerde = 0; // Apagar LED Verde para confirmar la comunicación con el módem.
            pc.printf("Listo!\n");
        }
        else{
            wait(1);
            goto inicio1;    
        }
        
    while(1){ 
        if (GSM.readable()){
            readBuffer(buffer,110);
            pc.printf("%s\r\n",buffer);
            for(i=0; i<5; i++){
                resp[i] = buffer[i];
            }  
             
            pc.printf("%s\r\n", resp);
            if(strcmp("$$+CM", resp) == 0){  //COMPARA resp con "+CMTI"
                pc.printf("Llego MSG\r\n");
                cleanBuffer(buffer,10);
                GSM.printf("AT+CMGL=0\r\n"); // Envío comando para leer mensaje
                pc.printf("AT+CMGL=0\r\n");
                readBuffer(buffer,110);
                pc.printf("%s\r\n",buffer);
                
                // Lectura el teléfono emisor
                for(i=0; i<10; i++){
                    tel[i] = buffer[i+40];
                }
                
                // Lectura del tamaño
                for(i=0;i<2;i++){
                    tam[i] = buffer[i + 68];
                }
                pc.printf("%s-\r\n", tam);        
                
                // Lectura del mensaje
                for(i=0;i<26;i++){
                   msg[i] = buffer[i+70]; // Lee un mensaje de 26 caracteres máximo desde la posición 70 del buffer.
                }
                pc.printf("%s-\r\n", msg);
                
                // Decodificación del mensaje
                
                // Comparar el mensaje
                deleteSMS(1); // Se borran los mensajes por medio de una función
                readBuffer(buffer, 200);
                //"D07B5B" es "Pwm".En PDU
                if((strncmp("D07B5B", msg, 6) == 0)){  

                    //LedRojo = 0;
                    LedVerde = 1;
                    LedAzul = 0; 
                    wait(2);
                    
                    switch(msg[6]){
                        case ('0'):
                        duty=10*0;
                        break;
                        case ('1'):
                        duty=10*1;
                        break;
                        case ('2'):
                        duty=10*2;
                        break;
                        case ('3'):
                        duty=10*3;
                        break;
                        case ('4'):
                        duty=10*4;
                        break;
                        case ('5'):
                        duty=10*5;
                        break;
                        case ('6'):
                        duty=10*6;
                        break;
                        case ('7'):
                        duty=10*7;
                        break;
                        case ('8'):
                        duty=10*8;
                        break;
                        case ('9'):
                        duty=10*9;
                        break;
                        }

                    if(msg[8]=='8' && msg[9]=='3'){duty=duty+0;}
                    if(msg[8]=='8' && msg[9]=='B'){duty=duty+1;}
                    if(msg[8]=='9' && msg[9]=='3'){duty=duty+2;}
                    if(msg[8]=='9' && msg[9]=='B'){duty=duty+3;}
                    if(msg[8]=='A' && msg[9]=='3'){duty=duty+4;}
                    if(msg[8]=='A' && msg[9]=='B'){duty=duty+5;}
                    if(msg[8]=='B' && msg[9]=='3'){duty=duty+6;}
                    if(msg[8]=='B' && msg[9]=='B'){duty=duty+7;}
                    if(msg[8]=='C' && msg[9]=='3'){duty=duty+8;}
                    if(msg[8]=='C' && msg[9]=='B'){duty=duty+9;}
                    
                    pc.printf("%d\r\n", duty);
                    
                    pwm=float(duty)/100.0;
                    pwm=1-pwm;
                    LedVerde=1;
                    LedAzul =1;
                    LedRojo.period(5.0f);      // 5 second period
                    LedRojo.write(pwm);
                    Pwm1.period(5.0f);
                    Pwm1.write(pwm);
                    
                    }                        
            
                // "F6379B1E569701" es "voltaje". "F6379B1E569701" es "Voltaje". En PDU
                if((strncmp("F6379B1E569701", msg, 14) == 0) || (strncmp("D6379B1E569701", msg, 14) == 0)){ 
                
                    LedRojo = 0;
                    LedVerde = 1;
                    LedAzul = 0; 
                    wait(2);
                    
                    yolo = in.read()*3.3;
                    vol =in.read();
                    pc.printf("\n%f\n", vol);
                    
                    cleanBuffer(out, 16);
                    if (yolo < 1){
                        strcat(out, "0");
                        ftoa(yolo, OtroOut, 5);
                        strcat(out, OtroOut);
                    }
                    else{
                        ftoa(yolo, out, 5);
                    }
                    strcpy(DEvol,"Voltaje: ");
                    strcat(DEvol,out);
                    pc.printf("\n%s\n\n", DEvol);
                    LENINvol = strlen(DEvol);
                    
                    //Conversión a octetos.
                    K = 0;
                    C = 0;
                    for (i = 0; i < LENINvol; i++){
                        DSvol[i] = DEvol[i + C] >> K | DEvol[i + C + 1] << (7 - K);
                        if(DSvol[i] == 0x00) {LENOUTvol = i; goto salir2;}   
                        K++;
                        if (K == 7) {K = 0; C++;} // se chequea que ya se acabaron los bits en un ciclo de conversion.
                    }
                    
                    salir2:
                        for (i = 0; i < LENINvol; i++){
                            pc.printf("%X", DEvol[i]);
                        }
                    
                        pc.printf(":\r\n");
                        for (i = 0; i < LENOUTvol; i++){
                            pc.printf("%2X", DSvol[i]&0x000000FF);
                        }                        
                        pc.printf("\r\nLENOUT VOLTAJE: %d, LENIN VOLTAJE: %2X\r\n", LENOUTvol, LENINvol);
                    
                    cmgs = 14 + LENOUTvol - 1;
                    
                    GSM.printf("AT+CMGS=%d\r\n",cmgs);
                    pc.printf("AT+CMGS=%d\r\n",cmgs);
                    pc.printf(trama1);
                    GSM.printf(trama1);
                    
                    for (i=0; i <= 9; i++)  {
                        pc.printf("%c",tel[i]);
                        GSM.printf("%c",tel[i]);
                    }
                    
                    pc.printf(trama2);
                    GSM.printf(trama2);
                    pc.printf("%2X", LENINvol);
                    GSM.printf("%2X", LENINvol);
                    
                    for (i = 0; i < LENOUTvol; i++){
                        pc.printf("%02X", DSvol[i]&0x000000FF);
                        GSM.printf("%02X", DSvol[i]&0x000000FF);
                    }
                    
                    wait(1);
                    GSM.putc((char)0x1A);
                    pc.printf("\n");
 
                    wait(2);
                    LedRojo=1;
                    LedVerde=0;
                    GSM.printf("AT+CMGD=0\r\n");
                    }
                    }
                    }
                    }
                    }