/*
   Test thread switching time using semaphore ping-pong

   Hardware: NUCLEO-F767ZI
   Libraries:
     mbed-os-5.12.3
   Measured gpio_out output frequency,
   which contains actually two thread switches:
   6.5 - 7.0 usec (154 kHz - 143 kHz)
*/

#include "mbed.h"

Semaphore semaphore_on(0);
Semaphore semaphore_off(0);

DigitalOut gpio_out(PC_8);

void run_on()
{
    while (true) {
        semaphore_on.wait();
        gpio_out = 1;
        semaphore_off.release();
    }
}

void run_off()
{
    while (true) {
        semaphore_off.wait();
        gpio_out = 0;
        semaphore_on.release();
    }
}

int main()
{
    Thread *thread_on  = new Thread(osPriorityRealtime);
    Thread *thread_off = new Thread(osPriorityRealtime);

    thread_on->start(run_on);
    thread_off->start(run_off);

    semaphore_on.release();

    while (true) {
        wait(0.1); // 100 ns
    }
}
