/*
   Test interrupt response time

   Hardware: NUCLEO-F767ZI
   Libraries:
     mbed-os-5.12.3
   Measured delay between gpio_in and gpio_out
   * rising:  1.1 usec - 1.3 usec
   * falling: 1.1 usec - 1.3 usec
*/

#include "mbed.h"

InterruptIn gpio_in(PC_8);
DigitalOut  gpio_out(PC_9);

void on_fall()
{
    gpio_out = 0;
}

void on_rise()
{
    gpio_out = 1;
}

int main()
{
    gpio_in.fall(&on_fall);
    gpio_in.rise(&on_rise);

    while (1) {
        wait(0.01); // 10 msec
    }
}
