// Author: Stefano Fasciani - stefanofasciani@stefanofasciani.com
// Date 7/8/2016
// FM Sinth for DISCO_F746NG and ADXL345


#include "sinth.h"

ADXL345 accelerometer(D11,D12,D13,D10);
TS_DISCO_F746NG ts;
TS_StateTypeDef TS;
AUDIO_DISCO_F746NG audio;
SDRAM_DISCO_F746NG sdram;
LCD_DISCO_F746NG lcd;
Serial pc(USBTX, USBRX);


//FM Synthesis Initial Parameters
float amplitude = 0.5; //numbers between 0.0 and 1.0
float pitch = 400; // numbers between 50 and 5000
float modrate = 0; // numbers between -1000 and 1000
float moddepth = 0; //numbers between -1000 and 1000
float filter = 1.0f; //numbers between 0.0 (full filter) and 1.0 (do not filter)



void get_parameters(){
        
    char temp_string[20];
    
    //read input data
    ts.GetState(&TS);
    accelerometer.getOutput(acc_readings);
    
    
    if(TS.touchDetected){
        //map to synthesis parameters
        amplitude = 0.5; //map(get_touch_vertical(),0.0,1.0);
    }
    else {
        amplitude = 0;    
    }
    
    
    pitch = get_note_pitch(); //map(get_touch_horizontal(),50.0,5000.0);
    
    modrate = map(get_acc_horizontal(), //input
                    0, //modrate range minimum (not less than -1000)
                    200.0); //modrate range maximum (not higher than 1000)
    
    moddepth = map(get_acc_vertical(), //input
                    -100.0, //moddepth range minimum (not less than -1000)
                    100.0); //moddepth range maximum (not higher than 1000)
    
    
    
    filter = map(get_touch_vertical(), //input
                    0.0, //filter range minimum (not less than 0.0)
                    0.7); //filter range maximum (not higher than 1.0)
    
    
    //update display
    switch(update_round){
    case 0:
        sprintf(temp_string,"%f",amplitude); lcd.DisplayStringAt(250, LINE(1),(uint8_t *)temp_string, LEFT_MODE);
    case 1:
        sprintf(temp_string,"%f",pitch); lcd.DisplayStringAt(250, LINE(3),(uint8_t *)temp_string, LEFT_MODE);
    case 2:
        sprintf(temp_string,"%f",modrate); lcd.DisplayStringAt(250, LINE(5),(uint8_t *)temp_string, LEFT_MODE);
    case 3:
        sprintf(temp_string,"%f",moddepth); lcd.DisplayStringAt(250, LINE(7),(uint8_t *)temp_string, LEFT_MODE);
    case 4:
        sprintf(temp_string,"%f",filter); lcd.DisplayStringAt(250, LINE(9),(uint8_t *)temp_string, LEFT_MODE);
    }
    update_round++;
    if(update_round>4)update_round=0;
    
    return;    
}



int main()
{
    
    //initialize touch screen
    ts.Init(lcd.GetXSize(), lcd.GetYSize());
    wait(0.2);
    
    // lcd initialization to display synthesis parameter
    lcd.Clear(LCD_COLOR_BLACK);
    display_keyboard();
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_LIGHTBLUE);
    lcd.DisplayStringAt(10, LINE(1),(uint8_t *)"AMPLITUDE    :", LEFT_MODE); 
    lcd.DisplayStringAt(10, LINE(3),(uint8_t *)"PITCH (Hz)   :", LEFT_MODE); 
    lcd.DisplayStringAt(10, LINE(5),(uint8_t *)"MOD.RATE (Hz):", LEFT_MODE); 
    lcd.DisplayStringAt(10, LINE(7),(uint8_t *)"MOD.DEPTH    :", LEFT_MODE);
    lcd.DisplayStringAt(10, LINE(9),(uint8_t *)"FILTER       :", LEFT_MODE);
    
    wait(0.2);

    
    //initialize accelerometer
    accelerometer.getDevId();
    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0B);   
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setPowerControl(0x08);
    wait(0.2);

    //sound synthesis initialization
    init_sin_table();
    SetSysClock_PLL_HSE_200MHz();
    pc.baud(9600);
    memset((void *)out_buffer, 0, AUDIO_BLOCK_SIZE*2*sizeof(uint16_t));    
    audio_out_buffer_state = BUFFER_OFFSET_NONE;
    audio.OUT_SetAudioFrameSlot(CODEC_AUDIOFRAME_SLOT_02);
    audio.OUT_Play((uint16_t*)out_buffer, AUDIO_BLOCK_SIZE * 2 * sizeof(int16_t));

  
    while (1) {

        while(audio_out_buffer_state != BUFFER_OFFSET_HALF);
        audio_out_buffer_state = BUFFER_OFFSET_NONE;
        get_parameters();
        sint_osc();
        copy_buffer(0);
        
        
        while(audio_out_buffer_state != BUFFER_OFFSET_FULL);
        audio_out_buffer_state = BUFFER_OFFSET_NONE;
        get_parameters();
        sint_osc();
        copy_buffer(AUDIO_BLOCK_SIZE);
             
    }
}

/*
CONNECTION DISCO_F746NG to ADXL345
D10 -   SS      - CS
D11 -   MOSI    - SDA
D12 -   MISO    - SDO
D13 -   SCK     - SCL
3V3 -   VCC     - VCC
GND -   GND     - GND
*/






