
// Author: Stefano Fasciani - stefanofasciani@stefanofasciani.com
// Date 7/8/2016
// FM Sinth for DISCO_F746NG and ADXL345


#include "mbed.h"
#include "AUDIO_DISCO_F746NG.h"
#include "SDRAM_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "ADXL345.h"
#include <math.h>

#define AUDIO_BLOCK_SIZE    1024
#define TABLE_SIZE          2048

typedef enum{
    BUFFER_OFFSET_NONE = 0,
    BUFFER_OFFSET_HALF = 1,
    BUFFER_OFFSET_FULL = 2,
}BUFFER_StateTypeDef;

float map(float x, float out_min, float out_max);
void sint_osc();
void copy_buffer(int offset);
void init_sin_table();
float get_touch_horizontal();
float get_touch_vertical();
float get_acc_horizontal();
float get_acc_vertical();
void display_keyboard();
float get_note_pitch();
uint8_t SetSysClock_PLL_HSE_200MHz();


extern float table[];
extern int16_t out_buffer[];
extern float osc_buf[];
extern __IO uint32_t  audio_out_buffer_state;
extern float idx_1;
extern float idx_2;
extern float filt_old_samp;
extern float frqTL;
extern float two_pi_48k;
extern int acc_readings[];
extern int update_round;
extern float amplitude;
extern float pitch;
extern float modrate;
extern float moddepth;
extern float filter;
extern TS_StateTypeDef TS;
extern LCD_DISCO_F746NG lcd;
