/* ============== Platform-specific API ===================*/
/* ( HAL - Hardware Abstraction Layer Implementation )     */
/* These functions have to be implemented in actual system */

#include "i2c_api.h"

I2C *mbed_i2c;

// returns 0 on ACK
int8_t _i8I2CWrite(uint8_t u8Cmd, uint8_t *u8Data, uint8_t u8Size)
{
    return mbed_i2c->write(u8Cmd, (const char*) u8Data, u8Size);
}

// returns 0 on ACK
int8_t _i8I2CWriteByte(uint8_t u8Data)
{
    return !mbed_i2c->write(u8Data);        // this sucker returns 1 on ACK so invert it
}

// return 0 on ACK
// NAK ("stop") last byte if u8Repeated == 0
int8_t _i8I2CRead           (uint8_t u8Cmd, uint8_t *u8Data, uint8_t u8Size, uint8_t u8Repeated)
{
    return mbed_i2c->read(u8Cmd, (char*)u8Data, u8Size, u8Repeated);
}

// returns read data
// sends acknowledge if u8Ack == 1
int8_t _i8I2CReadByte       (uint8_t u8Ack)
{
    return mbed_i2c->read(u8Ack);
}

void   _vI2CStart           (void)
{
    mbed_i2c->start();
}

void   _vI2CStop            (void)
{
    mbed_i2c->stop();
}

