#include "mbed.h"
#include "CAN_ID.h"

CAN can1(PB_8, PB_9, 100000);      // PB_8 = CAN_1 RD,   PB_9 = CAN_1 TD
Serial pc(USBTX, USBRX);

class Simulator
{
private:
    char dta1[8];                                 
    int Rpm, TPS, Water_Temp, Air_Temp;      // br. obrtaja, pozicija gasa, temperatura vode, temperatura vazduha
    char dta2[8];
    int MAP, Lambda, Speed, Oil_p;           // pritisak na usisu, , brzina km/h, pritisak ulja
    char dta3[8];
    int Oil_Temp, Volts;                     // temperatura ulja, napon akumulatora
    char dta4[8];
    int Gear;                                // prenosni odnos
    char dta6[8];
    int Crank_Error;                                
    char lvdtfront[8];
    int FL_LVDT, FR_LVDT;                    // prednji levi LVDT, prednji desni LVDT
    char lvdtrear[8];                                                                       
    int RL_LVDT, RR_LVDT;                    // zadnji levi LVDT, zadnji desni LVDT
    char brakes[8];                                                                         
    int Brakes;                              // kocnica
    char distance[8];
    int Distance;                            // kilometraza

    int counter;
    
public:
    Simulator()
    {
        CANMessage msg;
        while(1)
        {
            pc.printf("\n\n1)  Rpm, TPS, Water_temp, Air_temp\n");
            pc.printf("2)  MAP, Lambda, Speed, Oil_p\n");
            pc.printf("3)  Oil_temp, Volts\n");
            pc.printf("4)  Gear\n");
            pc.printf("5)  / \n");
            pc.printf("6)  / \n");
            pc.printf("7)  FL_LVDT, FR_LVDT\n");
            pc.printf("8)  RL_LVDT, RR_LVDT\n");
            pc.printf("9)  Brakes\n");
            pc.printf("10) DISTANCE_ID\n");
            pc.printf("0)  Exit\n\n");
            
            int x;
            pc.scanf("%d",&x);
            
            if(x == 0)
            {
                pc.printf("   :(    \n");
                break;
            }
                
            switch(x)
            {
                case 1:
                    EnterDTA_1();
                    break;
                case 2:
                    EnterDTA_2();
                    break;
                case 3:
                    EnterDTA_3();
                    break;  
                case 4:
                    EnterDTA_4();
                    break;
                case 5:
                    
                    break;
                case 6:
                    
                    break;
                case 7:
                    EnterLVDT_FRONT();
                    break;
                case 8:
                    EnterLVDT_REAR();
                    break;   
                case 9:
                    EnterBRAKES();
                    break; 
                case 10:
                    EnterDISTANCE_ID();
                    break;  
            }
        }         
    }
    
    void send(uint16_t ID, char dta[8]) 
    {
        if(can1.write(CANMessage((uint16_t)ID,dta, 8))) 
        {
            counter++;
            pc.printf("%x\n",ID);
            pc.printf("Message sent: counter=%d, info1=%x%x, info2=%x%x, info3=%x%x, info4=%x%x\n", counter,dta[1],dta[0],dta[3],dta[2],dta[5],dta[4],dta[7],dta[6]);
        }
        else
        pc.printf("Shit\n");
    }   
    
    void EnterDTA_1()
    {   
        pc.printf("Enter Rpm from 0 to 13000 [o/min] :  ");
        pc.scanf("%d", &Rpm); 
        pc.printf("Enter TPS from 0 to 100 [%] :  ");
        pc.scanf("%d", &TPS);  
        pc.printf("Enter Water_Temp from 0 to 120 [stepenC] :  ");
        pc.scanf("%d", &Water_Temp);
        pc.printf("Enter Air_Temp from 0 to 60 [stepenC] :  ");
        pc.scanf("%d", &Air_Temp);
        
        dta1[0]=(uint8_t)(Rpm & 0x00FF);
        dta1[1]=(uint8_t)(Rpm>>8);
        dta1[2]=(uint8_t)(TPS & 0x00FF);
        dta1[3]=(uint8_t)(TPS>>8);
        dta1[4]=(uint8_t)(Water_Temp & 0x00FF);
        dta1[5]=(uint8_t)(Water_Temp>>8);
        dta1[6]=(uint8_t)(Air_Temp & 0x00FF);
        dta1[7]=(uint8_t)(Air_Temp>>8);
        
        send(DTA_1,dta1);   
    }
    
    void EnterDTA_2()
    {
        pc.printf("Enter MAP from 0 to 100 [kPa] :  ");
        pc.scanf("%d", &MAP);  
        pc.printf("Enter Lambda from 0 to 1.3 :  ");
        pc.scanf("%d", &Lambda);
        Lambda *= 1000;         // mnozimo kako bi izbegli razlomljen deo vrednosti
        pc.printf("Enter Speed from 0 to 140 [kmh] :  ");
        pc.scanf("%d", &Speed);
        //pc.printf("Enter Oil_p form   to    [] :  ");
        //pc.scanf("%d", &Oil_p);
        
        dta2[0]=(uint8_t)(MAP & 0x00FF);
        dta2[1]=(uint8_t)(MAP>>8);
        dta2[2]=(uint8_t)(Lambda & 0x00FF);
        dta2[3]=(uint8_t)(Lambda>>8);
        dta2[4]=(uint8_t)(Speed & 0x00FF);
        dta2[5]=(uint8_t)(Speed>>8);
        dta2[6]=0;
        dta2[7]=0;
        
        send(DTA_2,dta2);
    }
    
    void EnterDTA_3()
    {  
        pc.printf("Enter Oil_temp from 0 to 140 [stepenC] :  ");
        pc.scanf("%d", &Oil_Temp);   
        pc.printf("Enter Volts from 10 to 18 [V] :  ");
        pc.scanf("%d", &Volts);
        Volts *= 10;        // mnozimo kako bi izbegli razlomljen deo vrednosti
        
        dta3[0]=0;
        dta3[1]=0;
        dta3[2]=(uint8_t)(Oil_Temp & 0x00FF);
        dta3[3]=(uint8_t)(Oil_Temp>>8);
        dta3[4]=(uint8_t)(Volts & 0x00FF);
        dta3[5]=(uint8_t)(Volts>>8);
        dta3[6]=0;
        dta3[7]=0;
      
        send(DTA_3,dta3);  
    }
    
    void EnterDTA_4()
    {
        pc.printf("Enter Gear from 0 to 6 :  ");
        pc.scanf("%d", &Gear);  
        
        dta4[0]=Gear;
        dta4[1]=0;
        dta4[2]=0;
        dta4[3]=0;
        dta4[4]=0;
        dta4[5]=0;
        dta4[6]=0;
        dta4[7]=0;
        
        send(DTA_4,dta4);  
    }
    void EnterDTA_5();
    
    void EnterDTA_6();
        
    void EnterLVDT_FRONT()
    {
        pc.printf("Enter FL_LVDT from 0 to 100 [%] :  ");
        pc.scanf("%d", &FL_LVDT);
        FL_LVDT *= 10;      // mnozimo kako bi izbegli razlomljen deo vrednosti
        pc.printf("Enter FR_LVDT from 0 to 100 [%] :  ");
        pc.scanf("%d", &FR_LVDT); 
        FR_LVDT *= 10;      // mnozimo kako bi izbegli razlomljen deo vrednosti
        
        lvdtfront[0]=(uint8_t)(FL_LVDT & 0x00FF);
        lvdtfront[1]=(uint8_t)(FL_LVDT>>8);
        lvdtfront[2]=(uint8_t)(FR_LVDT & 0x00FF);
        lvdtfront[3]=(uint8_t)(FR_LVDT>>8);
        lvdtfront[4]=0;
        lvdtfront[5]=0;
        lvdtfront[6]=0;
        lvdtfront[7]=0;
           
        send(LVDT_FRONT,lvdtfront);      
    }
        
    void EnterLVDT_REAR()
    {
        pc.printf("Enter RL_LVDT from 0 to 100 [%] :  ");
        pc.scanf("%d", &RL_LVDT);
        RL_LVDT *= 10;      // mnozimo kako bi izbegli razlomljen deo vrednosti
        pc.printf("Enter RR_LVDT from 0 to 100 [%] :  ");
        pc.scanf("%d", &RR_LVDT); 
        RR_LVDT *= 10;      // mnozimo kako bi izbegli razlomljen deo vrednosti
        
        lvdtrear[0]=(uint8_t)(RL_LVDT & 0x00FF);
        lvdtrear[1]=(uint8_t)(RL_LVDT>>8);
        lvdtrear[2]=(uint8_t)(RR_LVDT & 0x00FF);
        lvdtrear[3]=(uint8_t)(RR_LVDT>>8);
        lvdtrear[4]=0;
        lvdtrear[5]=0;
        lvdtrear[6]=0;
        lvdtrear[7]=0;

        send(LVDT_REAR,lvdtrear);    
    }
    
    void EnterBRAKES()
    {
        pc.printf("Enter Brakes from 0 to 100 [%] :  ");
        pc.scanf("%d", &Brakes);
        
        if((Brakes/10)%2)
        {
            brakes[0]=0xFF;
            brakes[1]=0xFF;
            brakes[2]=0;
            brakes[3]=0;
            brakes[4]=0;
            brakes[5]=0;
            brakes[6]=0;
            brakes[7]=0;
        }
        else
        {
            brakes[0]=0;
            brakes[1]=0;
            brakes[2]=0;
            brakes[3]=0;
            brakes[4]=0;
            brakes[5]=0;
            brakes[6]=0;
            brakes[7]=0;
        };
            
        send(BRAKES,brakes); 
    }
    
    void EnterDISTANCE_ID()
    {
        pc.printf("Enter distance from 0 to 100000 [km] :  ");
        pc.scanf("%d", &Distance);
        
        distance[0]=(uint8_t) (Distance & 0x000000FF);
        distance[1]=(uint8_t)((Distance & 0x0000FF00)>>8);
        distance[2]=(uint8_t)((Distance & 0x00FF0000)>>16);
        distance[3]=(uint8_t)((Distance & 0xFF000000)>>24);
        distance[4]=0;
        distance[5]=0;
        distance[6]=0;
        distance[7]=0;
           
        send(DISTANCE_ID,distance);    
    }   
};
    