#include "LCD_DISCO_F469NI.h"

#define BYTE_TO_BINARY_PATTERN "%c%c%c%c%c%c%c%c"              // Pattern which converts uint8_t to binary(array of 8 chars)
#define BYTE_TO_BINARY(byte)\
  (byte & 0x80 ? '1' : '0'),\
  (byte & 0x40 ? '1' : '0'),\
  (byte & 0x20 ? '1' : '0'),\
  (byte & 0x10 ? '1' : '0'),\
  (byte & 0x08 ? '1' : '0'),\
  (byte & 0x04 ? '1' : '0'),\
  (byte & 0x02 ? '1' : '0'),\
  (byte & 0x01 ? '1' : '0')

typedef struct BlackWhiteImage 
{                                                  
    char name;
    uint16_t width;
    uint16_t height;
    uint8_t *bitmap;
} GEAR,CHAR;

extern uint8_t change_flag;
extern uint8_t screen_flag;                          // Current screen flag. 1=Main Screen, 2=Aux Screen 

extern uint16_t gearValue;
extern uint16_t tpsValue;
extern uint16_t brakeValue;
extern uint16_t oilTempValue;
extern uint16_t waterTempValue;
extern uint16_t speedValue;

// Positions of Informations on screen
const uint16_t gearXVPos=750, gearYVPos=112;
const uint16_t tpsXPos=345, tpsYPos=4;
const uint16_t brakeXPos=345, brakeYPos=362;
const uint16_t oilTempXPos=270, oilTempYPos=2;
const uint16_t waterTempXPos=270, waterTempYPos=260;
const uint16_t speedXPos=115, speedYPos=80;



void PrintChar_24(CHAR Char, uint16_t StartXPos, uint16_t StartYPos, uint32_t TextColor);                                               // Print Char 24 function - vertical  
void PrintChar(CHAR Char, uint16_t StartXPos, uint16_t StartYPos, uint32_t TextColor);                                                  // Print Char 50 and Char 100 function - vertical
void PrintString(char str[], uint8_t font, uint16_t StartXPos, uint16_t StartYPos, uint32_t TextColor);                                 // Print String (all Char) function - vertical
void SetNumber(int num,int Font,uint16_t StartXPos,uint16_t StartYPos, int digits, int dec_point, int sign);                            // Set number to specific value function - vertical
void ChangeNumber(int num, int num0, uint8_t font, uint16_t StartXPos, uint16_t StartYPos, int digits, int dec_point, int sign);        // Update number function
void DrawTpsBar(void);                                                                                                                  // Draw TPS bar function
void DrawBrakeBar(void);                                                                                                                // Draw BRAKE bar function
void UpdateTpsBar(uint16_t tpsValue);                                                                                                   // Update TPS bar function    
void UpdateBrakeBar(uint16_t brakeValue);                                                                                               // Update BRAKE bar function

void ChangeCommand(void);                                                                                                               // Interrupt function for registering change command
void ChangeScreen(void);                                                                                                                // Changes the screen if needed

void SetMain(void);                                                                                                                     // Set Main Screen function
void SetAux(void);                                                                                                                      // Set Aux Screen function









